/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFQuote;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFQuote {
    @Test
    public void testQuote() throws HiveException {
        GenericUDFQuote udf = new GenericUDFQuote();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        this.runAndVerify("", "''", (GenericUDF)udf);
        this.runAndVerify(" ", "' '", (GenericUDF)udf);
        this.runAndVerify("'", "'\\''", (GenericUDF)udf);
        this.runAndVerify("DONT", "'DONT'", (GenericUDF)udf);
        this.runAndVerify(" DON'T", "' DON\\'T'", (GenericUDF)udf);
        this.runAndVerify("DON\\'T", "'DON\\\\'T'", (GenericUDF)udf);
    }

    private void runAndVerify(String str, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        Text output = (Text)udf.evaluate(args);
        if (expResult != null) {
            Assert.assertEquals((String)"quote() test ", (Object)expResult, (Object)output.toString());
        } else {
            Assert.assertNull((String)"quote() test ", (Object)output.toString());
        }
    }
}

