/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFPower {
    private static final double EPSILON = 1.0E-10;

    @Test
    public void testBytePowerShort() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        ByteWritable left = new ByteWritable(2);
        ShortWritable right = new ShortWritable(4);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)16.0, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testVarcharPowerInt() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        HiveVarcharWritable left = new HiveVarcharWritable();
        left.set("3.14");
        IntWritable right = new IntWritable(2);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)9.8596, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testDoublePowerLong() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        DoubleWritable left = new DoubleWritable(4.5);
        LongWritable right = new LongWritable(4L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)410.0625, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testLongPowerDecimal() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        LongWritable left = new LongWritable(10L);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"3.14"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)4))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)1380.3842646028852, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testFloatPowerFloat() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(-1.5f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)0.10475656017578482, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testShortPowerFloat() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        ShortWritable base = new ShortWritable(23);
        FloatWritable power = new FloatWritable(-1.5f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableShortObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)base), new GenericUDF.DeferredJavaObject((Object)power)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)0.009065844089438033, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testDoulePowerDecimal() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        DoubleWritable left = new DoubleWritable(-4.52);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"3"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"Unexpected result", (double)-92.34540799999996, (double)res.get(), (double)1.0E-10);
    }

    @Test
    public void testDecimalPowerDecimal() throws HiveException {
        GenericUDFPower udf = new GenericUDFPower();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"14.5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"-3.2"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)1.9214203800477838E-4, (double)res.get(), (double)1.0E-10);
    }
}

