/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTestGenericUDFOPNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPDivide
extends AbstractTestGenericUDFOPNumeric {
    private static final double EPSILON = 1.0E-6;

    @Test
    public void testByteDivideShort() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        ByteWritable left = new ByteWritable(4);
        ShortWritable right = new ShortWritable(6);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)6));
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"0.666667"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testVarcharDivideInt() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        HiveVarcharWritable left = new HiveVarcharWritable();
        left.set("123");
        IntWritable right = new IntWritable(456);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)0.26973684210526316, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDoubleDivideLong() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        DoubleWritable left = new DoubleWritable(4.5);
        LongWritable right = new LongWritable(10L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)0.45, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testLongDivideDecimal() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        LongWritable left = new LongWritable(104L);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)4))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)33, (int)10), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"0.4426096949"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testFloatDivideFloat() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(1.5f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)3.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDouleDivideDecimal() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        DoubleWritable left = new DoubleWritable(74.52);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((double)0.31714686981316764, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDecimalDivideDecimal() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"14.5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)11, (int)7), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"0.06171"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testDecimalDivideDecimal2() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"25"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)1, (int)0)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)2, (int)0))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)7, (int)6), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"0.2"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testDecimalDivideDecimalSameParams() throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)13, (int)8), (Object)oi.getTypeInfo());
    }

    @Test
    public void testDecimalDivisionResultType() throws HiveException {
        this.testDecimalDivisionResultType(5, 2, 3, 2, 11, 6);
        this.testDecimalDivisionResultType(38, 18, 38, 18, 38, 6);
        this.testDecimalDivisionResultType(38, 18, 20, 0, 38, 18);
        this.testDecimalDivisionResultType(20, 0, 8, 5, 34, 9);
        this.testDecimalDivisionResultType(10, 0, 10, 0, 21, 11);
        this.testDecimalDivisionResultType(5, 2, 5, 5, 16, 8);
        this.testDecimalDivisionResultType(10, 10, 5, 0, 16, 16);
        this.testDecimalDivisionResultType(10, 10, 5, 5, 21, 16);
        this.testDecimalDivisionResultType(38, 38, 38, 38, 38, 6);
        this.testDecimalDivisionResultType(38, 0, 38, 0, 38, 6);
    }

    private void testDecimalDivisionResultType(int prec1, int scale1, int prec2, int scale2, int prec3, int scale3) throws HiveException {
        GenericUDFOPDivide udf = new GenericUDFOPDivide();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)prec1, (int)scale1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)prec2, (int)scale2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)prec3, (int)scale3), (Object)oi.getTypeInfo());
    }

    @Test
    public void testReturnTypeBackwardCompat() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "0.12");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "int", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "float", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "decimal(10,2)", "decimal(23,11)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "float", "float", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "float", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "decimal(10,2)", "decimal(10,2)", "decimal(23,13)");
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
    }

    @Test
    public void testReturnTypeAnsiSql() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "int", "decimal(21,11)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "float", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "int", "decimal(10,2)", "decimal(23,11)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "float", "float", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "float", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPDivide(), "decimal(10,2)", "decimal(10,2)", "decimal(23,13)");
    }
}

