/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNextDay;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFNextDay {
    @Test
    public void testNextDay() throws HiveException {
        GenericUDFNextDay udf = new GenericUDFNextDay();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("2015-01-11", "su", "2015-01-18", (GenericUDF)udf);
        this.runAndVerify("2015-01-11", "MO", "2015-01-12", (GenericUDF)udf);
        this.runAndVerify("2015-01-11", "Tu", "2015-01-13", (GenericUDF)udf);
        this.runAndVerify("2015-01-11", "wE", "2015-01-14", (GenericUDF)udf);
        this.runAndVerify("2015-01-11", "th", "2015-01-15", (GenericUDF)udf);
        this.runAndVerify("2015-01-11", "FR", "2015-01-16", (GenericUDF)udf);
        this.runAndVerify("2015-01-11", "Sa", "2015-01-17", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "sun", "2015-01-18", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "MON", "2015-01-19", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "Tue", "2015-01-20", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "weD", "2015-01-21", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "tHu", "2015-01-22", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "FrI", "2015-01-23", (GenericUDF)udf);
        this.runAndVerify("2015-01-17", "SAt", "2015-01-24", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34", "sunday", "2015-01-18", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34.1", "Monday", "2015-01-19", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34.100", "Tuesday", "2015-01-20", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34.001", "wednesday", "2015-01-21", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34.000000001", "thursDAY", "2015-01-15", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34", "FRIDAY", "2015-01-16", (GenericUDF)udf);
        this.runAndVerify("2015-01-14 14:04:34", "SATurday", "2015-01-17", (GenericUDF)udf);
        this.runAndVerify("2015-01-14", null, null, (GenericUDF)udf);
        this.runAndVerify(null, "SU", null, (GenericUDF)udf);
        this.runAndVerify(null, null, null, (GenericUDF)udf);
    }

    @Test
    public void testNotValidValues() throws Exception {
        GenericUDFNextDay udf = new GenericUDFNextDay();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("01/14/2015", "TU", null, (GenericUDF)udf);
        this.runAndVerify("2015-01-14", "VT", null, (GenericUDF)udf);
        this.runAndVerify("2015-02-30", "WE", null, (GenericUDF)udf);
        this.runAndVerify("2015-02-32", "WE", null, (GenericUDF)udf);
        this.runAndVerify("2015-02-30 10:30:00", "WE", null, (GenericUDF)udf);
        this.runAndVerify("2015-02-32 10:30:00", "WE", null, (GenericUDF)udf);
        this.runAndVerify("2015/01/14 14:04:34", "SAT", null, (GenericUDF)udf);
        this.runAndVerify("2015-01-14T14:04:34", "SAT", "2015-01-17", (GenericUDF)udf);
    }

    @Test
    public void testNextDayErrorArg1() throws HiveException {
        GenericUDFNextDay udf = new GenericUDFNextDay();
        WritableLongObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"UDFArgumentException expected", (boolean)false);
        }
        catch (UDFArgumentException e) {
            Assert.assertEquals((Object)"next_day only takes STRING_GROUP, DATE_GROUP, VOID_GROUP types as 1st argument, got LONG", (Object)e.getMessage());
        }
    }

    @Test
    public void testNextDayErrorArg2() throws HiveException {
        GenericUDFNextDay udf = new GenericUDFNextDay();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            Assert.assertTrue((String)"UDFArgumentException expected", (boolean)false);
        }
        catch (UDFArgumentException e) {
            Assert.assertEquals((Object)"next_day only takes STRING_GROUP, VOID_GROUP types as 2nd argument, got INT", (Object)e.getMessage());
        }
    }

    private void runAndVerify(String date, String dayOfWeek, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(date != null ? new Text(date) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)(dayOfWeek != null ? new Text(dayOfWeek) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        Text output = (Text)udf.evaluate(args);
        Assert.assertEquals((String)"next_day() test ", (Object)expResult, (Object)(output != null ? output.toString() : null));
    }
}

