/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMonthsBetween;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFMonthsBetween {
    @Test
    public void testMonthsBetweenForString() throws HiveException {
        GenericUDFMonthsBetween udf = new GenericUDFMonthsBetween();
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        this.testMonthsBetweenForString(udf);
        GenericUDFMonthsBetween udfWithoutRoundOff = new GenericUDFMonthsBetween();
        WritableStringObjectInspector vOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector vOI2 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ConstantObjectInspector vOI3 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)new BooleanWritable(false));
        ObjectInspector[] args = new ObjectInspector[]{vOI1, vOI2, vOI3};
        udfWithoutRoundOff.initialize(args);
        this.testMonthsBetweenForString(udf);
    }

    @Test
    public void testWrongDateStr() throws HiveException {
        GenericUDFMonthsBetween udf = new GenericUDFMonthsBetween();
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        this.runTestStr("2002-03", "2002-02-24", null, udf);
        this.runTestStr("2002-03-24", "2002-02", null, udf);
        this.runTestStr("2002-02-31", "2002-03-01", null, udf);
    }

    public void testMonthsBetweenForString(GenericUDFMonthsBetween udf) throws HiveException {
        this.runTestStr("1995-02-02", "1995-01-01", 1.03225806, udf);
        this.runTestStr("2003-07-17", "2005-07-06", -23.64516129, udf);
        this.runTestStr("2001-06-30", "2000-05-31", 13.0, udf);
        this.runTestStr("2000-06-01", "2004-07-01", -49.0, udf);
        this.runTestStr("2002-02-28", "2002-03-01", -0.12903226, udf);
        this.runTestStr("2012-02-29", "2012-03-01", -0.09677419, udf);
        this.runTestStr("2012-02-31", "2012-03-01", null, udf);
        this.runTestStr("1976-01-01 00:00:00", "1975-12-31 23:59:59", 3.7E-7, udf);
        this.runTestStr("1997-02-28 10:30:00", "1996-10-30", 3.94959677, udf);
        this.runTestStr("1996-10-30", "1997-02-28 10:30:00", -3.94959677, udf);
        this.runTestStr("2002-03-31", "2002-02-28", 1.0, udf);
        this.runTestStr("2002-03-31", "2002-02-28 10:30:00", 1.0, udf);
        this.runTestStr("2002-03-31 10:30:00", "2002-02-28", 1.0, udf);
        this.runTestStr("2002-03-24", "2002-02-24", 1.0, udf);
        this.runTestStr("2002-03-24", "2002-02-24 10:30:00", 1.0, udf);
        this.runTestStr("2002-03-24 10:30:00", "2002-02-24", 1.0, udf);
        this.runTestStr("1995-02-02 10:39", "1995-01-01", 1.03225806, udf);
        this.runTestStr("1995-02-02", "1995-01-01 10:39", 1.03225806, udf);
        this.runTestStr("1995-02-2", "1995-1-01", 1.03225806, udf);
        this.runTestStr("1995-2-02", "1995-01-1", 1.03225806, udf);
        this.runTestStr("495-2-02", "495-01-1", 1.03225806, udf);
        this.runTestStr("95-2-02", "95-01-1", 1.03225806, udf);
        this.runTestStr("5-2-02", "5-01-1", 1.03225806, udf);
        this.runTestStr(null, "2002-03-01", null, udf);
        this.runTestStr("2002-02-28", null, null, udf);
        this.runTestStr(null, null, null, udf);
        this.runTestStr("2003-04-23", "2002-04-24", 11.96774194, udf);
        this.runTestStr("1582-10-05", "1582-11-05", -1.0, udf);
    }

    @Test
    public void testMonthsBetweenForTimestamp() throws HiveException {
        GenericUDFMonthsBetween udf = new GenericUDFMonthsBetween();
        WritableTimestampObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        WritableTimestampObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        this.testMonthsBetweenForTimestamp(udf);
        GenericUDFMonthsBetween udfWithoutRoundOff = new GenericUDFMonthsBetween();
        WritableTimestampObjectInspector vOI1 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        WritableTimestampObjectInspector vOI2 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        ConstantObjectInspector vOI3 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)new BooleanWritable(false));
        ObjectInspector[] args = new ObjectInspector[]{vOI1, vOI2, vOI3};
        udfWithoutRoundOff.initialize(args);
        this.testMonthsBetweenForTimestamp(udfWithoutRoundOff);
    }

    public void testMonthsBetweenForTimestamp(GenericUDFMonthsBetween udf) throws HiveException {
        this.runTestTs("1995-02-02 00:00:00", "1995-01-01 00:00:00", 1.03225806, udf);
        this.runTestTs("2003-07-17 00:00:00", "2005-07-06 00:00:00", -23.64516129, udf);
        this.runTestTs("2001-06-30 00:00:00", "2000-05-31 00:00:00", 13.0, udf);
        this.runTestTs("2000-06-01 00:00:00", "2004-07-01 00:00:00", -49.0, udf);
        this.runTestTs("2002-02-28 00:00:00", "2002-03-01 00:00:00", -0.12903226, udf);
        this.runTestTs("2012-02-29 00:00:00", "2012-03-01 00:00:00", -0.09677419, udf);
        this.runTestTs("1976-01-01 00:00:00", "1975-12-31 23:59:59", 3.7E-7, udf);
        this.runTestTs("1997-02-28 10:30:00", "1996-10-30 00:00:00", 3.94959677, udf);
        this.runTestTs("1996-10-30 00:00:00", "1997-02-28 10:30:00", -3.94959677, udf);
        this.runTestTs("2002-03-31 00:00:00", "2002-02-28 00:00:00", 1.0, udf);
        this.runTestTs("2002-03-31 00:00:00", "2002-02-28 10:30:00", 1.0, udf);
        this.runTestTs("2002-03-31 10:30:00", "2002-02-28 00:00:00", 1.0, udf);
        this.runTestTs("2002-03-24 00:00:00", "2002-02-24 00:00:00", 1.0, udf);
        this.runTestTs("2002-03-24 00:00:00", "2002-02-24 10:30:00", 1.0, udf);
        this.runTestTs("2002-03-24 10:30:00", "2002-02-24 00:00:00", 1.0, udf);
        this.runTestTs("2003-04-23 23:59:59", "2003-03-24 00:00:00", 0.99999963, udf);
    }

    @Test
    public void testMonthsBetweenForDate() throws HiveException {
        GenericUDFMonthsBetween udf = new GenericUDFMonthsBetween();
        WritableDateObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        WritableDateObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        this.testMonthsBetweenForDate(udf);
        GenericUDFMonthsBetween udfWithoutRoundOff = new GenericUDFMonthsBetween();
        WritableDateObjectInspector vOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        WritableDateObjectInspector vOI2 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        ConstantObjectInspector vOI3 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)new BooleanWritable(false));
        ObjectInspector[] args = new ObjectInspector[]{vOI1, vOI2, vOI3};
        udfWithoutRoundOff.initialize(args);
        this.testMonthsBetweenForDate(udfWithoutRoundOff);
    }

    public void testMonthsBetweenForDate(GenericUDFMonthsBetween udf) throws HiveException {
        this.runTestDt("1995-02-02", "1995-01-01", 1.03225806, udf);
        this.runTestDt("2003-07-17", "2005-07-06", -23.64516129, udf);
        this.runTestDt("2001-06-30", "2000-05-31", 13.0, udf);
        this.runTestDt("2000-06-01", "2004-07-01", -49.0, udf);
        this.runTestDt("2002-02-28", "2002-03-01", -0.12903226, udf);
        this.runTestDt("2012-02-29", "2012-03-01", -0.09677419, udf);
        this.runTestDt(null, "2002-03-01", null, udf);
        this.runTestDt("2002-02-28", null, null, udf);
        this.runTestDt(null, null, null, udf);
    }

    protected void runTestStr(String date1, String date2, Double expDiff, GenericUDFMonthsBetween udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)(date1 == null ? null : new Text(date1)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)(date2 == null ? null : new Text(date2)));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        if (expDiff == null) {
            Assert.assertNull((String)"months_between() test for NULL STRING failed", (Object)output);
        } else {
            Assert.assertNotNull((String)"months_between() test for NOT NULL STRING failed", (Object)output);
            Assert.assertEquals((String)"months_between() test for STRING failed", (double)expDiff, (double)output.get(), (double)1.0E-8);
        }
    }

    protected void runTestTs(String ts1, String ts2, Double expDiff, GenericUDFMonthsBetween udf) throws HiveException {
        TimestampWritableV2 tsWr1 = ts1 == null ? null : new TimestampWritableV2(Timestamp.valueOf((String)ts1));
        TimestampWritableV2 tsWr2 = ts2 == null ? null : new TimestampWritableV2(Timestamp.valueOf((String)ts2));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)tsWr1);
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)tsWr2);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        if (expDiff == null) {
            Assert.assertNull((String)"months_between() test for NULL TIMESTAMP failed", (Object)output);
        } else {
            Assert.assertNotNull((String)"months_between() test for NOT NULL TIMESTAMP failed", (Object)output);
            Assert.assertEquals((String)"months_between() test for TIMESTAMP failed", (double)expDiff, (double)output.get(), (double)1.0E-8);
        }
    }

    protected void runTestDt(String dt1, String dt2, Double expDiff, GenericUDFMonthsBetween udf) throws HiveException {
        DateWritableV2 dtWr1 = dt1 == null ? null : new DateWritableV2(Date.valueOf((String)dt1));
        DateWritableV2 dtWr2 = dt2 == null ? null : new DateWritableV2(Date.valueOf((String)dt2));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)dtWr1);
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)dtWr2);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        if (expDiff == null) {
            Assert.assertNull((String)"months_between() test for NULL DATE failed", (Object)output);
        } else {
            Assert.assertNotNull((String)"months_between() test for NOT NULL DATE failed", (Object)output);
            Assert.assertEquals((String)"months_between() test for DATE failed", (double)expDiff, (double)output.get(), (double)1.0E-8);
        }
    }
}

