/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLpad;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFLpad {
    @Test
    public void testLpad() throws HiveException {
        GenericUDFLpad udf = new GenericUDFLpad();
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableIntObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        WritableStringObjectInspector valueOI3 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2, valueOI3};
        udf.initialize(arguments);
        this.runAndVerify("hi", 5, "??", "???hi", (GenericUDF)udf);
        this.runAndVerify("hi", 1, "??", "h", (GenericUDF)udf);
        this.runAndVerify("\uff48\uff49", 5, "\uff1f\uff1f", "\uff1f\uff1f\uff1f\uff48\uff49", (GenericUDF)udf);
        this.runAndVerify("\uff48\uff49", 1, "\uff1f\uff1f", "\uff48", (GenericUDF)udf);
        this.runAndVerify("hi", 3, "", null, (GenericUDF)udf);
    }

    private void runAndVerify(String str, int len, String pad, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)new IntWritable(len));
        GenericUDF.DeferredJavaObject valueObj3 = new GenericUDF.DeferredJavaObject((Object)new Text(pad));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2, valueObj3};
        Object output = udf.evaluate(args);
        if (expResult != null) {
            Assert.assertEquals((String)"lpad() test ", (Object)expResult, (Object)output.toString());
        } else {
            Assert.assertNull((String)"lpad() test ", (Object)output);
        }
    }
}

