/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGreatest;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeast;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableVoidObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFLeast {
    @Test
    public void testOneArg() throws HiveException {
        GenericUDFLeast udf = new GenericUDFLeast();
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1};
        UDFArgumentException ex = null;
        try {
            udf.initialize(arguments);
        }
        catch (UDFArgumentException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"least() test ", (Object)((Object)ex));
    }

    @Test
    public void testVoids() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        WritableVoidObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
        WritableIntObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        WritableStringObjectInspector valueOI3 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2, valueOI3};
        udf.initialize(arguments);
        this.runAndVerify(new Object[]{null, 1, "test"}, null, (GenericUDF)udf);
    }

    @Test
    public void testLeastTypes() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        WritableDoubleObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        WritableDateObjectInspector valueOI3 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        WritableStringObjectInspector valueOI4 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2, valueOI3, valueOI4};
        udf.initialize(arguments);
        this.runAndVerify(new Object[]{1, 11.1, Date.valueOf((String)"2015-03-20"), "test"}, "test", (GenericUDF)udf);
    }

    @Test
    public void testLeastStr() throws HiveException {
        GenericUDFLeast udf = new GenericUDFLeast();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        udf.initialize(arguments);
        this.runAndVerify(new String[]{"a", "b", "c"}, "a", (GenericUDF)udf);
        this.runAndVerify(new String[]{"C", "a", "B"}, "B", (GenericUDF)udf);
        this.runAndVerify(new String[]{"AAA", "AaA", "AAa"}, "AAA", (GenericUDF)udf);
        this.runAndVerify(new String[]{"A", "AA", "AAA"}, "A", (GenericUDF)udf);
        this.runAndVerify(new String[]{"11", "13", "12"}, "11", (GenericUDF)udf);
        this.runAndVerify(new String[]{"11", "2", "12"}, "11", (GenericUDF)udf);
        this.runAndVerify(new String[]{"01", "03", "02"}, "01", (GenericUDF)udf);
        this.runAndVerify(new String[]{"01", "1", "02"}, "01", (GenericUDF)udf);
        this.runAndVerify(new String[]{null, "b", "c"}, null, (GenericUDF)udf);
        this.runAndVerify(new String[]{"a", null, "c"}, null, (GenericUDF)udf);
        this.runAndVerify(new String[]{"a", "b", null}, null, (GenericUDF)udf);
        this.runAndVerify(new String[]{"a", null, null}, null, (GenericUDF)udf);
        this.runAndVerify(new String[]{null, "b", null}, null, (GenericUDF)udf);
        this.runAndVerify(new String[]{null, null, null}, null, (GenericUDF)udf);
    }

    @Test
    public void testLeastInt() throws HiveException {
        GenericUDFLeast udf = new GenericUDFLeast();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        udf.initialize(arguments);
        this.runAndVerify(new Integer[]{11, 13, 12}, 11, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, 13, 2}, 1, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{-11, -13, -12}, -13, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, -13, 2}, -13, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{null, 1, 2}, null, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, null, 2}, null, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, 2, null}, null, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{null, null, null}, null, (GenericUDF)udf);
    }

    @Test
    public void testLeastDouble() throws HiveException {
        GenericUDFLeast udf = new GenericUDFLeast();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        udf.initialize(arguments);
        this.runAndVerify(new Double[]{11.4, 11.5, 11.2}, 11.2, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.0, 13.3, 2.0}, 1.0, (GenericUDF)udf);
        this.runAndVerify(new Double[]{-11.4, -13.1, -12.2}, -13.1, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.0, -13.3, 2.2}, -13.3, (GenericUDF)udf);
        this.runAndVerify(new Double[]{null, 1.1, 2.2}, null, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.1, null, 2.2}, null, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.1, 2.2, null}, null, (GenericUDF)udf);
        this.runAndVerify(new Double[]{null, null, null}, null, (GenericUDF)udf);
    }

    @Test
    public void testLeastDate() throws HiveException {
        GenericUDFLeast udf = new GenericUDFLeast();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        udf.initialize(arguments);
        Date d1 = Date.valueOf((String)"2015-03-20");
        Date d2 = Date.valueOf((String)"2015-03-21");
        Date d3 = Date.valueOf((String)"2014-03-20");
        this.runAndVerify(new Date[]{d1, d2, d3}, d3, (GenericUDF)udf);
        this.runAndVerify(new Date[]{null, d2, d3}, null, (GenericUDF)udf);
        this.runAndVerify(new Date[]{d1, null, d3}, null, (GenericUDF)udf);
        this.runAndVerify(new Date[]{d1, d2, null}, null, (GenericUDF)udf);
        this.runAndVerify(new Date[]{null, null, null}, null, (GenericUDF)udf);
    }

    @Test
    public void testLeastIntTypes() throws HiveException {
        GenericUDFLeast udf = new GenericUDFLeast();
        ObjectInspector[] arguments = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        udf.initialize(arguments);
        this.runAndVerify(new Object[]{(byte)11, (short)13, 12, 14L}, 11L, (GenericUDF)udf);
        this.runAndVerify(new Object[]{(byte)1, (short)13, 2, 0L}, 0L, (GenericUDF)udf);
        this.runAndVerify(new Object[]{(byte)-11, (short)-13, -12, 0L}, -13L, (GenericUDF)udf);
        this.runAndVerify(new Object[]{(byte)1, (short)-13, 2, 0L}, -13L, (GenericUDF)udf);
        this.runAndVerify(new Object[]{null, (short)1, 2, 0L}, null, (GenericUDF)udf);
        this.runAndVerify(new Object[]{(byte)1, null, 2, -1L}, null, (GenericUDF)udf);
        this.runAndVerify(new Object[]{(byte)1, (short)2, null, -1L}, null, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{null, null, null, null}, null, (GenericUDF)udf);
    }

    private void runAndVerify(Object[] v, Object expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[v.length];
        for (int i = 0; i < v.length; ++i) {
            args[i] = new GenericUDF.DeferredJavaObject(this.getWritable(v[i]));
        }
        Object output = udf.evaluate(args);
        Assert.assertEquals((String)"greatest() test ", (Object)expResult, (Object)((output = this.parseOutput(output)) != null ? output : null));
    }

    private Object getWritable(Object o) {
        if (o instanceof String) {
            return o != null ? new Text((String)o) : null;
        }
        if (o instanceof Integer) {
            return o != null ? new IntWritable(((Integer)o).intValue()) : null;
        }
        if (o instanceof Double) {
            return o != null ? new DoubleWritable(((Double)o).doubleValue()) : null;
        }
        if (o instanceof Date) {
            return o != null ? new DateWritableV2((Date)o) : null;
        }
        if (o instanceof Byte) {
            return o != null ? new ByteWritable(((Byte)o).byteValue()) : null;
        }
        if (o instanceof Short) {
            return o != null ? new ShortWritable(((Short)o).shortValue()) : null;
        }
        if (o instanceof Long) {
            return o != null ? new LongWritable(((Long)o).longValue()) : null;
        }
        return null;
    }

    private Object parseOutput(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text) {
            return o.toString();
        }
        if (o instanceof IntWritable) {
            return ((IntWritable)o).get();
        }
        if (o instanceof DoubleWritable) {
            return ((DoubleWritable)o).get();
        }
        if (o instanceof DateWritableV2) {
            return ((DateWritableV2)o).get();
        }
        if (o instanceof ByteWritable) {
            return ((ByteWritable)o).get();
        }
        if (o instanceof ShortWritable) {
            return ((ShortWritable)o).get();
        }
        if (o instanceof LongWritable) {
            return ((LongWritable)o).get();
        }
        return null;
    }
}

