/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFJsonRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFJsonRead {
    @Test(expected=UDFArgumentException.class)
    public void testArgCnt1() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
            udf.initialize(arguments);
        }
    }

    @Test(expected=UDFArgumentException.class)
    public void testArgCnt3() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            ObjectInspector[] arguments = new ObjectInspector[]{valueOI, valueOI};
            udf.initialize(arguments);
        }
    }

    @Test(expected=UDFArgumentException.class)
    public void testArgInvalidType() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("__invalid__type__");
            udf.initialize(arguments);
        }
    }

    @Test
    public void testList() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("array<string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs("[\"a\",\"b\",null]"));
            Assert.assertTrue((boolean)(res instanceof List));
            List l = (List)res;
            Assert.assertEquals((long)3L, (long)l.size());
            Assert.assertEquals((Object)new Text("a"), l.get(0));
            Assert.assertEquals((Object)new Text("b"), l.get(1));
            Assert.assertEquals(null, l.get(2));
        }
    }

    @Test
    public void testListNull() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("array<string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs("null"));
            Assert.assertNull((Object)res);
        }
    }

    @Test
    public void testSimpleStruct() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("struct<a:string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs("{\"a\":\"b\"}"));
            Assert.assertTrue((boolean)(res instanceof List));
            List o = (List)res;
            Assert.assertEquals((Object)new Text("b"), o.get(0));
        }
    }

    @Test
    public void testStructNullField() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("struct<a:string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs("{\"a\":null}"));
            Assert.assertTrue((boolean)(res instanceof List));
            List o = (List)res;
            Assert.assertEquals(null, o.get(0));
        }
    }

    @Test
    public void testStructEmptyString() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("struct<a:string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs(""));
            Assert.assertNull((Object)res);
        }
    }

    @Test
    public void testStructNull() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("struct<a:string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), null});
            Assert.assertNull((Object)res);
        }
    }

    @Test
    public void testStructNullComplexField() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("struct<a:struct<x:string>>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs("{\"a\":null}"));
            Assert.assertTrue((boolean)(res instanceof List));
            List o = (List)res;
            Assert.assertEquals(null, o.get(0));
        }
    }

    @Test(expected=HiveException.class)
    public void testUndeclaredStructField() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("struct<a:int>");
            udf.initialize(arguments);
            udf.evaluate(this.evalArgs("{\"b\":null}"));
        }
    }

    @Test(expected=HiveException.class)
    public void testUnexpectedStruct() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("array<int>");
            udf.initialize(arguments);
            udf.evaluate(this.evalArgs("[1,22,2,{\"b\":null}]"));
        }
    }

    @Test
    public void testMap() throws Exception {
        try (GenericUDFJsonRead udf = new GenericUDFJsonRead();){
            ObjectInspector[] arguments = this.buildArguments("map<string,string>");
            udf.initialize(arguments);
            Object res = udf.evaluate(this.evalArgs("{\"a\":\"v\"}"));
            Assert.assertTrue((boolean)(res instanceof Map));
            Map o = (Map)res;
            Assert.assertEquals((long)1L, (long)o.size());
            Assert.assertEquals((Object)new Text("v"), o.get(new Text("a")));
        }
    }

    private GenericUDF.DeferredObject[] evalArgs(String string) {
        return new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new Text(string)), null};
    }

    private ObjectInspector[] buildArguments(String typeStr) {
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI, PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)new Text(typeStr))};
        return arguments;
    }
}

