/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestGenericUDFInitializeOnCompareUDF {
    /*
     * WARNING - void declaration
     */
    private static Collection<UDFArguments> generateArguments() {
        void var4_6;
        ArrayList<UDFArguments> arguments = new ArrayList<UDFArguments>();
        ArrayList<AbstractPrimitiveJavaObjectInspector> primitives = new ArrayList<AbstractPrimitiveJavaObjectInspector>();
        PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategoryArray = PrimitiveObjectInspector.PrimitiveCategory.values();
        int n = primitiveCategoryArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveCategoryArray[var4_6];
            if (primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN) {
                primitives.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)primitiveCategory));
            }
            ++var4_6;
        }
        ArrayList<Object> nonPrimitives = new ArrayList<Object>();
        for (ObjectInspector objectInspector : primitives) {
            nonPrimitives.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)objectInspector));
            nonPrimitives.add(ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("field1", "field2"), Arrays.asList(objectInspector, objectInspector)));
            nonPrimitives.add(ObjectInspectorFactory.getStandardUnionObjectInspector(Arrays.asList(objectInspector, objectInspector)));
            nonPrimitives.add(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)objectInspector, (ObjectInspector)objectInspector));
        }
        ArrayList<Object> allTypes = new ArrayList<Object>(primitives);
        allTypes.addAll(nonPrimitives);
        for (ObjectInspector objectInspector : allTypes) {
            for (ObjectInspector objectInspector2 : allTypes) {
                arguments.add(new UDFArguments(objectInspector, objectInspector2));
            }
        }
        return arguments;
    }

    private static Stream<UDFArguments> generateArgsWithDifferentCategories() {
        return TestGenericUDFInitializeOnCompareUDF.generateArguments().stream().filter(args -> !args.left.getCategory().equals((Object)args.right.getCategory()));
    }

    private static Stream<UDFArguments> generateArgsWithSameCategoryNoBothPrimitive() {
        return TestGenericUDFInitializeOnCompareUDF.generateArguments().stream().filter(args -> {
            ObjectInspector.Category right;
            ObjectInspector.Category left = args.left.getCategory();
            return left.equals((Object)(right = args.right.getCategory())) && (!ObjectInspector.Category.PRIMITIVE.equals((Object)left) || !ObjectInspector.Category.PRIMITIVE.equals((Object)right));
        });
    }

    private static Stream<UDFArguments> generateArgsWithSameTypesNoCategoryUnion() {
        return TestGenericUDFInitializeOnCompareUDF.generateArguments().stream().filter(args -> {
            TypeInfo right;
            TypeInfo left = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)args.left);
            return left.equals((Object)(right = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)args.right))) && !ObjectInspector.Category.UNION.equals((Object)left.getCategory()) && !ObjectInspector.Category.UNION.equals((Object)right.getCategory());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"generateArgsWithDifferentCategories"})
    public void testArgsWithDifferentTypeCategoriesThrowsException(UDFArguments args) {
        List<GenericUDF> udfs = Arrays.asList(new GenericUDFOPEqual(), new GenericUDFOPEqualNS(), new GenericUDFOPNotEqual(), new GenericUDFOPEqualNS(), new GenericUDFIn(), new GenericUDFOPEqualOrLessThan(), new GenericUDFOPEqualOrGreaterThan(), new GenericUDFOPLessThan(), new GenericUDFOPGreaterThan());
        for (GenericUDF u : udfs) {
            try {
                u.initialize(new ObjectInspector[]{args.left, args.right});
            }
            catch (UDFArgumentException e) {
                Assertions.assertTrue((boolean)e.getMessage().contains("Type mismatch"), (String)("Unexpected message for " + u.getUdfName()));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"generateArgsWithSameTypesNoCategoryUnion"})
    public void testEqualityUDFWithSameTypeArgsSucceeds(UDFArguments args) throws UDFArgumentException {
        List<GenericUDF> udfs = Arrays.asList(new GenericUDFOPEqual(), new GenericUDFOPEqualNS(), new GenericUDFOPNotEqual(), new GenericUDFOPEqualNS(), new GenericUDFIn());
        for (GenericUDF u : udfs) {
            u.initialize(new ObjectInspector[]{args.left, args.right});
        }
    }

    @ParameterizedTest
    @MethodSource(value={"generateArgsWithSameCategoryNoBothPrimitive"})
    public void testBaseNonEqualityUDFWithNonPrimitiveTypeArgsThrowsException(UDFArguments args) {
        List<GenericUDF> udfs = Arrays.asList(new GenericUDFOPGreaterThan(), new GenericUDFOPLessThan(), new GenericUDFOPEqualOrGreaterThan(), new GenericUDFOPEqualOrLessThan());
        for (GenericUDF udf : udfs) {
            try {
                udf.initialize(new ObjectInspector[]{args.left, args.right});
                Assertions.fail((String)(udf.getUdfName() + " operator should not accept non primitive types [" + args.left.getCategory() + "," + args.right.getCategory() + "]"));
            }
            catch (UDFArgumentException e) {
                boolean isValidMessage = e.getMessage().contains("not support MAP types") || e.getMessage().contains("not support LIST types") || e.getMessage().contains("not support STRUCT types") || e.getMessage().contains("not support UNION types");
                Assertions.assertTrue((boolean)isValidMessage, (String)("Unexpected message for " + udf.getUdfName()));
            }
        }
    }

    private static class UDFArguments {
        final ObjectInspector left;
        final ObjectInspector right;

        UDFArguments(ObjectInspector left, ObjectInspector right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            TypeInfo til = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.left);
            TypeInfo tir = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.right);
            return "(" + til + ", " + tir + ")";
        }
    }
}

