/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFInitCap {
    @Test
    public void testInitCap() throws HiveException {
        GenericUDFInitCap udf = new GenericUDFInitCap();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        this.runAndVerify(" hello World! ", " Hello World! ", (GenericUDF)udf);
        this.runAndVerify("helLo world! ", "Hello World! ", (GenericUDF)udf);
        this.runAndVerify("hello  world!", "Hello  World!", (GenericUDF)udf);
        this.runAndVerify(" \t\r\nhello \t\r\nworld! \t\r\n", " \t\r\nHello \t\r\nWorld! \t\r\n", (GenericUDF)udf);
        this.runAndVerify("Hello World!", "Hello World!", (GenericUDF)udf);
        this.runAndVerify("   ", "   ", (GenericUDF)udf);
    }

    private void runAndVerify(String str, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new Text(str));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        Text output = (Text)udf.evaluate(args);
        Assert.assertEquals((String)"initcap() test ", (Object)expResult, (Object)output.toString());
    }
}

