/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFFromUtcTimestamp {
    public static void runAndVerify(GenericUDF udf, Object arg1, Object arg2, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg1), new GenericUDF.DeferredJavaObject(arg2)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    @Test
    public void testFromUtcTimestamp() throws Exception {
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        GenericUDFFromUtcTimestamp udf = new GenericUDFFromUtcTimestamp();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 17:00:00"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 17:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 18:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 19:00:00"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 19:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00.123456789"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 18:00:00.123456789"));
    }

    @Test
    public void testToUtcTimestamp() throws Exception {
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        GenericUDFToUtcTimestamp udf = new GenericUDFToUtcTimestamp();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 17:00:00"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 17:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 18:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 19:00:00"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 19:00:00"));
        TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 18:00:00.123456789"), new Text("Europe/London"), Timestamp.valueOf((String)"2015-03-28 18:00:00.123456789"));
    }

    @Test
    public void testInvalidTimestamp() throws Exception {
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        GenericUDFFromUtcTimestamp udf = new GenericUDFFromUtcTimestamp();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        try {
            TestGenericUDFFromUtcTimestamp.runAndVerify((GenericUDF)udf, new Text("2015-03-28 17:00:00"), new Text("InvalidTimestamp"), null);
        }
        catch (Exception exception) {
            Assert.assertEquals((Object)"Unknown time-zone ID: InvalidTimestamp", (Object)exception.getMessage());
        }
    }
}

