/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUnixTime;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGenericUDFFromUnixTimeEvaluate {
    private final GenericUDFFromUnixTime udf = new GenericUDFFromUnixTime();
    private final ObjectInspector[] argInspectors = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
    private final String expectedResult;
    private final String pattern;
    private final String zone;
    private final String formatter;
    private final long value;

    public TestGenericUDFFromUnixTimeEvaluate(String expectedResult, String pattern, String zone, String formatter, String value) {
        this.value = Long.parseLong(value);
        this.pattern = pattern;
        this.zone = zone;
        this.formatter = formatter;
        this.expectedResult = expectedResult;
    }

    @Parameterized.Parameters(name="('{0}','{1}'), zone={2}, formatter={3}")
    public static Collection<String[]> readInputs() throws IOException, CsvException {
        CSVParser parser = new CSVParserBuilder().withSeparator(';').withIgnoreQuotations(true).build();
        try (InputStream in = TestGenericUDFFromUnixTimeEvaluate.class.getResourceAsStream("TestGenericUDFFromUnixTimeEvaluate.csv");){
            List list;
            block12: {
                Objects.requireNonNull(in);
                CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(in)).withCSVParser((ICSVParser)parser).build();
                try {
                    list = reader.readAll();
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return list;
        }
    }

    @Test
    public void testEvaluate() throws HiveException, InterruptedException {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setVar(HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, this.formatter);
        conf.setVar(HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE, this.zone);
        SessionState state = SessionState.start((HiveConf)conf);
        this.udf.initialize(this.argInspectors);
        try {
            Text result = (Text)this.udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)new LongWritable(this.value)), new GenericUDF.DeferredJavaObject((Object)new Text(this.pattern))});
            Assert.assertEquals((String)this.udfDisplayWithInputs(), (Object)this.expectedResult, (Object)result.toString());
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)this.udfDisplayWithInputs(), (Object)this.expectedResult, (Object)e.getMessage());
        }
        SessionState.endStart((SessionState)state);
    }

    private String udfDisplayWithInputs() {
        return this.udf.getDisplayString(new String[]{Long.toString(this.value), this.pattern}) + " sessionZone=" + this.zone + ", formatter=" + this.formatter;
    }
}

