/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUnixTime;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFFromUnixTime {
    public static void runAndVerify(GenericUDFFromUnixTime udf, Object arg, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    public static void runAndVerify(GenericUDFFromUnixTime udf, Object arg1, Object arg2, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg1), new GenericUDF.DeferredJavaObject(arg2)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    @Test
    public void testTimestampDefaultTimezone() throws HiveException {
        WritableLongObjectInspector valueLongOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        GenericUDFFromUnixTime udf = new GenericUDFFromUnixTime();
        ObjectInspector[] args = new ObjectInspector[]{valueLongOI};
        udf.initialize(args);
        Timestamp ts = Timestamp.valueOf((String)"1470-01-01 00:00:00");
        TimestampTZ tstz = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz.getEpochSecond()), new Text("1470-01-01 00:00:00"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, null, null);
    }

    @Test
    public void testTimestampOtherTimezone() throws HiveException {
        WritableLongObjectInspector valueLongOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        GenericUDFFromUnixTime udf = new GenericUDFFromUnixTime();
        ObjectInspector[] args = new ObjectInspector[]{valueLongOI};
        udf.initialize(args);
        Timestamp ts = Timestamp.valueOf((String)"1969-12-31 15:59:46");
        TimestampTZ tstz1 = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.of("America/Los_Angeles"));
        TimestampTZ tstz2 = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.of("America/New_York"));
        TimestampTZ tstz3 = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.of("Europe/London"));
        TimestampTZ tstz4 = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.of("Europe/Rome"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz1.getEpochSecond()), new Text("1969-12-31 15:59:46"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz2.getEpochSecond()), new Text("1969-12-31 12:59:46"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz3.getEpochSecond()), new Text("1969-12-31 06:59:46"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz4.getEpochSecond()), new Text("1969-12-31 06:59:46"));
    }

    @Test
    public void testTimestampWithArg2() throws HiveException {
        WritableLongObjectInspector valueLongOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        WritableStringObjectInspector valueStringOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        GenericUDFFromUnixTime udf = new GenericUDFFromUnixTime();
        ObjectInspector[] args = new ObjectInspector[]{valueLongOI, valueStringOI};
        udf.initialize(args);
        Timestamp ts = Timestamp.valueOf((String)"2010-01-13 11:57:40");
        TimestampTZ tstz1 = TimestampTZUtil.convert((Timestamp)ts, (ZoneId)ZoneId.systemDefault());
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz1.getEpochSecond()), "MM/dd/yy HH:mm:ss", new Text("01/13/10 11:57:40"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz1.getEpochSecond()), "EEEE", new Text("Wednesday"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz1.getEpochSecond()), "yyyy-MM-dd'T'HH:mm:ssXXX", new Text("2010-01-13T11:57:40-08:00"));
        TestGenericUDFFromUnixTime.runAndVerify(udf, new LongWritable(tstz1.getEpochSecond()), "uuuu-MM-dd'T'HH:mm:ssXXX", new Text("2010-01-13T11:57:40-08:00"));
    }
}

