/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDeserialize;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFDeserialize {
    @Test
    public void testOneArg() throws HiveException {
        GenericUDFDeserialize udf = new GenericUDFDeserialize();
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        UDFArgumentException ex = null;
        try {
            udf.initialize(new ObjectInspector[]{valueOI1});
        }
        catch (UDFArgumentException e) {
            ex = e;
        }
        Assert.assertTrue((boolean)ex.getMessage().contains("The function deserialize accepts 2 arguments."));
        Assert.assertNotNull((String)"The function deserialize() accepts 2 argument.", (Object)((Object)ex));
        ex = null;
        try {
            udf.initialize(new ObjectInspector[]{valueOI2, valueOI1});
        }
        catch (UDFArgumentException e) {
            ex = e;
        }
        Assert.assertNull((String)"The function deserialize() accepts 2 argument.", (Object)((Object)ex));
    }

    @Test
    public void testGZIPBase64Compression() throws HiveException {
        GenericUDFDeserialize udf = new GenericUDFDeserialize();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector});
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[2];
        String expectedOutput = "test";
        MessageEncoder encoder = MessageFactory.getDefaultInstanceForReplMetrics((Configuration)new HiveConf());
        String serializedMsg = encoder.getSerializer().serialize(expectedOutput);
        args[0] = new GenericUDF.DeferredJavaObject((Object)new Text(serializedMsg));
        args[1] = new GenericUDF.DeferredJavaObject((Object)new Text(encoder.getMessageFormat()));
        String actualOutput = udf.evaluate(args).toString();
        Assert.assertEquals((String)"deserialize() test", (Object)expectedOutput, (Object)(actualOutput != null ? actualOutput : null));
    }

    @Test
    public void testInvalidCompressionFormat() throws HiveException {
        GenericUDFDeserialize udf = new GenericUDFDeserialize();
        udf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector});
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[2];
        String expectedOutput = "test";
        MessageEncoder encoder = MessageFactory.getDefaultInstanceForReplMetrics((Configuration)new HiveConf());
        String serializedMsg = encoder.getSerializer().serialize(expectedOutput);
        String compressionFormat = "randomSerialization";
        args[0] = new GenericUDF.DeferredJavaObject((Object)new Text(serializedMsg));
        args[1] = new GenericUDF.DeferredJavaObject((Object)new Text(compressionFormat));
        HiveException ex = null;
        try {
            udf.evaluate(args).toString();
        }
        catch (HiveException e) {
            ex = e;
        }
        Assert.assertNotNull((String)"Invalid message format provided.", (Object)((Object)ex));
        Assert.assertTrue((boolean)ex.getMessage().contains("compressionFormat: " + compressionFormat + " is not supported."));
    }
}

