/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.LocalDateTime;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFDateSub {
    @Test
    public void testStringToDate() throws HiveException {
        GenericUDFDateSub udf = new GenericUDFDateSub();
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaIntObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new Text("2009-07-20 04:17:52"));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)2);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"date_sub() test for STRING failed ", (Object)"2009-07-18", (Object)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        Assert.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    @Test
    public void testTimestampToDate() throws HiveException {
        GenericUDFDateSub udf = new GenericUDFDateSub();
        WritableTimestampObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        JavaIntObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritableV2(Timestamp.valueOf((String)LocalDateTime.of(109, 6, 20, 4, 17, 52, 0).toString())));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)3);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"date_sub() test for TIMESTAMP failed ", (Object)"0109-06-17", (Object)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        Assert.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    @Test
    public void testDateWritablepToDate() throws HiveException {
        GenericUDFDateSub udf = new GenericUDFDateSub();
        WritableDateObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        JavaIntObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(Date.of((int)109, (int)6, (int)20)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)4);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"date_sub() test for DATEWRITABLE failed ", (Object)"0109-06-16", (Object)output.toString());
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), valueObj2};
        Assert.assertNull((String)"date_add() 1st arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{valueObj1, new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() 2nd arg null", (Object)udf.evaluate(args));
        args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(null), new GenericUDF.DeferredJavaObject(null)};
        Assert.assertNull((String)"date_add() both args null", (Object)udf.evaluate(args));
    }

    @Test
    public void testByteDataTypeAsDays() throws HiveException {
        GenericUDFDateSub udf = new GenericUDFDateSub();
        WritableDateObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        JavaByteObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(Date.of((int)109, (int)6, (int)20)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)Byte.valueOf("4"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"date_add() test for BYTE failed ", (Object)"0109-06-16", (Object)output.toString());
    }

    @Test
    public void testShortDataTypeAsDays() throws HiveException {
        GenericUDFDateSub udf = new GenericUDFDateSub();
        WritableDateObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        JavaShortObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)new DateWritableV2(Date.of((int)109, (int)6, (int)20)));
        GenericUDF.DeferredJavaObject valueObj2 = new GenericUDF.DeferredJavaObject((Object)Short.valueOf("4"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj1, valueObj2};
        DateWritableV2 output = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((String)"date_add() test for SHORT failed ", (Object)"0109-06-16", (Object)output.toString());
    }
}

