/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCastFormat;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFCastFormat {
    public static final int CHAR = 936;
    public static final int VARCHAR = 1311;
    public static final int STRING = 1233;
    public static final int DATE = 976;
    public static final int TIMESTAMP = 1280;

    @Test
    public void testDateToStringWithFormat() throws HiveException {
        WritableDateObjectInspector inputOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        this.testCast(1233, (ObjectInspector)inputOI, this.date("2009-07-30"), "yyyy-MM-dd", "2009-07-30");
        this.testCast(1233, (ObjectInspector)inputOI, this.date("2009-07-30"), "yyyy", "2009");
        this.testCast(1233, (ObjectInspector)inputOI, this.date("1969-07-30"), "dd", "30");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.date("2009-07-30"), "yyyy-MM-dd", "200");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.date("2009-07-30"), "yyyy", "200");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.date("1969-07-30"), "dd", "30 ");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.date("2009-07-30"), "yyyy-MM-dd", "200");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.date("2009-07-30"), "yyyy", "200");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.date("1969-07-30"), "dd", "30");
    }

    @Test
    public void testTimestampToStringTypesWithFormat() throws HiveException {
        WritableTimestampObjectInspector inputOI = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        this.testCast(1233, (ObjectInspector)inputOI, this.timestamp("2009-07-30 00:00:08"), "yyyy-MM-dd HH24:mi:ss", "2009-07-30 00:00:08");
        this.testCast(1233, (ObjectInspector)inputOI, this.timestamp("2009-07-30 11:02:00"), "MM/dd/yyyy hh24miss", "07/30/2009 110200");
        this.testCast(1233, (ObjectInspector)inputOI, this.timestamp("2009-07-30 01:02:03"), "MM", "07");
        this.testCast(1233, (ObjectInspector)inputOI, this.timestamp("1969-07-30 00:00:00"), "yy", "69");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.timestamp("2009-07-30 00:00:08"), "yyyy-MM-dd HH24:mi:ss", "200");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.timestamp("2009-07-30 11:02:00"), "MM/dd/yyyy hh24miss", "07/");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.timestamp("2009-07-30 01:02:03"), "MM", "07 ");
        this.testCast(936, 3, (ObjectInspector)inputOI, this.timestamp("1969-07-30 00:00:00"), "yy", "69 ");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.timestamp("2009-07-30 00:00:08"), "yyyy-MM-dd HH24:mi:ss", "200");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.timestamp("2009-07-30 11:02:00"), "MM/dd/yyyy hh24miss", "07/");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.timestamp("2009-07-30 01:02:03"), "MM", "07");
        this.testCast(1311, 3, (ObjectInspector)inputOI, this.timestamp("1969-07-30 00:00:00"), "yy", "69");
    }

    @Test
    public void testStringTypesToDateWithFormat() throws HiveException {
        JavaStringObjectInspector inputOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        this.testCast(976, (ObjectInspector)inputOI, "1969-07-30 13:00", "yyyy-MM-dd hh24:mi", "1969-07-30");
        this.testCast(976, (ObjectInspector)inputOI, "307-2009", "ddmm-yyyy", "2009-07-30");
        this.testCast(976, (ObjectInspector)inputOI, "307-2009", "ddd-yyyy", "2009-11-03");
        inputOI = PrimitiveObjectInspectorFactory.javaHiveCharObjectInspector;
        this.testCast(976, (ObjectInspector)inputOI, new HiveChar("1969-07-30 13:00", 15), "yyyy-MM-dd hh24:mi", "1969-07-30");
        this.testCast(976, (ObjectInspector)inputOI, new HiveChar("307-2009", 7), "ddmm-yyyy", "2200-07-30");
        this.testCast(976, (ObjectInspector)inputOI, new HiveChar("307-2009", 7), "ddd-yyyy", "2200-11-03");
        inputOI = PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector;
        this.testCast(976, (ObjectInspector)inputOI, new HiveVarchar("1969-07-30 13:00", 15), "yyyy-MM-dd hh24:mi", "1969-07-30");
        this.testCast(976, (ObjectInspector)inputOI, new HiveVarchar("307-2009", 7), "ddmm-yyyy", "2200-07-30");
        this.testCast(976, (ObjectInspector)inputOI, new HiveVarchar("307-2009", 7), "ddd-yyyy", "2200-11-03");
    }

    @Test
    public void testStringTypesToTimestampWithFormat() throws HiveException {
        JavaStringObjectInspector inputOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        this.testCast(1280, (ObjectInspector)inputOI, "2009-07-30 01:02:03", "yyyy-MM-dd HH24:mi:ss", "2009-07-30 01:02:03");
        this.testCast(1280, (ObjectInspector)inputOI, "07/30/2009 11:0200", "MM/dd/yyyy hh24:miss", "2009-07-30 11:02:00");
        this.testCast(1280, (ObjectInspector)inputOI, "969.07.30.", "yyy.MM.dd.", "2969-07-30 00:00:00");
        inputOI = PrimitiveObjectInspectorFactory.javaHiveCharObjectInspector;
        this.testCast(1280, 13, (ObjectInspector)inputOI, new HiveChar("2009-07-30 01:02:03", 13), "yyyy-MM-dd HH24", "2009-07-30 01:00:00");
        this.testCast(1280, 18, (ObjectInspector)inputOI, new HiveChar("07/30/2009 11:0200", 18), "MM/dd/yyyy hh24:miss", "2009-07-30 11:02:00");
        this.testCast(1280, 10, (ObjectInspector)inputOI, new HiveChar("969.07.30.12:00", 10), "yyy.MM.dd.", "2969-07-30 00:00:00");
        inputOI = PrimitiveObjectInspectorFactory.javaHiveVarcharObjectInspector;
        this.testCast(1280, 13, (ObjectInspector)inputOI, new HiveVarchar("2009-07-30 01:02:03", 13), "yyyy-MM-dd HH24", "2009-07-30 01:00:00");
        this.testCast(1280, 18, (ObjectInspector)inputOI, new HiveVarchar("07/30/2009 11:0200", 18), "MM/dd/yyyy hh24:miss", "2009-07-30 11:02:00");
        this.testCast(1280, 10, (ObjectInspector)inputOI, new HiveVarchar("969.07.30.12:00", 10), "yyy.MM.dd.", "2969-07-30 00:00:00");
    }

    private TimestampWritableV2 timestamp(String s) {
        return new TimestampWritableV2(Timestamp.valueOf((String)s));
    }

    private DateWritableV2 date(String s) {
        return new DateWritableV2(Date.valueOf((String)s));
    }

    private void testCast(int typeCode, ObjectInspector inputOI, Object input, String format, String expOutput) throws HiveException {
        this.testCast(typeCode, 0, inputOI, input, format, expOutput);
    }

    private void testCast(int typeCode, int length, ObjectInspector inputOI, Object input, String format, String expOutput) throws HiveException {
        GenericUDFCastFormat udf = new GenericUDFCastFormat();
        ConstantObjectInspector typeCodeOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (Object)new IntWritable(typeCode));
        ConstantObjectInspector formatOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"string"), (Object)new Text(format));
        ConstantObjectInspector lengthOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"), (Object)new IntWritable(length));
        ObjectInspector[] initArgs = new ObjectInspector[]{typeCodeOI, inputOI, formatOI, lengthOI};
        udf.initialize(initArgs);
        GenericUDF.DeferredJavaObject typeCodeObj = new GenericUDF.DeferredJavaObject((Object)typeCode);
        GenericUDF.DeferredJavaObject inputObj = new GenericUDF.DeferredJavaObject(input);
        GenericUDF.DeferredJavaObject formatObj = new GenericUDF.DeferredJavaObject((Object)new Text(format));
        GenericUDF.DeferredJavaObject lengthObj = new GenericUDF.DeferredJavaObject((Object)length);
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{typeCodeObj, inputObj, formatObj, lengthObj};
        Object output = udf.evaluate(evalArgs);
        if (output == null) {
            Assert.fail((String)("Cast " + inputOI.getTypeName() + " \"" + input + "\" to " + (String)GenericUDFCastFormat.OUTPUT_TYPES.get(typeCode) + " failed, output null"));
        }
        TestCase.assertEquals((String)("Cast " + inputOI.getTypeName() + " \"" + input + "\" to " + (String)GenericUDFCastFormat.OUTPUT_TYPES.get(typeCode) + " failed "), (String)expOutput, (String)output.toString());
        GenericUDF.DeferredObject[] nullArgs = new GenericUDF.DeferredObject[]{typeCodeObj, new GenericUDF.DeferredJavaObject(null), formatObj, lengthObj};
        TestCase.assertNull((String)(udf.getFuncName() + " with NULL arguments failed"), (Object)udf.evaluate(nullArgs));
    }
}

