/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArraySlice;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFArraySlice {
    private final GenericUDFArraySlice udf = new GenericUDFArraySlice();

    @Test
    public void testPrimitive() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector), PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        this.udf.initialize(inputOIs);
        IntWritable i1 = new IntWritable(3);
        IntWritable i2 = new IntWritable(1);
        IntWritable i3 = new IntWritable(2);
        IntWritable i4 = new IntWritable(1);
        this.runAndVerify(Arrays.asList(i1, i2, i3, i4), 2, 2, Arrays.asList(i3, i4));
        i1 = new FloatWritable(3.3f);
        i2 = new FloatWritable(1.1f);
        i3 = new FloatWritable(3.3f);
        i4 = new FloatWritable(2.2f);
        this.runAndVerify(Arrays.asList(i1, i2, i3, i4), 1, 3, Arrays.asList(i2, i3, i4));
    }

    @Test
    public void testList() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector)), PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        this.udf.initialize(inputOIs);
        List<Text> i1 = Arrays.asList(new Text("aa1"), new Text("dd"), new Text("cc"), new Text("bb"));
        List<Text> i2 = Arrays.asList(new Text("aa2"), new Text("cc"), new Text("ba"), new Text("dd"));
        List<Text> i3 = Arrays.asList(new Text("aa3"), new Text("cc"), new Text("dd"), new Text("ee"), new Text("bb"));
        List<Text> i4 = Arrays.asList(new Text("aa4"), new Text("cc"), new Text("ddd"), new Text("bb"));
        this.runAndVerify(Arrays.asList(i1, i2, i2, i3, i4, i4), 1, 4, Arrays.asList(i2, i2, i3, i4));
    }

    @Test
    public void testStruct() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("f1", "f2", "f3", "f4"), Arrays.asList(PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector)))), PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        this.udf.initialize(inputOIs);
        List<Object> i1 = Arrays.asList(new Text("a"), new DoubleWritable(3.1415), new DateWritableV2(Date.of((int)2015, (int)5, (int)26)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(4)));
        List<Object> i2 = Arrays.asList(new Text("b"), new DoubleWritable(3.14), new DateWritableV2(Date.of((int)2015, (int)5, (int)26)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(4)));
        List<Object> i3 = Arrays.asList(new Text("a"), new DoubleWritable(3.1415), new DateWritableV2(Date.of((int)2015, (int)5, (int)25)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(5)));
        List<Object> i4 = Arrays.asList(new Text("a"), new DoubleWritable(3.1415), new DateWritableV2(Date.of((int)2015, (int)5, (int)25)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(4)));
        this.runAndVerify(Arrays.asList(i1, i3, i2, i3, i4, i2), 1, 1, Arrays.asList(i3));
    }

    @Test
    public void testxMap() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector)), PrimitiveObjectInspectorFactory.writableIntObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        this.udf.initialize(inputOIs);
        HashMap<Text, IntWritable> m1 = new HashMap<Text, IntWritable>();
        m1.put(new Text("a"), new IntWritable(4));
        m1.put(new Text("b"), new IntWritable(3));
        m1.put(new Text("c"), new IntWritable(1));
        m1.put(new Text("d"), new IntWritable(2));
        HashMap<Text, IntWritable> m2 = new HashMap<Text, IntWritable>();
        m2.put(new Text("d"), new IntWritable(4));
        m2.put(new Text("b"), new IntWritable(3));
        m2.put(new Text("a"), new IntWritable(1));
        m2.put(new Text("c"), new IntWritable(2));
        HashMap<Text, IntWritable> m3 = new HashMap<Text, IntWritable>();
        m3.put(new Text("d"), new IntWritable(4));
        m3.put(new Text("b"), new IntWritable(3));
        m3.put(new Text("a"), new IntWritable(1));
        this.runAndVerify(Arrays.asList(m1, m3, m2, m3, m1), 2, 1, Arrays.asList(m2));
    }

    private void runAndVerify(List<Object> actual, Integer start, Integer length, List<Object> expected) throws HiveException {
        GenericUDF.DeferredJavaObject[] args = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(actual), new GenericUDF.DeferredJavaObject((Object)(start != null ? new IntWritable(start.intValue()) : null)), new GenericUDF.DeferredJavaObject((Object)(length != null ? new IntWritable(length.intValue()) : null))};
        List result = (List)this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertArrayEquals((String)"Check content", (Object[])expected.toArray(), (Object[])result.toArray());
    }
}

