/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayJoin;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFArrayJoin {
    private final GenericUDFArrayJoin udf = new GenericUDFArrayJoin();

    @Test
    public void testPrimitive() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector), PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
        this.udf.initialize(inputOIs);
        IntWritable i1 = new IntWritable(3);
        IntWritable i2 = new IntWritable(1);
        IntWritable i3 = new IntWritable(2);
        IntWritable i4 = new IntWritable(1);
        this.runAndVerify(Arrays.asList(i1, i2, i3, i4), ",", null, i1 + "," + i2 + "," + i3 + "," + i4);
        i1 = new FloatWritable(3.3f);
        i2 = new FloatWritable(1.1f);
        i3 = new FloatWritable(3.3f);
        i4 = new FloatWritable(2.2f);
        this.runAndVerify(Arrays.asList(i1, null, i2, i3, null, i4), ",", ":", i1 + ",:," + i2 + "," + i3 + ",:," + i4);
        i1 = new Text("aa1");
        i2 = new Text("aa2");
        i3 = new Text("aa3");
        i4 = new Text("aa4");
        this.runAndVerify(Arrays.asList(i1, null, i2, i3, null, i4), ":", null, i1 + ":" + i2 + ":" + i3 + ":" + i4);
    }

    private void runAndVerify(List<Object> actual, String separator, String replaceNull, String expected) throws HiveException {
        GenericUDF.DeferredJavaObject[] args = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(actual), new GenericUDF.DeferredJavaObject((Object)(separator != null ? new Text(separator) : null)), new GenericUDF.DeferredJavaObject((Object)(replaceNull != null ? new Text(replaceNull) : null))};
        Text result = (Text)this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertEquals((String)"Not equal", (Object)expected, (Object)result.toString());
    }
}

