/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayIntersect;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFArrayIntersect {
    private final GenericUDFArrayIntersect udf = new GenericUDFArrayIntersect();

    @Test
    public void testPrimitive() throws HiveException {
        StandardListObjectInspector intObjectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        StandardListObjectInspector floatObjectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        StandardListObjectInspector doubleObjectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        StandardListObjectInspector longObjectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        StandardListObjectInspector stringObjectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        IntWritable i1 = new IntWritable(1);
        IntWritable i2 = new IntWritable(2);
        IntWritable i3 = new IntWritable(4);
        IntWritable i4 = new IntWritable(5);
        IntWritable i5 = new IntWritable(1);
        IntWritable i6 = new IntWritable(3);
        IntWritable i7 = new IntWritable(2);
        IntWritable i8 = new IntWritable(9);
        ArrayList<Object> inputList = new ArrayList<Object>();
        inputList.add(i1);
        inputList.add(i2);
        inputList.add(i3);
        inputList.add(i4);
        this.udf.initialize(new ObjectInspector[]{intObjectInspector, intObjectInspector});
        this.runAndVerify(inputList, Arrays.asList(i5, i6, i7, i8), Arrays.asList(i1, i2));
        i1 = new FloatWritable(3.3f);
        i2 = new FloatWritable(1.1f);
        i3 = new FloatWritable(4.3f);
        i4 = new FloatWritable(2.22f);
        i5 = new FloatWritable(3.3f);
        i6 = new FloatWritable(1.1f);
        i7 = new FloatWritable(2.28f);
        i8 = new FloatWritable(2.2f);
        ArrayList<IntWritable> inputFloatList = new ArrayList<IntWritable>();
        inputFloatList.add(i1);
        inputFloatList.add(i2);
        inputFloatList.add(i3);
        inputFloatList.add(i4);
        this.udf.initialize(new ObjectInspector[]{floatObjectInspector, floatObjectInspector});
        this.runAndVerify(new ArrayList<Object>(inputFloatList), Arrays.asList(i5, i6, i7, i8), Arrays.asList(i1, i2));
        Text s1 = new Text("1");
        Text s2 = new Text("2");
        Text s3 = new Text("4");
        Text s4 = new Text("5");
        ArrayList<Object> inputStringList = new ArrayList<Object>();
        inputStringList.add(s1);
        inputStringList.add(s2);
        inputStringList.add(s3);
        inputStringList.add(s4);
        this.udf.initialize(new ObjectInspector[]{stringObjectInspector, stringObjectInspector});
        this.runAndVerify(inputStringList, Arrays.asList(s1, s3), Arrays.asList(s1, s3));
        this.runAndVerify(inputStringList, inputStringList, inputStringList);
        this.runAndVerify(inputStringList, Arrays.asList(new Object[0]), Arrays.asList(new Object[0]));
        this.runAndVerify(Arrays.asList(new Object[0]), Arrays.asList(new Object[0]), Arrays.asList(new Object[0]));
        UDFArgumentTypeException exception = (UDFArgumentTypeException)Assert.assertThrows(UDFArgumentTypeException.class, () -> this.lambda$testPrimitive$0((ObjectInspector)floatObjectInspector, (ObjectInspector)intObjectInspector));
        Assert.assertEquals((Object)"Input arrays are not comparable to use ARRAY_INTERSECT udf", (Object)exception.getMessage());
        exception = (UDFArgumentTypeException)Assert.assertThrows(UDFArgumentTypeException.class, () -> this.lambda$testPrimitive$1((ObjectInspector)floatObjectInspector, (ObjectInspector)stringObjectInspector));
        Assert.assertEquals((Object)"Input arrays are not comparable to use ARRAY_INTERSECT udf", (Object)exception.getMessage());
        exception = (UDFArgumentTypeException)Assert.assertThrows(UDFArgumentTypeException.class, () -> this.lambda$testPrimitive$2((ObjectInspector)longObjectInspector, (ObjectInspector)doubleObjectInspector));
        Assert.assertEquals((Object)"Input arrays are not comparable to use ARRAY_INTERSECT udf", (Object)exception.getMessage());
    }

    @Test
    public void testList() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector)), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector))};
        this.udf.initialize(inputOIs);
        List<Text> i1 = Arrays.asList(new Text("aa1"), new Text("dd"), new Text("cc"), new Text("bb"));
        List<Text> i2 = Arrays.asList(new Text("aa2"), new Text("cc"), new Text("ba"), new Text("dd"));
        List<Text> i3 = Arrays.asList(new Text("aa3"), new Text("cc"), new Text("dd"), new Text("ee"), new Text("bb"));
        List<Text> i4 = Arrays.asList(new Text("aa4"), new Text("cc"), new Text("ddd"), new Text("bb"));
        ArrayList<Object> inputList = new ArrayList<Object>();
        inputList.add(i1);
        inputList.add(i2);
        inputList.add(i3);
        inputList.add(i4);
        this.runAndVerify(inputList, Arrays.asList(i1, i2, i2), Arrays.asList(i1, i2));
    }

    @Test
    public void testStruct() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("f1", "f2", "f3", "f4"), Arrays.asList(PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector)))), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("f1", "f2", "f3", "f4"), Arrays.asList(PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector))))};
        this.udf.initialize(inputOIs);
        List<Object> i1 = Arrays.asList(new Text("a"), new DoubleWritable(3.1415), new DateWritableV2(Date.of((int)2015, (int)5, (int)26)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(4)));
        List<Object> i2 = Arrays.asList(new Text("b"), new DoubleWritable(3.14), new DateWritableV2(Date.of((int)2015, (int)5, (int)26)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(4)));
        List<Object> i3 = Arrays.asList(new Text("a"), new DoubleWritable(3.1415), new DateWritableV2(Date.of((int)2015, (int)5, (int)25)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(5)));
        List<Object> i4 = Arrays.asList(new Text("a"), new DoubleWritable(3.1415), new DateWritableV2(Date.of((int)2015, (int)5, (int)25)), Arrays.asList(new IntWritable(1), new IntWritable(3), new IntWritable(2), new IntWritable(4)));
        ArrayList<Object> inputList = new ArrayList<Object>();
        inputList.add(i1);
        inputList.add(i2);
        inputList.add(i3);
        inputList.add(i4);
        this.runAndVerify(inputList, Arrays.asList(i1, i3), Arrays.asList(i1, i3));
    }

    @Test
    public void testMap() throws HiveException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector)), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector))};
        this.udf.initialize(inputOIs);
        HashMap<Text, IntWritable> m1 = new HashMap<Text, IntWritable>();
        m1.put(new Text("a"), new IntWritable(4));
        m1.put(new Text("b"), new IntWritable(3));
        m1.put(new Text("c"), new IntWritable(1));
        m1.put(new Text("d"), new IntWritable(2));
        HashMap<Text, IntWritable> m2 = new HashMap<Text, IntWritable>();
        m2.put(new Text("d"), new IntWritable(4));
        m2.put(new Text("b"), new IntWritable(3));
        m2.put(new Text("a"), new IntWritable(1));
        m2.put(new Text("c"), new IntWritable(2));
        HashMap<Text, IntWritable> m3 = new HashMap<Text, IntWritable>();
        m3.put(new Text("d"), new IntWritable(4));
        m3.put(new Text("b"), new IntWritable(3));
        m3.put(new Text("a"), new IntWritable(1));
        HashMap m4 = new HashMap();
        m3.put(new Text("e"), new IntWritable(4));
        m3.put(new Text("b"), new IntWritable(3));
        m3.put(new Text("a"), new IntWritable(1));
        ArrayList<Object> inputList = new ArrayList<Object>();
        inputList.add(m1);
        inputList.add(m3);
        inputList.add(m2);
        inputList.add(m4);
        inputList.add(m1);
        this.runAndVerify(inputList, Arrays.asList(m1, m3), Arrays.asList(m1, m3));
    }

    private void runAndVerify(List<Object> actual, List<Object> actual2, List<Object> expected) throws HiveException {
        GenericUDF.DeferredJavaObject[] args = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(actual), new GenericUDF.DeferredJavaObject(actual2)};
        List result = (List)this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertArrayEquals((String)"Check content", (Object[])expected.toArray(), (Object[])result.toArray());
    }

    private /* synthetic */ void lambda$testPrimitive$2(ObjectInspector longObjectInspector, ObjectInspector doubleObjectInspector) throws Throwable {
        this.udf.initialize(new ObjectInspector[]{longObjectInspector, doubleObjectInspector});
    }

    private /* synthetic */ void lambda$testPrimitive$1(ObjectInspector floatObjectInspector, ObjectInspector stringObjectInspector) throws Throwable {
        this.udf.initialize(new ObjectInspector[]{floatObjectInspector, stringObjectInspector});
    }

    private /* synthetic */ void lambda$testPrimitive$0(ObjectInspector floatObjectInspector, ObjectInspector intObjectInspector) throws Throwable {
        this.udf.initialize(new ObjectInspector[]{floatObjectInspector, intObjectInspector});
    }
}

