/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFAbs {
    @Test
    public void testInt() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableIntObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new IntWritable(107));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        IntWritable output = (IntWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for INT failed ", (long)107L, (long)output.get());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new IntWritable(-107));
        args[0] = valueObj;
        output = (IntWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for INT failed ", (long)107L, (long)output.get());
    }

    @Test
    public void testLong() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableLongObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new LongWritable(107L));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        LongWritable output = (LongWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for LONG failed ", (long)107L, (long)output.get());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new LongWritable(-107L));
        args[0] = valueObj;
        output = (LongWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for LONG failed ", (long)107L, (long)output.get());
    }

    @Test
    public void testDouble() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableDoubleObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new DoubleWritable(107.78));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for Double failed ", (double)107.78, (double)output.get(), (double)1.0E-15);
        valueObj = new GenericUDF.DeferredJavaObject((Object)new DoubleWritable(-107.78));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for Double failed ", (double)107.78, (double)output.get(), (double)1.0E-15);
    }

    @Test
    public void testFloat() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableFloatObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new FloatWritable(107.78f));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        Assert.assertTrue((String)"abs() test for Float failed ", (Math.abs(107.78 - output.get()) < 1.0E-4 ? 1 : 0) != 0);
        valueObj = new GenericUDF.DeferredJavaObject((Object)new FloatWritable(-107.78f));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        Assert.assertTrue((String)"abs() test for Float failed ", (Math.abs(107.78 - output.get()) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testText() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        WritableStringObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("123.45"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for String failed ", (Object)"123.45", (Object)output.toString());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("-123.45"));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for String failed ", (Object)"123.45", (Object)output.toString());
        valueObj = new GenericUDF.DeferredJavaObject((Object)new Text("foo"));
        args[0] = valueObj;
        output = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for String failed ", null, (Object)output);
    }

    @Test
    public void testHiveDecimal() throws HiveException {
        GenericUDFAbs udf = new GenericUDFAbs();
        int prec = 12;
        int scale = 9;
        AbstractPrimitiveWritableObjectInspector valueOI = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)prec, (int)scale));
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI};
        PrimitiveObjectInspector outputOI = (PrimitiveObjectInspector)udf.initialize(arguments);
        Assert.assertEquals((String)"result precision for abs()", (long)prec, (long)outputOI.precision());
        Assert.assertEquals((String)"result scale for abs()", (long)scale, (long)outputOI.scale());
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(HiveDecimal.create((String)"107.123456789")));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj};
        HiveDecimalWritable output = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for HiveDecimal failed ", (double)107.123456789, (double)output.getHiveDecimal().doubleValue(), (double)1.0E-15);
        valueObj = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-107.123456789")));
        args[0] = valueObj;
        output = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() test for HiveDecimal failed ", (double)107.123456789, (double)output.getHiveDecimal().doubleValue(), (double)1.0E-15);
        args[0] = new GenericUDF.DeferredJavaObject(null);
        output = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs(null)", null, (Object)output);
        args[0] = new GenericUDF.DeferredJavaObject((Object)new HiveDecimalWritable(HiveDecimal.create((String)"-1000.123456")));
        output = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((String)"abs() of too large decimal value", null, (Object)output);
    }
}

