/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayMin;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractGenericUDFArrayBase {
    GenericUDF udf = null;

    @Test
    public void testIntArray() throws HiveException {
        this.initUdf((AbstractPrimitiveWritableObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        IntWritable i1 = new IntWritable(3);
        IntWritable i2 = new IntWritable(1);
        IntWritable i3 = new IntWritable(2);
        IntWritable i4 = new IntWritable(4);
        IntWritable i5 = new IntWritable(-4);
        if (this.udf instanceof GenericUDFArrayMax) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4, i5), i4);
        }
        if (this.udf instanceof GenericUDFArrayMin) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4, i5), i5);
        }
    }

    @Test
    public void testFloatArray() throws HiveException {
        this.initUdf((AbstractPrimitiveWritableObjectInspector)PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        FloatWritable i1 = new FloatWritable(5.3f);
        FloatWritable i2 = new FloatWritable(1.1f);
        FloatWritable i3 = new FloatWritable(3.3f);
        FloatWritable i4 = new FloatWritable(2.2f);
        if (this.udf instanceof GenericUDFArrayMax) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4), i1);
        }
        if (this.udf instanceof GenericUDFArrayMin) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4), i2);
        }
    }

    @Test
    public void testDoubleArray() throws HiveException {
        this.initUdf((AbstractPrimitiveWritableObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        DoubleWritable i1 = new DoubleWritable(3.3123456789);
        DoubleWritable i2 = new DoubleWritable(1.1123456789);
        DoubleWritable i3 = new DoubleWritable(4.3123456789);
        DoubleWritable i4 = new DoubleWritable(2.2123456789);
        if (this.udf instanceof GenericUDFArrayMax) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4), i3);
        }
        if (this.udf instanceof GenericUDFArrayMin) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4), i2);
        }
    }

    @Test
    public void testLongArray() throws HiveException {
        this.initUdf((AbstractPrimitiveWritableObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        LongWritable i1 = new LongWritable(331234567890L);
        LongWritable i2 = new LongWritable(911234567890L);
        LongWritable i3 = new LongWritable(131234567890L);
        LongWritable i4 = new LongWritable(221234567890L);
        if (this.udf instanceof GenericUDFArrayMax) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4), i2);
        }
        if (this.udf instanceof GenericUDFArrayMin) {
            this.runAndVerify(Arrays.asList(i1, i2, i3, i4), i3);
        }
    }

    private void initUdf(AbstractPrimitiveWritableObjectInspector writableIntObjectInspector) throws UDFArgumentException {
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)writableIntObjectInspector)};
        if (this.udf != null) {
            this.udf.initialize(inputOIs);
        }
    }

    private void runAndVerify(List<Object> actual, Object expected) throws HiveException {
        GenericUDF.DeferredJavaObject[] args = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(actual)};
        Object result = this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertEquals((String)"Max/Min value", (Object)expected, (Object)result);
    }
}

