/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri.serde;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Point;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.udf.esri.serde.GeoJsonSerDe;
import org.apache.hadoop.hive.ql.udf.esri.serde.JsonSerDeTestingBase;
import org.apache.hadoop.hive.ql.udf.esri.shims.HiveShims;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestGeoJsonSerDe
extends JsonSerDeTestingBase {
    @Test
    public void TestIntWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7);
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        JsonNode jn = new ObjectMapper().readTree(jsw.toString());
        jn = jn.findValue("properties");
        jn = jn.findValue("num");
        Assert.assertEquals((long)7L, (long)jn.intValue());
    }

    @Test
    public void TestEpochWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "date");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        long epoch = 147147147147L;
        long zoned = epoch - (long)TimeZone.getDefault().getOffset(epoch);
        Date expected = new Date(zoned);
        this.addWritable(stuff, expected);
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        JsonNode jn = new ObjectMapper().readTree(jsw.toString());
        jn = jn.findValue("properties");
        jn = jn.findValue("when");
        Date actual = new Date(jn.longValue());
        long day = 86400000L;
        Assert.assertEquals((long)(epoch / day), (long)(jn.longValue() / day));
    }

    @Test
    public void TestPointWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        String rslt = jsw.toString();
        JsonNode jn = new ObjectMapper().readTree(rslt);
        jn = jn.findValue("geometry");
        Assert.assertNotNull((Object)jn.findValue("type"));
        Assert.assertNotNull((Object)jn.findValue("coordinates"));
    }

    @Test
    public void TestIntParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        GeoJsonSerDe jserde = new GeoJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        value.set("{\"properties\":{\"num\":7}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("num");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((long)7L, (long)((IntWritable)fieldData).get());
        value.set("{\"properties\":{\"num\":9}}");
        row = jserde.deserialize((Writable)value);
        f0 = rowOI.getStructFieldRef("num");
        fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((long)9L, (long)((IntWritable)fieldData).get());
    }

    @Test
    public void TestDateParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        GeoJsonSerDe jserde = new GeoJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "date");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        String dateStr = "2020-02-20";
        value.set("{\"properties\":{\"when\":\"" + dateStr + "\"}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("when");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((Object)dateStr, (Object)this.iso8601FromWritable(fieldData));
        dateStr = "2017-05-05";
        value.set("{\"properties\":{\"when\":\"" + dateStr + "\"}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((Object)dateStr, (Object)this.iso8601FromWritable(fieldData));
    }

    @Test
    public void TestEpochParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        GeoJsonSerDe jserde = new GeoJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "date");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        value.set("{\"properties\":{\"when\":147147147147}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("when");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        long day = 86400000L;
        long epochExpected = 147147147147L;
        Assert.assertEquals((long)(epochExpected / day), (long)(this.epochFromWritable(fieldData) / day));
        value.set("{\"properties\":{\"when\":142857142857}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        epochExpected = 142857142857L;
        Assert.assertEquals((long)(epochExpected / day), (long)(this.epochFromWritable(fieldData) / day));
    }

    @Test
    public void TestPointParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        GeoJsonSerDe jserde = new GeoJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        value.set("{\"properties\":{},\"geometry\":{\"type\":\"Point\",\"coordinates\":[15.0,5.0]}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("shape");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        this.ckPoint(new Point(15.0, 5.0), (BytesWritable)fieldData);
        value.set("{\"properties\":{},\"geometry\":{\"type\":\"Point\",\"type\":\"Point\",\"coordinates\":[7.0,4.0]}}");
        row = jserde.deserialize((Writable)value);
        f0 = rowOI.getStructFieldRef("shape");
        fieldData = rowOI.getStructFieldData(row, f0);
        this.ckPoint(new Point(7.0, 4.0), (BytesWritable)fieldData);
    }

    @Test
    public void TestIntOnly() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7);
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)7L, (long)((IntWritable)fieldData).get());
        stuff.clear();
        this.addWritable(stuff, 9);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)9L, (long)((IntWritable)fieldData).get());
    }

    @Test
    public void TestPointOnly() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(15.0, 5.0), (BytesWritable)fieldData);
        stuff.clear();
        this.addWritable(stuff, (Geometry)new Point(7.0, 4.0));
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(7.0, 4.0), (BytesWritable)fieldData);
    }

    @Test
    public void TestIntPoint() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num,shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "bigint,binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7L);
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)7L, (long)((LongWritable)fieldData).get());
        stuff.clear();
        this.addWritable(stuff, 4L);
        this.addWritable(stuff, (Geometry)new Point(7.0, 2.0));
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)4L, (long)((LongWritable)fieldData).get());
        fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(7.0, 2.0), (BytesWritable)fieldData);
    }

    @Test
    public void TestNullAttr() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7);
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)7L, (long)((IntWritable)fieldData).get());
        stuff.set(0, null);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("num", row, rowOI);
        Assert.assertNull((Object)fieldData);
    }

    @Test
    public void TestNullGeom() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(15.0, 5.0), (BytesWritable)fieldData);
        stuff.set(0, null);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("shape", row, rowOI);
        Assert.assertNull((Object)fieldData);
    }

    private AbstractSerDe mkSerDe(Properties proptab) throws Exception {
        Configuration config = new Configuration();
        GeoJsonSerDe jserde = new GeoJsonSerDe();
        jserde.initialize(config, proptab, null);
        return jserde;
    }
}

