/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri.serde;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Point;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.udf.esri.serde.EsriJsonSerDe;
import org.apache.hadoop.hive.ql.udf.esri.serde.JsonSerDeTestingBase;
import org.apache.hadoop.hive.ql.udf.esri.shims.HiveShims;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyString;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyPrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestEsriJsonSerDe
extends JsonSerDeTestingBase {
    @Test
    public void TestIntWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7);
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        JsonNode jn = new ObjectMapper().readTree(jsw.toString());
        jn = jn.findValue("attributes");
        jn = jn.findValue("num");
        Assert.assertEquals((long)7L, (long)jn.intValue());
    }

    @Test
    public void TestEpochWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "date");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        long epoch = 147147147147L;
        long zoned = epoch - (long)TimeZone.getDefault().getOffset(epoch);
        Date expected = new Date(zoned);
        this.addWritable(stuff, expected);
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        JsonNode jn = new ObjectMapper().readTree(jsw.toString());
        jn = jn.findValue("attributes");
        jn = jn.findValue("when");
        Date actual = new Date(jn.longValue());
        long day = 86400000L;
        Assert.assertEquals((long)(epoch / day), (long)(jn.longValue() / day));
    }

    @Test
    public void TestTimeWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "timestamp");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        long epoch = 147147147147L;
        Timestamp expected = new Timestamp(epoch);
        this.addWritable(stuff, expected);
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        JsonNode jn = new ObjectMapper().readTree(jsw.toString());
        jn = jn.findValue("attributes");
        jn = jn.findValue("when");
        Timestamp actual = new Timestamp(jn.longValue());
        Assert.assertEquals((long)epoch, (long)actual.getTime());
    }

    @Test
    public void TestPointWrite() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        String rslt = jsw.toString();
        JsonNode jn = new ObjectMapper().readTree(rslt);
        jn = jn.findValue("geometry");
        Assert.assertNotNull((Object)jn.findValue("x"));
        Assert.assertNotNull((Object)jn.findValue("y"));
    }

    @Test
    public void TestIntParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        EsriJsonSerDe jserde = new EsriJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        value.set("{\"attributes\":{\"num\":7}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("num");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((long)7L, (long)((IntWritable)fieldData).get());
        value.set("{\"attributes\":{\"num\":9}}");
        row = jserde.deserialize((Writable)value);
        f0 = rowOI.getStructFieldRef("num");
        fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((long)9L, (long)((IntWritable)fieldData).get());
    }

    @Test
    public void TestDateParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        EsriJsonSerDe jserde = new EsriJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "date");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        String dateStr = "2020-02-20";
        value.set("{\"attributes\":{\"when\":\"" + dateStr + "\"}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("when");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((Object)dateStr, (Object)this.iso8601FromWritable(fieldData));
        dateStr = "2017-05-05";
        value.set("{\"attributes\":{\"when\":\"" + dateStr + "\"}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        Assert.assertEquals((Object)dateStr, (Object)this.iso8601FromWritable(fieldData));
    }

    @Test
    public void TestEpochParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        EsriJsonSerDe jserde = new EsriJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "date");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        value.set("{\"attributes\":{\"when\":147147147147}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("when");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        long day = 86400000L;
        long epochExpected = 147147147147L;
        Assert.assertEquals((long)(epochExpected / day), (long)(this.epochFromWritable(fieldData) / day));
        value.set("{\"attributes\":{\"when\":142857142857}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        epochExpected = 142857142857L;
        Assert.assertEquals((long)(epochExpected / day), (long)(this.epochFromWritable(fieldData) / day));
    }

    @Test
    public void TestTimeParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        EsriJsonSerDe jserde = new EsriJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "when");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "timestamp");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        String timeStr = "2020-02-20";
        value.set("{\"attributes\":{\"when\":\"" + timeStr + "\"}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("when");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        SimpleDateFormat dtFmt = new SimpleDateFormat("yyyy-MM-dd");
        dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        long epoch = dtFmt.parse(timeStr).getTime();
        long withOffset = epoch - (long)TimeZone.getDefault().getOffset(epoch);
        long got = this.epochFromWritable(fieldData);
        Assert.assertEquals((long)epoch, (long)got);
        timeStr = "2017-05-05 05:05";
        value.set("{\"attributes\":{\"when\":\"" + timeStr + "\"}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        dtFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        epoch = dtFmt.parse(timeStr).getTime();
        got = this.epochFromWritable(fieldData);
        Assert.assertEquals((Object)timeStr, (Object)this.iso8601FromWritable(fieldData).substring(0, 16));
        Assert.assertEquals((long)epoch, (long)got);
        timeStr = "2017-08-09 10:11:12";
        value.set("{\"attributes\":{\"when\":\"" + timeStr + "\"}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        dtFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        epoch = dtFmt.parse(timeStr + "Z").getTime();
        withOffset = epoch - (long)TimeZone.getDefault().getOffset(epoch);
        got = this.epochFromWritable(fieldData);
        Assert.assertEquals((Object)timeStr, (Object)this.iso8601FromWritable(fieldData).substring(0, 19));
        Assert.assertEquals((long)epoch, (long)got);
        timeStr = "2017-06-05 04:03:02.123456789";
        value.set("{\"attributes\":{\"when\":\"" + timeStr + "\"}}");
        row = jserde.deserialize((Writable)value);
        fieldData = rowOI.getStructFieldData(row, f0);
        dtFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm.SSS");
        dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        dtFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        epoch = dtFmt.parse(timeStr.substring(0, 23)).getTime();
        withOffset = epoch - (long)TimeZone.getDefault().getOffset(epoch);
        got = this.epochFromWritable(fieldData);
        Assert.assertEquals((long)epoch, (long)got);
    }

    @Test
    public void TestPointParse() throws Exception {
        Configuration config = new Configuration();
        Text value = new Text();
        EsriJsonSerDe jserde = new EsriJsonSerDe();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        jserde.initialize(config, proptab, null);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        value.set("{\"attributes\":{},\"geometry\":{\"x\":15.0,\"y\":5.0}}");
        Object row = jserde.deserialize((Writable)value);
        StructField f0 = rowOI.getStructFieldRef("shape");
        Object fieldData = rowOI.getStructFieldData(row, f0);
        this.ckPoint(new Point(15.0, 5.0), (BytesWritable)fieldData);
        value.set("{\"attributes\":{},\"geometry\":{\"x\":7.0,\"y\":4.0}}");
        row = jserde.deserialize((Writable)value);
        f0 = rowOI.getStructFieldRef("shape");
        fieldData = rowOI.getStructFieldData(row, f0);
        this.ckPoint(new Point(7.0, 4.0), (BytesWritable)fieldData);
    }

    @Test
    public void TestIntOnly() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7);
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)7L, (long)((IntWritable)fieldData).get());
        stuff.clear();
        this.addWritable(stuff, 9);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)9L, (long)((IntWritable)fieldData).get());
    }

    @Test
    public void TestPointOnly() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(15.0, 5.0), (BytesWritable)fieldData);
        stuff.clear();
        this.addWritable(stuff, (Geometry)new Point(7.0, 4.0));
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(7.0, 4.0), (BytesWritable)fieldData);
    }

    @Test
    public void TestIntPoint() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num,shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "bigint,binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7L);
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)7L, (long)((LongWritable)fieldData).get());
        stuff.clear();
        this.addWritable(stuff, 4L);
        this.addWritable(stuff, (Geometry)new Point(7.0, 2.0));
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)4L, (long)((LongWritable)fieldData).get());
        fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(7.0, 2.0), (BytesWritable)fieldData);
    }

    @Test
    public void TestNullAttr() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "num");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "int");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, 7);
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("num", row, rowOI);
        Assert.assertEquals((long)7L, (long)((IntWritable)fieldData).get());
        stuff.set(0, null);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("num", row, rowOI);
        Assert.assertNull((Object)fieldData);
    }

    @Test
    public void TestNullGeom() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "shape");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "binary");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, (Geometry)new Point(15.0, 5.0));
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("shape", row, rowOI);
        this.ckPoint(new Point(15.0, 5.0), (BytesWritable)fieldData);
        stuff.set(0, null);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("shape", row, rowOI);
        Assert.assertNull((Object)fieldData);
    }

    @Test
    public void TestColumnTypes() throws Exception {
        ArrayList<Object> stuff = new ArrayList<Object>();
        Properties proptab = new Properties();
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMNS, "flag,num1,num2,text");
        proptab.setProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES, "boolean,tinyint,smallint,string");
        AbstractSerDe jserde = this.mkSerDe(proptab);
        StructObjectInspector rowOI = (StructObjectInspector)jserde.getObjectInspector();
        this.addWritable(stuff, false);
        this.addWritable(stuff, (byte)2);
        this.addWritable(stuff, (short)5);
        this.addWritable(stuff, "Point(15.0 5.0)");
        Object row = this.runSerDe(stuff, jserde, rowOI);
        Object fieldData = this.getField("flag", row, rowOI);
        Assert.assertEquals((Object)false, (Object)((BooleanWritable)fieldData).get());
        fieldData = this.getField("num1", row, rowOI);
        Assert.assertEquals((long)2L, (long)((ByteWritable)fieldData).get());
        fieldData = this.getField("num2", row, rowOI);
        Assert.assertEquals((long)5L, (long)((ShortWritable)fieldData).get());
        fieldData = this.getField("text", row, rowOI);
        Assert.assertEquals((Object)"Point(15.0 5.0)", (Object)fieldData.toString());
        stuff.set(0, new BooleanWritable(true));
        stuff.set(1, new ByteWritable(4));
        stuff.set(2, new ShortWritable(4));
        LazyStringObjectInspector loi = LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector((boolean)false, (byte)0);
        LazyString lstr = new LazyString(loi);
        ByteArrayRef bar = new ByteArrayRef();
        bar.setData("other".getBytes());
        lstr.init(bar, 0, 5);
        stuff.set(3, lstr);
        row = this.runSerDe(stuff, jserde, rowOI);
        fieldData = this.getField("flag", row, rowOI);
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)fieldData).get());
        fieldData = this.getField("num1", row, rowOI);
        Assert.assertEquals((long)4L, (long)((ByteWritable)fieldData).get());
        fieldData = this.getField("num2", row, rowOI);
        Assert.assertEquals((long)4L, (long)((ShortWritable)fieldData).get());
        fieldData = this.getField("text", row, rowOI);
        Assert.assertEquals((Object)"other", (Object)fieldData.toString());
    }

    private AbstractSerDe mkSerDe(Properties proptab) throws Exception {
        Configuration config = new Configuration();
        EsriJsonSerDe jserde = new EsriJsonSerDe();
        jserde.initialize(config, proptab, null);
        return jserde;
    }
}

