/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri.serde;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;

public abstract class JsonSerDeTestingBase {
    protected void addWritable(ArrayList<Object> stuff, boolean item) {
        stuff.add(new BooleanWritable(item));
    }

    protected void addWritable(ArrayList<Object> stuff, byte item) {
        stuff.add(new ByteWritable(item));
    }

    protected void addWritable(ArrayList<Object> stuff, short item) {
        stuff.add(new ShortWritable(item));
    }

    protected void addWritable(ArrayList<Object> stuff, int item) {
        stuff.add(new IntWritable(item));
    }

    protected void addWritable(ArrayList<Object> stuff, long item) {
        stuff.add(new LongWritable(item));
    }

    protected void addWritable(ArrayList<Object> stuff, String item) {
        stuff.add(new Text(item));
    }

    protected void addWritable(ArrayList<Object> stuff, Date item) {
        try {
            Class<?> dtClazz = Class.forName("org.apache.hadoop.hive.common.type.Date");
            Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
            Method dtSetImpl = dtClazz.getMethod("setTimeInMillis", Long.TYPE);
            Method dwSetImpl = dwClazz.getMethod("set", dtClazz);
            Object dtObj = dtClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            dtSetImpl.invoke(dtObj, item.getTime());
            Object dwObj = dwClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            dwSetImpl.invoke(dwObj, dtObj);
            stuff.add(dwObj);
        }
        catch (Exception exc) {
            stuff.add(new DateWritable(item));
        }
    }

    protected void addWritable(ArrayList<Object> stuff, Timestamp item) {
        try {
            Class<?> ttClazz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
            Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2");
            Method ttSetImpl = ttClazz.getMethod("setTimeInMillis", Long.TYPE);
            Method twSetImpl = twClazz.getMethod("set", ttClazz);
            Object ttObj = ttClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            ttSetImpl.invoke(ttObj, item.getTime());
            Object twObj = twClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            twSetImpl.invoke(twObj, ttObj);
            stuff.add(twObj);
        }
        catch (Exception exc) {
            stuff.add(new TimestampWritable(item));
        }
    }

    protected void addWritable(ArrayList<Object> stuff, Geometry geom) {
        this.addWritable(stuff, geom, null);
    }

    protected void addWritable(ArrayList<Object> stuff, MapGeometry geom) {
        this.addWritable(stuff, geom.getGeometry(), geom.getSpatialReference());
    }

    protected void addWritable(ArrayList<Object> stuff, Geometry geom, SpatialReference sref) {
        stuff.add(GeometryUtils.geometryToEsriShapeBytesWritable((OGCGeometry)OGCGeometry.createFromEsriGeometry((Geometry)geom, (SpatialReference)sref)));
    }

    protected void ckPoint(Point refPt, BytesWritable fieldData) {
        Assert.assertEquals((Object)refPt, (Object)GeometryUtils.geometryFromEsriShape((BytesWritable)fieldData).getEsriGeometry());
    }

    protected long epochFromWritable(Object dwHive) throws Exception {
        Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritable");
        Method dwGetImpl = dwClazz.getMethod("get", new Class[0]);
        Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritable");
        Method twGetImpl = twClazz.getMethod("getTimestamp", new Class[0]);
        if (dwHive.getClass() == dwClazz) {
            long epoch = ((java.util.Date)dwGetImpl.invoke(dwHive, new Object[0])).getTime();
            return epoch + (long)TimeZone.getDefault().getOffset(epoch);
        }
        if (dwHive.getClass() == twClazz) {
            return ((Timestamp)twGetImpl.invoke(dwHive, new Object[0])).getTime();
        }
        dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
        twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2");
        if (dwHive.getClass() == dwClazz) {
            Class<?> dtClazz = Class.forName("org.apache.hadoop.hive.common.type.Date");
            Method dtGetImpl = dtClazz.getMethod("toEpochMilli", new Class[0]);
            dwGetImpl = dwClazz.getMethod("get", new Class[0]);
            return (Long)dtGetImpl.invoke(dwGetImpl.invoke(dwHive, new Object[0]), new Object[0]);
        }
        Class<?> ttClazz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
        Method ttGetImpl = ttClazz.getMethod("toEpochMilli", new Class[0]);
        twGetImpl = twClazz.getMethod("getTimestamp", new Class[0]);
        return (Long)ttGetImpl.invoke(twGetImpl.invoke(dwHive, new Object[0]), new Object[0]);
    }

    protected Object getField(String col, Object row, StructObjectInspector rowOI) {
        StructField f0 = rowOI.getStructFieldRef(col);
        return rowOI.getStructFieldData(row, f0);
    }

    protected Object runSerDe(Object stuff, AbstractSerDe jserde, StructObjectInspector rowOI) throws Exception {
        Writable jsw = jserde.serialize(stuff, (ObjectInspector)rowOI);
        return jserde.deserialize(jsw);
    }

    protected String iso8601FromWritable(Object dtwHive) throws Exception {
        Class<?> dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritable");
        Method dwGetImpl = dwClazz.getMethod("get", new Class[0]);
        Class<?> twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritable");
        Method twGetImpl = twClazz.getMethod("getTimestamp", new Class[0]);
        if (dtwHive.getClass() == dwClazz) {
            java.util.Date localDay = (java.util.Date)dwGetImpl.invoke(dtwHive, new Object[0]);
            SimpleDateFormat dtFmt = new SimpleDateFormat("yyyy-MM-dd");
            dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dtFmt.format(localDay);
        }
        if (dtwHive.getClass() == twClazz) {
            SimpleDateFormat dtFmt = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
            dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            Timestamp localDt = (Timestamp)twGetImpl.invoke(dtwHive, new Object[0]);
            return dtFmt.format(localDt);
        }
        dwClazz = Class.forName("org.apache.hadoop.hive.serde2.io.DateWritableV2");
        twClazz = Class.forName("org.apache.hadoop.hive.serde2.io.TimestampWritableV2");
        if (dtwHive.getClass() == dwClazz) {
            Class<?> dtClazz = Class.forName("org.apache.hadoop.hive.common.type.Date");
            Method dtGetImpl = dtClazz.getMethod("toString", new Class[0]);
            dwGetImpl = dwClazz.getMethod("get", new Class[0]);
            return (String)dtGetImpl.invoke(dwGetImpl.invoke(dtwHive, new Object[0]), new Object[0]);
        }
        Class<?> ttClazz = Class.forName("org.apache.hadoop.hive.common.type.Timestamp");
        twGetImpl = twClazz.getMethod("toString", new Class[0]);
        return (String)twGetImpl.invoke(dtwHive, new Object[0]);
    }
}

