/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryType;
import org.apache.hadoop.hive.ql.udf.esri.ST_Point;
import org.apache.hadoop.hive.ql.udf.esri.ST_X;
import org.apache.hadoop.hive.ql.udf.esri.ST_Y;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestStPoint {
    @Test
    public void TestStPoint() throws Exception {
        ST_GeometryType typer = new ST_GeometryType();
        ST_X stX = new ST_X();
        ST_Y stY = new ST_Y();
        ST_Point stPt = new ST_Point();
        BytesWritable bwGeom = stPt.evaluate(new DoubleWritable(1.2), new DoubleWritable(3.4));
        DoubleWritable dwx = stX.evaluate(bwGeom);
        DoubleWritable dwy = stY.evaluate(bwGeom);
        Assert.assertEquals((double)1.2, (double)dwx.get(), (double)1.0E-6);
        Assert.assertEquals((double)3.4, (double)dwy.get(), (double)1.0E-6);
        Text gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_POINT", (Object)gty.toString());
        bwGeom = stPt.evaluate(new DoubleWritable(6.5), new DoubleWritable(4.3), new DoubleWritable(2.1));
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_POINT", (Object)gty.toString());
        bwGeom = stPt.evaluate(new Text("point (10.02 20.01)"));
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_POINT", (Object)gty.toString());
        bwGeom = stPt.evaluate(new Text("point z (10.02 20.01 2)"));
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_POINT", (Object)gty.toString());
    }
}

