/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.udf.esri.ST_Area;
import org.apache.hadoop.hive.ql.udf.esri.ST_Equals;
import org.apache.hadoop.hive.ql.udf.esri.ST_ExteriorRing;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryType;
import org.apache.hadoop.hive.ql.udf.esri.ST_MultiPolygon;
import org.apache.hadoop.hive.ql.udf.esri.ST_SetSRID;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestStMultiPolygon {
    DoubleWritable dw0 = new DoubleWritable(0.0);
    DoubleWritable dw1 = new DoubleWritable(1.0);
    ST_Area stArea = new ST_Area();
    ST_Equals stEquals = new ST_Equals();
    ST_ExteriorRing stExteriorRing = new ST_ExteriorRing();
    ST_GeometryType typer = new ST_GeometryType();
    ST_SetSRID stSrid = new ST_SetSRID();
    String expty = "ST_MULTIPOLYGON";

    @Test
    public void TestBasic() throws Exception {
        ST_MultiPolygon stMultiPolygon = new ST_MultiPolygon();
        ArrayList<DoubleWritable> args = new ArrayList<DoubleWritable>(7);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw1);
        args.add(this.dw1);
        args.add(this.dw0);
        BytesWritable rslt = stMultiPolygon.evaluate(new List[]{args});
        Text gty = this.typer.evaluate(rslt);
        Assert.assertEquals((Object)this.expty, (Object)gty.toString());
    }

    @Test
    public void TestStart() throws Exception {
        ST_MultiPolygon stMultiPolygon = new ST_MultiPolygon();
        ArrayList<DoubleWritable> args = new ArrayList<DoubleWritable>(7);
        args.add(this.dw0);
        args.add(this.dw1);
        args.add(this.dw1);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw0);
        BytesWritable rslt = stMultiPolygon.evaluate(new List[]{args});
        BytesWritable cmp = stMultiPolygon.evaluate(new Text("multipolygon(((0 1, 1 0, 0 0)))"));
        Assert.assertEquals((double)0.5, (double)this.stArea.evaluate(rslt).get(), (double)0.0);
    }

    @Test
    public void TestWinding() throws Exception {
        ST_MultiPolygon stMultiPolygon = new ST_MultiPolygon();
        ArrayList<DoubleWritable> args = new ArrayList<DoubleWritable>(7);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw1);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw1);
        BytesWritable rslt = stMultiPolygon.evaluate(new List[]{args});
        Text gty = this.typer.evaluate(rslt);
        Assert.assertEquals((Object)this.expty, (Object)gty.toString());
        Assert.assertEquals((double)0.5, (double)this.stArea.evaluate(rslt).get(), (double)0.0);
    }

    @Test
    public void TestSrid() throws Exception {
        ST_MultiPolygon stMultiPolygon = new ST_MultiPolygon();
        ArrayList<DoubleWritable> args = new ArrayList<DoubleWritable>(7);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw1);
        args.add(this.dw0);
        args.add(this.dw0);
        args.add(this.dw1);
        BytesWritable made = stMultiPolygon.evaluate(new List[]{args});
        Text gty = this.typer.evaluate(made);
        Assert.assertEquals((Object)this.expty, (Object)gty.toString());
        BytesWritable rslt = this.stSrid.evaluate(made, new IntWritable(4326));
        gty = this.typer.evaluate(rslt);
        Assert.assertEquals((Object)this.expty, (Object)gty.toString());
    }
}

