/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeometryType;
import org.apache.hadoop.hive.ql.udf.esri.ST_LineString;
import org.apache.hadoop.hive.ql.udf.esri.ST_Point;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestStLineString {
    @Test
    public void test() throws Exception {
        ST_GeometryType typer = new ST_GeometryType();
        ST_LineString stLn = new ST_LineString();
        DoubleWritable ten = new DoubleWritable(10.0);
        DoubleWritable twenty = new DoubleWritable(20.0);
        BytesWritable bwGeom = stLn.evaluate(new DoubleWritable[]{ten, ten, twenty});
        Assert.assertEquals(null, (Object)bwGeom);
        bwGeom = stLn.evaluate(new DoubleWritable[]{ten, ten, twenty, twenty});
        Text gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_LINESTRING", (Object)gty.toString());
        Text wkt = new Text("linestring (10 10, 20 20)");
        bwGeom = stLn.evaluate(wkt);
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_LINESTRING", (Object)gty.toString());
        bwGeom = stLn.evaluate(new Text("linestring z (10 10 2, 20 20 4)"));
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_LINESTRING", (Object)gty.toString());
        ArrayList<DoubleWritable> xs = new ArrayList<DoubleWritable>(Arrays.asList(ten, twenty));
        ArrayList<DoubleWritable> ys = new ArrayList<DoubleWritable>(Arrays.asList(twenty, ten));
        bwGeom = stLn.evaluate(xs, ys);
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_LINESTRING", (Object)gty.toString());
        BytesWritable pt1020 = new ST_Point().evaluate(ten, twenty);
        BytesWritable pt2010 = new ST_Point().evaluate(twenty, ten);
        ArrayList<BytesWritable> pts = new ArrayList<BytesWritable>(Arrays.asList(pt1020, pt2010));
        bwGeom = stLn.evaluate(pts);
        gty = typer.evaluate(bwGeom);
        Assert.assertEquals((Object)"ST_LINESTRING", (Object)gty.toString());
    }
}

