/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_GeomFromShape;
import org.apache.hadoop.hive.ql.udf.esri.ST_SRID;
import org.apache.hadoop.hive.ql.udf.esri.ST_X;
import org.apache.hadoop.hive.ql.udf.esri.ST_Y;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestStGeomFromShape {
    private static final double Epsilon = 1.0E-4;

    private static Point createFirstLocation() {
        double longitude = 12.224;
        double latitude = 51.829;
        return new Point(12.224, 51.829);
    }

    private static Point createSecondLocation() {
        double longitude = 12.39807;
        double latitude = 51.34933;
        return new Point(12.39807, 51.34933);
    }

    private static Point createThirdLocation() {
        double longitude = 6.9823;
        double latitude = 50.7657;
        return new Point(6.9823, 50.7657);
    }

    private static Point createFourthLocation() {
        double longitude = 7.102594;
        double latitude = 50.73733;
        return new Point(7.102594, 50.73733);
    }

    private static Polyline createLine() {
        Polyline line = new Polyline();
        line.startPath(TestStGeomFromShape.createFirstLocation());
        line.lineTo(TestStGeomFromShape.createSecondLocation());
        return line;
    }

    private static Polyline createPolyline() {
        Polyline line = new Polyline();
        line.startPath(TestStGeomFromShape.createFirstLocation());
        line.lineTo(TestStGeomFromShape.createSecondLocation());
        line.lineTo(TestStGeomFromShape.createThirdLocation());
        line.lineTo(TestStGeomFromShape.createFourthLocation());
        return line;
    }

    private static Polygon createPolygon() {
        Polygon polygon = new Polygon();
        polygon.startPath(TestStGeomFromShape.createFirstLocation());
        polygon.lineTo(TestStGeomFromShape.createSecondLocation());
        polygon.lineTo(TestStGeomFromShape.createThirdLocation());
        polygon.lineTo(TestStGeomFromShape.createFourthLocation());
        polygon.closeAllPaths();
        return polygon;
    }

    private static void validatePoint(Point point, int wkid, BytesWritable geometryAsWritable) {
        ST_X getX = new ST_X();
        DoubleWritable xAsWritable = getX.evaluate(geometryAsWritable);
        Assert.assertNotNull((String)"The x writable must not be null!", (Object)xAsWritable);
        ST_Y getY = new ST_Y();
        DoubleWritable yAsWritable = getY.evaluate(geometryAsWritable);
        Assert.assertNotNull((String)"The y writable must not be null!", (Object)yAsWritable);
        Assert.assertEquals((String)"Longitude is different!", (double)point.getX(), (double)xAsWritable.get(), (double)1.0E-4);
        Assert.assertEquals((String)"Latitude is different!", (double)point.getY(), (double)yAsWritable.get(), (double)1.0E-4);
        ST_SRID getWkid = new ST_SRID();
        IntWritable wkidAsWritable = getWkid.evaluate(geometryAsWritable);
        Assert.assertNotNull((String)"The wkid writable must not be null!", (Object)wkidAsWritable);
        Assert.assertEquals((String)"The wkid is different!", (long)wkid, (long)wkidAsWritable.get());
    }

    @Test
    public void testGeomFromPointShapeWithoutSpatialReference() throws UDFArgumentException {
        Point point = TestStGeomFromShape.createFirstLocation();
        byte[] esriShape = GeometryEngine.geometryToEsriShape((Geometry)point);
        Assert.assertNotNull((String)"The shape must not be null!", (Object)esriShape);
        BytesWritable shapeAsWritable = new BytesWritable(esriShape);
        Assert.assertNotNull((String)"The shape writable must not be null!", (Object)shapeAsWritable);
        ST_GeomFromShape fromShape = new ST_GeomFromShape();
        BytesWritable geometryAsWritable = fromShape.evaluate(shapeAsWritable);
        Assert.assertNotNull((String)"The geometry writable must not be null!", (Object)geometryAsWritable);
        boolean wkid = false;
        TestStGeomFromShape.validatePoint(point, 0, geometryAsWritable);
    }

    @Test
    public void testGeomFromPointShape() throws UDFArgumentException {
        Point point = TestStGeomFromShape.createFirstLocation();
        byte[] esriShape = GeometryEngine.geometryToEsriShape((Geometry)point);
        Assert.assertNotNull((String)"The shape must not be null!", (Object)esriShape);
        BytesWritable shapeAsWritable = new BytesWritable(esriShape);
        Assert.assertNotNull((String)"The shape writable must not be null!", (Object)shapeAsWritable);
        int wkid = 4326;
        ST_GeomFromShape fromShape = new ST_GeomFromShape();
        BytesWritable geometryAsWritable = fromShape.evaluate(shapeAsWritable, 4326);
        Assert.assertNotNull((String)"The geometry writable must not be null!", (Object)geometryAsWritable);
        TestStGeomFromShape.validatePoint(point, 4326, geometryAsWritable);
    }

    @Test
    public void testGeomFromLineShape() throws UDFArgumentException {
        Polyline line = TestStGeomFromShape.createLine();
        byte[] esriShape = GeometryEngine.geometryToEsriShape((Geometry)line);
        Assert.assertNotNull((String)"The shape must not be null!", (Object)esriShape);
        BytesWritable shapeAsWritable = new BytesWritable(esriShape);
        Assert.assertNotNull((String)"The shape writable must not be null!", (Object)shapeAsWritable);
        int wkid = 4326;
        ST_GeomFromShape fromShape = new ST_GeomFromShape();
        BytesWritable geometryAsWritable = fromShape.evaluate(shapeAsWritable, 4326);
        Assert.assertNotNull((String)"The geometry writable must not be null!", (Object)geometryAsWritable);
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape((BytesWritable)geometryAsWritable);
        Assert.assertNotNull((String)"The OGC geometry must not be null!", (Object)ogcGeometry);
        Geometry esriGeometry = ogcGeometry.getEsriGeometry();
        Assert.assertNotNull((String)"The Esri geometry must not be null!", (Object)esriGeometry);
        Assert.assertTrue((String)"The geometries are different!", (boolean)GeometryEngine.equals((Geometry)line, (Geometry)esriGeometry, (SpatialReference)SpatialReference.create((int)4326)));
    }

    @Test
    public void testGeomFromPolylineShape() throws UDFArgumentException {
        Polyline line = TestStGeomFromShape.createPolyline();
        byte[] esriShape = GeometryEngine.geometryToEsriShape((Geometry)line);
        Assert.assertNotNull((String)"The shape must not be null!", (Object)esriShape);
        BytesWritable shapeAsWritable = new BytesWritable(esriShape);
        Assert.assertNotNull((String)"The shape writable must not be null!", (Object)shapeAsWritable);
        int wkid = 4326;
        ST_GeomFromShape fromShape = new ST_GeomFromShape();
        BytesWritable geometryAsWritable = fromShape.evaluate(shapeAsWritable, 4326);
        Assert.assertNotNull((String)"The geometry writable must not be null!", (Object)geometryAsWritable);
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape((BytesWritable)geometryAsWritable);
        Assert.assertNotNull((String)"The OGC geometry must not be null!", (Object)ogcGeometry);
        Geometry esriGeometry = ogcGeometry.getEsriGeometry();
        Assert.assertNotNull((String)"The Esri geometry must not be null!", (Object)esriGeometry);
        Assert.assertTrue((String)"The geometries are different!", (boolean)GeometryEngine.equals((Geometry)line, (Geometry)esriGeometry, (SpatialReference)SpatialReference.create((int)4326)));
    }

    @Test
    public void testGeomFromPolygonShape() throws UDFArgumentException {
        Polygon polygon = TestStGeomFromShape.createPolygon();
        byte[] esriShape = GeometryEngine.geometryToEsriShape((Geometry)polygon);
        Assert.assertNotNull((String)"The shape must not be null!", (Object)esriShape);
        BytesWritable shapeAsWritable = new BytesWritable(esriShape);
        Assert.assertNotNull((String)"The shape writable must not be null!", (Object)shapeAsWritable);
        int wkid = 4326;
        ST_GeomFromShape fromShape = new ST_GeomFromShape();
        BytesWritable geometryAsWritable = fromShape.evaluate(shapeAsWritable, 4326);
        Assert.assertNotNull((String)"The geometry writable must not be null!", (Object)geometryAsWritable);
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape((BytesWritable)geometryAsWritable);
        Assert.assertNotNull((String)"The OGC geometry must not be null!", (Object)ogcGeometry);
        Geometry esriGeometry = ogcGeometry.getEsriGeometry();
        Assert.assertNotNull((String)"The Esri geometry must not be null!", (Object)esriGeometry);
        Assert.assertTrue((String)"The geometries are different!", (boolean)GeometryEngine.equals((Geometry)polygon, (Geometry)esriGeometry, (SpatialReference)SpatialReference.create((int)4326)));
    }
}

