/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Point;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsText;
import org.apache.hadoop.hive.ql.udf.esri.ST_Centroid;
import org.apache.hadoop.hive.ql.udf.esri.ST_LineString;
import org.apache.hadoop.hive.ql.udf.esri.ST_MultiPoint;
import org.apache.hadoop.hive.ql.udf.esri.ST_Point;
import org.apache.hadoop.hive.ql.udf.esri.ST_Polygon;
import org.apache.hadoop.hive.ql.udf.esri.ST_X;
import org.apache.hadoop.hive.ql.udf.esri.ST_Y;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestStCentroid {
    private static final double Epsilon = 1.0E-4;

    private static void validatePoint(Point point, BytesWritable geometryAsWritable) {
        ST_X getX = new ST_X();
        ST_Y getY = new ST_Y();
        DoubleWritable xAsWritable = getX.evaluate(geometryAsWritable);
        DoubleWritable yAsWritable = getY.evaluate(geometryAsWritable);
        if (null == xAsWritable || null == yAsWritable || Math.abs(point.getX() - xAsWritable.get()) > 1.0E-4 || Math.abs(point.getY() - yAsWritable.get()) > 1.0E-4) {
            System.err.println("validateCentroid: " + new ST_AsText().evaluate(geometryAsWritable) + " ~ " + point);
        }
        Assert.assertNotNull((String)"The x writable must not be null!", (Object)xAsWritable);
        Assert.assertNotNull((String)"The y writable must not be null!", (Object)yAsWritable);
        Assert.assertEquals((String)"Longitude is different!", (double)point.getX(), (double)xAsWritable.get(), (double)1.0E-4);
        Assert.assertEquals((String)"Latitude is different!", (double)point.getY(), (double)yAsWritable.get(), (double)1.0E-4);
    }

    @Test
    public void TestSimplePointCentroid() throws Exception {
        ST_Centroid stCtr = new ST_Centroid();
        ST_Point stPt = new ST_Point();
        BytesWritable bwGeom = stPt.evaluate(new Text("point (2 3)"));
        BytesWritable bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(2.0, 3.0), bwCentroid);
    }

    @Test
    public void TestMultiPointCentroid() throws Exception {
        ST_Centroid stCtr = new ST_Centroid();
        ST_MultiPoint stMp = new ST_MultiPoint();
        BytesWritable bwGeom = stMp.evaluate(new Text("multipoint ((0 0), (1 1), (1 -1), (6 0))"));
        BytesWritable bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(2.0, 0.0), bwCentroid);
    }

    @Test
    public void TestLineCentroid() throws Exception {
        ST_Centroid stCtr = new ST_Centroid();
        ST_LineString stLn = new ST_LineString();
        BytesWritable bwGeom = stLn.evaluate(new Text("linestring (0 0, 6 0)"));
        BytesWritable bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(3.0, 0.0), bwCentroid);
        bwGeom = stLn.evaluate(new Text("linestring (0 0, 0 4, 12 4)"));
        bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(4.5, 3.5), bwCentroid);
    }

    @Test
    public void TestPolygonCentroid() throws Exception {
        ST_Centroid stCtr = new ST_Centroid();
        ST_Polygon stPoly = new ST_Polygon();
        BytesWritable bwGeom = stPoly.evaluate(new Text("polygon ((0 0, 0 8, 8 8, 8 0, 0 0))"));
        BytesWritable bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(4.0, 4.0), bwCentroid);
        bwGeom = stPoly.evaluate(new Text("polygon ((1 1, 5 1, 3 4, 1 1))"));
        bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(3.0, 2.0), bwCentroid);
        bwGeom = stPoly.evaluate(new Text("polygon ((14 0, -14 0, -2 24, 2 24, 14 0))"));
        bwCentroid = stCtr.evaluate(bwGeom);
        TestStCentroid.validatePoint(new Point(0.0, 9.0), bwCentroid);
    }
}

