/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Point;
import org.apache.hadoop.hive.ql.udf.esri.ST_AsShape;
import org.apache.hadoop.hive.ql.udf.esri.ST_Point;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestStAsShape {
    private static final double Epsilon = 1.0E-4;

    @Test
    public void testPointAsShape() {
        ST_Point point = new ST_Point();
        double longitude = 12.224;
        double latitude = 51.829;
        BytesWritable pointAsWritable = point.evaluate(new DoubleWritable(12.224), new DoubleWritable(51.829));
        Assert.assertNotNull((String)"The point writable must not be null!", (Object)pointAsWritable);
        ST_AsShape asShape = new ST_AsShape();
        BytesWritable shapeAsWritable = asShape.evaluate(pointAsWritable);
        Assert.assertNotNull((String)"The shape writable must not be null!", (Object)pointAsWritable);
        byte[] esriShapeBuffer = shapeAsWritable.getBytes();
        Geometry esriGeometry = GeometryEngine.geometryFromEsriShape((byte[])esriShapeBuffer, (Geometry.Type)Geometry.Type.Point);
        Assert.assertNotNull((String)"The geometry must not be null!", (Object)esriGeometry);
        Assert.assertTrue((String)"Geometry type point expected!", (boolean)(esriGeometry instanceof Point));
        Point esriPoint = (Point)esriGeometry;
        Assert.assertEquals((String)"Longitude is different!", (double)12.224, (double)esriPoint.getX(), (double)1.0E-4);
        Assert.assertEquals((String)"Latitude is different!", (double)51.829, (double)esriPoint.getY(), (double)1.0E-4);
    }
}

