/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFCosh;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSinh;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFTanh;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestUDFMath {
    private HiveDecimalWritable input = null;

    @Test
    public void testAcos() throws HiveException {
        UDFAcos udf = new UDFAcos();
        this.input = this.createDecimal("0.716");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.7727408115633954, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testAsin() throws HiveException {
        UDFAsin udf = new UDFAsin();
        this.input = this.createDecimal("0.716");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.7980555152315012, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testAtan() throws HiveException {
        UDFAtan udf = new UDFAtan();
        this.input = this.createDecimal("1.0");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.7853981633974483, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testCos() throws HiveException {
        UDFCos udf = new UDFCos();
        this.input = this.createDecimal("0.7727408115633954");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.716, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testSin() throws HiveException {
        UDFSin udf = new UDFSin();
        this.input = this.createDecimal("0.7980555152315012");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.716, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testTan() throws HiveException {
        UDFTan udf = new UDFTan();
        this.input = this.createDecimal("0.7853981633974483");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)1.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testExp() throws HiveException {
        UDFExp udf = new UDFExp();
        this.input = this.createDecimal("2.0");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)7.38905609893065, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testLn() throws HiveException {
        UDFLn udf = new UDFLn();
        this.input = this.createDecimal("7.38905609893065");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)2.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testLog() throws HiveException {
        UDFLog udf = new UDFLog();
        this.input = this.createDecimal("7.38905609893065");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)2.0, (double)res.get(), (double)1.0E-6);
        res = udf.evaluate(this.createDecimal("3.0"), this.createDecimal("9.0"));
        Assert.assertEquals((double)2.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testLog10() throws HiveException {
        UDFLog10 udf = new UDFLog10();
        this.input = this.createDecimal("100.0");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)2.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testLog2() throws HiveException {
        UDFLog2 udf = new UDFLog2();
        this.input = this.createDecimal("8.0");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)3.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testRadians() throws HiveException {
        UDFRadians udf = new UDFRadians();
        this.input = this.createDecimal("45.0");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.7853981633974483, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testDegrees() throws HiveException {
        UDFDegrees udf = new UDFDegrees();
        this.input = this.createDecimal("0.7853981633974483");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)45.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testSqrt() throws HiveException {
        UDFSqrt udf = new UDFSqrt();
        this.input = this.createDecimal("49.0");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)7.0, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testCosh() throws HiveException {
        UDFCosh udf = new UDFCosh();
        this.input = this.createDecimal("0.7727408115633954");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)1.3137198299489201, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testSinh() throws HiveException {
        UDFSinh udf = new UDFSinh();
        this.input = this.createDecimal("0.7980555152315012");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.8855070376410608, (double)res.get(), (double)1.0E-6);
    }

    @Test
    public void testTanh() throws HiveException {
        UDFTanh udf = new UDFTanh();
        this.input = this.createDecimal("0.7853981633974483");
        DoubleWritable res = udf.evaluate(this.input);
        Assert.assertEquals((double)0.6557942026326724, (double)res.get(), (double)1.0E-6);
    }

    private HiveDecimalWritable createDecimal(String input) {
        return new HiveDecimalWritable(HiveDecimal.create((String)input));
    }
}

