/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.time.Instant;
import java.time.ZoneId;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorDay;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorHour;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMinute;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMonth;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorQuarter;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorSecond;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorWeek;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorYear;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.junit.Assert;
import org.junit.Test;

public class TestUDFDateFormatGranularity {
    @Test
    public void testTimestampToTimestampWithGranularity() throws Exception {
        TimestampWritableV2 t = new TimestampWritableV2(Timestamp.ofEpochMilli((long)494243222000L));
        UDFDateFloorYear g = new UDFDateFloorYear();
        TimestampWritableV2 i1 = g.evaluate(t);
        Assert.assertEquals((long)473385600000L, (long)i1.getTimestamp().toEpochMilli());
        g = new UDFDateFloorQuarter();
        TimestampWritableV2 i2 = g.evaluate(t);
        Assert.assertEquals((long)489024000000L, (long)i2.getTimestamp().toEpochMilli());
        g = new UDFDateFloorMonth();
        TimestampWritableV2 i3 = g.evaluate(t);
        Assert.assertEquals((long)491702400000L, (long)i3.getTimestamp().toEpochMilli());
        g = new UDFDateFloorWeek();
        TimestampWritableV2 i4 = g.evaluate(t);
        Assert.assertEquals((long)493862400000L, (long)i4.getTimestamp().toEpochMilli());
        g = new UDFDateFloorDay();
        TimestampWritableV2 i5 = g.evaluate(t);
        Assert.assertEquals((long)494208000000L, (long)i5.getTimestamp().toEpochMilli());
        g = new UDFDateFloorHour();
        TimestampWritableV2 i6 = g.evaluate(t);
        Assert.assertEquals((long)494240400000L, (long)i6.getTimestamp().toEpochMilli());
        g = new UDFDateFloorMinute();
        TimestampWritableV2 i7 = g.evaluate(t);
        Assert.assertEquals((long)494243220000L, (long)i7.getTimestamp().toEpochMilli());
        g = new UDFDateFloorSecond();
        TimestampWritableV2 i8 = g.evaluate(t);
        Assert.assertEquals((long)494243222000L, (long)i8.getTimestamp().toEpochMilli());
    }

    @Test
    public void testTimestampWithLocalTZGranularity() throws Exception {
        TimestampLocalTZWritable t = new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(494243222000L).atZone(ZoneId.of("America/Los_Angeles"))));
        UDFDateFloorYear g = new UDFDateFloorYear();
        TimestampLocalTZWritable i1 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(473414400000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i1.getTimestampTZ());
        g = new UDFDateFloorQuarter();
        TimestampLocalTZWritable i2 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(489049200000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i2.getTimestampTZ());
        g = new UDFDateFloorMonth();
        TimestampLocalTZWritable i3 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(491727600000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i3.getTimestampTZ());
        g = new UDFDateFloorWeek();
        TimestampLocalTZWritable i4 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(493887600000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i4.getTimestampTZ());
        g = new UDFDateFloorDay();
        TimestampLocalTZWritable i5 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(494233200000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i5.getTimestampTZ());
        g = new UDFDateFloorHour();
        TimestampLocalTZWritable i6 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(494240400000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i6.getTimestampTZ());
        g = new UDFDateFloorMinute();
        TimestampLocalTZWritable i7 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(494243220000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i7.getTimestampTZ());
        g = new UDFDateFloorSecond();
        TimestampLocalTZWritable i8 = g.evaluate(t);
        Assert.assertEquals((Object)new TimestampTZ(Instant.ofEpochMilli(494243222000L).atZone(ZoneId.of("America/Los_Angeles"))), (Object)i8.getTimestampTZ());
    }
}

