/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.handler;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.CleanupRequest;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.TestCleaner;
import org.apache.hadoop.hive.ql.txn.compactor.handler.CompactionCleaner;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TaskHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHandler
extends TestCleaner {
    @Test
    public void testCompactionHandlerAndFsRemover() throws Exception {
        Table t = this.newTable("default", "handler_test", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 25);
        CompactionRequest rqst = new CompactionRequest(t.getDbName(), t.getTableName(), CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new CompactionCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        AtomicBoolean stop = new AtomicBoolean(true);
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(stop);
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
    }

    @Test
    public void testMetaCache() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, false);
        Table t = this.newTable("default", "retry_test", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "retry_test", 25);
        CompactionRequest rqst = new CompactionRequest("default", "retry_test", CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        MetadataCache mockedMetadataCache = (MetadataCache)Mockito.spy((Object)new MetadataCache(true));
        TxnStore mockedTxnHandler = (TxnStore)Mockito.spy((Object)this.txnHandler);
        FSRemover fsRemover = new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), mockedMetadataCache);
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new CompactionCleaner(this.conf, mockedTxnHandler, mockedMetadataCache, false, fsRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        ((MetadataCache)Mockito.verify((Object)mockedMetadataCache, (VerificationMode)Mockito.times((int)3))).computeIfAbsent((String)ArgumentMatchers.any(), (Callable)ArgumentMatchers.any());
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).resolveTable((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }
}

