/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.CleanupRequest;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.handler.AbortedTxnCleaner;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TaskHandler;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TestHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class TestAbortedTxnCleaner
extends TestHandler {
    @Test
    public void testCleaningOfAbortedDirectoriesForUnpartitionedTables() throws Exception {
        String dbName = "default";
        String tableName = "handler_unpart_test";
        Table t = this.newTable(dbName, tableName, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        List<Path> directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @Test
    public void testCleaningOfAbortedDirectoriesForSinglePartition() throws Exception {
        String dbName = "default";
        String tableName = "handler_part_single_test";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, true);
        Partition p = this.newPartition(t, partName);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        List<Path> directories = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @Test
    public void testCleaningOfAbortedDirectoriesForMultiplePartitions() throws Exception {
        String dbName = "default";
        String tableName = "handler_part_multiple_test";
        String partName1 = "today1";
        String partName2 = "today2";
        Table t = this.newTable(dbName, tableName, true);
        Partition p1 = this.newPartition(t, partName1);
        Partition p2 = this.newPartition(t, partName2);
        this.addDeltaFileWithTxnComponents(t, p1, 2, true);
        this.addDeltaFileWithTxnComponents(t, p1, 2, true);
        this.addDeltaFileWithTxnComponents(t, p1, 2, false);
        this.addDeltaFileWithTxnComponents(t, p1, 2, true);
        this.addDeltaFileWithTxnComponents(t, p2, 2, true);
        this.addDeltaFileWithTxnComponents(t, p2, 2, true);
        this.addDeltaFileWithTxnComponents(t, p2, 2, false);
        this.addDeltaFileWithTxnComponents(t, p2, 2, true);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)2))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        List<Path> directories = this.getDirectories(this.conf, t, p1);
        Assert.assertEquals((long)1L, (long)directories.size());
        directories = this.getDirectories(this.conf, t, p2);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @Test
    public void testCleaningOfAbortedDirectoriesWithLongRunningOpenWriteTxn() throws Exception {
        String dbName = "default";
        String tableName = "handler_unpart_open_test";
        Table t = this.newTable(dbName, tableName, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        long openTxnId = this.openTxn();
        long writeId = this.ms.allocateTableWriteId(openTxnId, t.getDbName(), t.getTableName());
        this.acquireLock(t, null, openTxnId);
        this.addDeltaFile(t, null, writeId, writeId, 2);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        List<Path> directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)3L, (long)directories.size());
        this.txnHandler.commitTxn(new CommitTxnRequest(openTxnId));
    }

    @Test
    public void testCleaningOfAbortedDirectoriesOnTopOfBase() throws Exception {
        String dbName = "default";
        String tableName = "handler_unpart_top_test";
        Table t = this.newTable(dbName, tableName, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        CompactionRequest cr = new CompactionRequest(dbName, tableName, CompactionType.MAJOR);
        this.txnHandler.compact(cr);
        this.startWorker();
        List<Path> directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)5L, (long)directories.size());
        Assert.assertEquals((long)1L, (long)directories.stream().filter(dir -> dir.getName().startsWith("base_")).count());
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)directories.size());
        Assert.assertTrue((boolean)directories.get(0).getName().startsWith("base_"));
    }

    @Test
    public void testCleaningOfAbortedDirectoriesBelowBase() throws Exception {
        String dbName = "default";
        String tableName = "handler_unpart_below_test";
        Table t = this.newTable(dbName, tableName, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        CompactionRequest cr = new CompactionRequest(dbName, tableName, CompactionType.MAJOR);
        this.txnHandler.compact(cr);
        this.startWorker();
        List<Path> directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)5L, (long)directories.size());
        Assert.assertEquals((long)1L, (long)directories.stream().filter(dir -> dir.getName().startsWith("base_")).count());
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @Test
    public void testAbortedCleaningWithThreeTxnsWithDiffWriteIds() throws Exception {
        String dbName = "default";
        String tableName = "handler_unpart_writeid_test";
        Table t = this.newTable(dbName, tableName, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, true);
        this.addDeltaFileWithTxnComponents(t, null, 2, false);
        long openTxnId1 = this.openTxn();
        long openTxnId2 = this.openTxn();
        long openTxnId3 = this.openTxn();
        long writeId2 = this.ms.allocateTableWriteId(openTxnId2, t.getDbName(), t.getTableName());
        long writeId3 = this.ms.allocateTableWriteId(openTxnId3, t.getDbName(), t.getTableName());
        long writeId1 = this.ms.allocateTableWriteId(openTxnId1, t.getDbName(), t.getTableName());
        assert (writeId2 < writeId1 && writeId2 < writeId3);
        this.acquireLock(t, null, openTxnId3);
        this.acquireLock(t, null, openTxnId2);
        this.acquireLock(t, null, openTxnId1);
        this.addDeltaFile(t, null, writeId3, writeId3, 2);
        this.addDeltaFile(t, null, writeId1, writeId1, 2);
        this.addDeltaFile(t, null, writeId2, writeId2, 2);
        this.ms.abortTxns(Collections.singletonList(openTxnId2));
        this.ms.commitTxn(openTxnId3);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        List<Path> directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)5L, (long)directories.size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testAbortCleanupNotUpdatingSpecificCompactionTables(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "abort_cleanup_not_populating_compaction_tables_test";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER, (boolean)true);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover));
        TxnCommandsBaseForTests.runInitiator(this.conf);
        String compactionQueuePresence = "SELECT COUNT(*) FROM \"COMPACTION_QUEUE\"  WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL");
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.conf, (String)compactionQueuePresence));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((FSRemover)Mockito.verify((Object)mockedFSRemover, (VerificationMode)Mockito.times((int)1))).clean((CleanupRequest)ArgumentMatchers.any(CleanupRequest.class));
        ((TaskHandler)Mockito.verify((Object)mockedTaskHandler, (VerificationMode)Mockito.times((int)1))).getTasks();
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.conf, (String)compactionQueuePresence));
        Assert.assertEquals((long)0L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.conf, (String)("SELECT COUNT(*) FROM \"COMPLETED_COMPACTIONS\"  WHERE \"CC_DATABASE\" = '" + dbName + "' AND \"CC_TABLE\" = '" + tableName + "' AND \"CC_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL"))));
        Assert.assertEquals((long)1L, (long)TestTxnDbUtil.countQueryAgent((Configuration)this.conf, (String)("SELECT COUNT(*) FROM \"COMPLETED_TXN_COMPONENTS\"  WHERE \"CTC_DATABASE\" = '" + dbName + "' AND \"CTC_TABLE\" = '" + tableName + "' AND \"CTC_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL"))));
        List<Path> directories = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)directories.size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRetryEntryOnFailures(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "handler_retry_entry";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        TxnStore mockedTxnHandler = (TxnStore)Mockito.spy((Object)this.txnHandler);
        TaskHandler mockedTaskHandler = (TaskHandler)Mockito.spy((Object)new AbortedTxnCleaner(this.conf, mockedTxnHandler, metadataCache, false, mockedFSRemover));
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(mockedTaskHandler));
        cleaner.run();
        ((TxnStore)Mockito.verify((Object)mockedTxnHandler, (VerificationMode)Mockito.times((int)1))).setCleanerRetryRetentionTimeOnError((CompactionInfo)ArgumentMatchers.any(CompactionInfo.class));
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        String whereClause = " WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL") + " AND \"CQ_TYPE\" = 'c' AND \"CQ_STATE\" = 'r'";
        String retryRetentionQuery = "SELECT \"CQ_RETRY_RETENTION\" FROM \"COMPACTION_QUEUE\" " + whereClause;
        Assert.assertEquals((Object)Long.toString(MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS)), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRetryInfoBeingUsed(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "handler_retry_usage";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        long retryRetentionTime = 10000L;
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (long)retryRetentionTime, (TimeUnit)TimeUnit.MILLISECONDS);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        AbortedTxnCleaner taskHandler = new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover);
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        String whereClause = " WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL") + " AND \"CQ_TYPE\" = 'c' AND \"CQ_STATE\" = 'r'";
        String retryRetentionQuery = "SELECT \"CQ_RETRY_RETENTION\" FROM \"COMPACTION_QUEUE\" " + whereClause;
        Assert.assertEquals((Object)Long.toString(retryRetentionTime), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
        Thread.sleep(retryRetentionTime);
        ((FSRemover)Mockito.doAnswer(InvocationOnMock::callRealMethod).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        Assert.assertEquals((long)0L, (long)this.txnHandler.showCompact(new ShowCompactRequest()).getCompactsSize());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRetryWithinRetentionTime(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "handler_retry_nodelay";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        AbortedTxnCleaner taskHandler = new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover);
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        String whereClause = " WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL") + " AND \"CQ_TYPE\" = 'c' AND \"CQ_STATE\" = 'r'";
        String retryRetentionQuery = "SELECT \"CQ_RETRY_RETENTION\" FROM \"COMPACTION_QUEUE\" " + whereClause;
        Assert.assertEquals((Object)Long.toString(MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS)), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
        ((FSRemover)Mockito.doAnswer(InvocationOnMock::callRealMethod).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        Assert.assertEquals((Object)Long.toString(MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS)), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRetryUpdateRetentionTimeWhenFailedTwice(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "handler_retry_retention_time_failed_twice";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        long retryRetentionTime = 10000L;
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (long)retryRetentionTime, (TimeUnit)TimeUnit.MILLISECONDS);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        AbortedTxnCleaner taskHandler = new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover);
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        String whereClause = " WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL") + " AND \"CQ_TYPE\" = 'c' AND \"CQ_STATE\" = 'r'";
        String retryRetentionQuery = "SELECT \"CQ_RETRY_RETENTION\" FROM \"COMPACTION_QUEUE\" " + whereClause;
        Assert.assertEquals((Object)Long.toString(retryRetentionTime), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
        Thread.sleep(retryRetentionTime);
        cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        Assert.assertEquals((Object)Long.toString(2L * retryRetentionTime), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRetryUpdateErrorMessageWhenFailedTwice(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "handler_retry_error_msg_failed_twice";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        long retryRetentionTime = 10000L;
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (long)retryRetentionTime, (TimeUnit)TimeUnit.MILLISECONDS);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        AbortedTxnCleaner taskHandler = new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover);
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing first retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing first retry") ? 1 : 0) != 0);
        String whereClause = " WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL") + " AND \"CQ_TYPE\" = 'c' AND \"CQ_STATE\" = 'r'";
        String retryRetentionQuery = "SELECT \"CQ_RETRY_RETENTION\" FROM \"COMPACTION_QUEUE\" " + whereClause;
        Assert.assertEquals((Object)Long.toString(retryRetentionTime), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
        Thread.sleep(retryRetentionTime);
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing second retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing second retry") ? 1 : 0) != 0);
        Assert.assertEquals((Object)Long.toString(2L * retryRetentionTime), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testZeroRetryRetentionTimeForAbortCleanup(boolean isPartitioned) throws Exception {
        String dbName = "default";
        String tableName = "handler_zero_retryretention";
        String partName = "today";
        Table t = this.newTable(dbName, tableName, isPartitioned);
        Partition p = isPartitioned ? this.newPartition(t, partName) : null;
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, true);
        this.addDeltaFileWithTxnComponents(t, p, 2, false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)0);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (long)0L, (TimeUnit)TimeUnit.MILLISECONDS);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover mockedFSRemover = (FSRemover)Mockito.spy((Object)new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache));
        AbortedTxnCleaner taskHandler = new AbortedTxnCleaner(this.conf, this.txnHandler, metadataCache, false, mockedFSRemover);
        ((FSRemover)Mockito.doAnswer(invocationOnMock -> {
            throw new RuntimeException("Testing retry");
        }).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertTrue((scre.getDbname().equals(dbName) && scre.getTablename().equals(tableName) && (isPartitioned ? scre.getPartitionname().equals("ds=" + partName) : scre.getPartitionname() == null) && "ready for cleaning".equalsIgnoreCase(scre.getState()) && scre.getType() == CompactionType.ABORT_TXN_CLEANUP && scre.getErrorMessage().equalsIgnoreCase("Testing retry") ? 1 : 0) != 0);
        String whereClause = " WHERE \"CQ_DATABASE\" = '" + dbName + "' AND \"CQ_TABLE\" = '" + tableName + "' AND \"CQ_PARTITION\"" + (String)(isPartitioned ? " = 'ds=" + partName + "'" : " IS NULL") + " AND \"CQ_TYPE\" = 'c' AND \"CQ_STATE\" = 'r'";
        String retryRetentionQuery = "SELECT \"CQ_RETRY_RETENTION\" FROM \"COMPACTION_QUEUE\" " + whereClause;
        Assert.assertEquals((Object)Integer.toString(0), (Object)TestTxnDbUtil.queryToString((Configuration)this.conf, (String)retryRetentionQuery, (boolean)false).replace("\n", "").trim());
        ((FSRemover)Mockito.doAnswer(InvocationOnMock::callRealMethod).when((Object)mockedFSRemover)).clean((CleanupRequest)ArgumentMatchers.any());
        cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(Arrays.asList(taskHandler));
        cleaner.run();
        Assert.assertEquals((long)0L, (long)this.txnHandler.showCompact(new ShowCompactRequest()).getCompactsSize());
    }
}

