/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.txn.compactor.MRCompactor;
import org.junit.Assert;
import org.junit.Test;

public class TestStringableList {
    @Test
    public void stringableList() throws Exception {
        MRCompactor.StringableList ls = new MRCompactor.StringableList();
        String s = ls.toString();
        Assert.assertEquals((Object)"0:", (Object)s);
        ls = new MRCompactor.StringableList(s);
        Assert.assertEquals((long)0L, (long)ls.size());
        ls = new MRCompactor.StringableList();
        ls.add((Object)new Path("/tmp"));
        ls.add((Object)new Path("/usr"));
        s = ls.toString();
        Assert.assertTrue((String)("Expected 2:4:/tmp4:/usr or 2:4:/usr4:/tmp, got " + s), ("2:4:/tmp4:/usr".equals(s) || "2:4:/usr4:/tmp".equals(s) ? 1 : 0) != 0);
        ls = new MRCompactor.StringableList(s);
        Assert.assertEquals((long)2L, (long)ls.size());
        boolean sawTmp = false;
        boolean sawUsr = false;
        for (Path p : ls) {
            if ("/tmp".equals(p.toString())) {
                sawTmp = true;
                continue;
            }
            if ("/usr".equals(p.toString())) {
                sawUsr = true;
                continue;
            }
            Assert.fail((String)("Unexpected path " + p.toString()));
        }
        Assert.assertTrue((boolean)sawTmp);
        Assert.assertTrue((boolean)sawUsr);
    }
}

