/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.txn.compactor.StatsUpdater;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class TestStatsUpdater {
    @Test
    public void testSetUpDriverSessionAddsCompactorPropertiesFromTableProperties() {
        StatsUpdater statsUpdater = new StatsUpdater();
        HiveConf conf = new HiveConf();
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("compactor.test.property", "test-value");
            }
        };
        HashMap ciProperties = new HashMap();
        HiveConf statsUpdaterConf = statsUpdater.setUpDriverSession(conf, "testQueue", (Map)tableProperties, ciProperties);
        MatcherAssert.assertThat((Object)statsUpdaterConf.get("test.property"), (Matcher)Matchers.is((Object)"test-value"));
    }

    @Test
    public void testSetUpDriverSessionAddsCompactorPropertiesFromCompactionInfo() {
        StatsUpdater statsUpdater = new StatsUpdater();
        HiveConf conf = new HiveConf();
        HashMap tableProperties = new HashMap();
        HashMap<String, String> ciProperties = new HashMap<String, String>(){
            {
                this.put("compactor.test.property", "test-value");
            }
        };
        HiveConf statsUpdaterConf = statsUpdater.setUpDriverSession(conf, "testQueue", tableProperties, (Map)ciProperties);
        MatcherAssert.assertThat((Object)statsUpdaterConf.get("test.property"), (Matcher)Matchers.is((Object)"test-value"));
    }

    @Test
    public void testSetUpDriverSessionOverridesExistingCompactorPropertiesWithTableProperties() {
        StatsUpdater statsUpdater = new StatsUpdater();
        HiveConf conf = new HiveConf();
        conf.set("compactor.test.property", "test-value");
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("compactor.test.property", "changed-in-table-properties");
            }
        };
        HiveConf statsUpdaterConf = statsUpdater.setUpDriverSession(conf, "testQueue", (Map)tableProperties, Collections.emptyMap());
        MatcherAssert.assertThat((Object)statsUpdaterConf.get("test.property"), (Matcher)Matchers.is((Object)"changed-in-table-properties"));
    }

    @Test
    public void testSetUpDriverSessionOverridesExistingCompactorPropertiesWithPropertiesInCompactionInfo() {
        StatsUpdater statsUpdater = new StatsUpdater();
        HiveConf conf = new HiveConf();
        conf.set("compactor.test.property", "test-value");
        HashMap<String, String> tableProperties = new HashMap<String, String>(){
            {
                this.put("compactor.test.property", "changed-in-table-properties");
            }
        };
        HashMap<String, String> ciProperties = new HashMap<String, String>(){
            {
                this.put("compactor.test.property", "changed-in-compaction-info");
            }
        };
        HiveConf statsUpdaterConf = statsUpdater.setUpDriverSession(conf, "testQueue", (Map)tableProperties, (Map)ciProperties);
        MatcherAssert.assertThat((Object)statsUpdaterConf.get("test.property"), (Matcher)Matchers.is((Object)"changed-in-compaction-info"));
    }
}

