/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.apache.hadoop.hive.ql.txn.compactor.MRCompactor;
import org.apache.hadoop.mapred.JobConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestMRCompactorJobQueueConfiguration {
    @ParameterizedTest
    @MethodSource(value={"generateBaseJobConfSetup"})
    void testCreateBaseJobConfHasCorrectJobQueue(ConfSetup input) {
        Table tbl = TestMRCompactorJobQueueConfiguration.createPersonTable();
        tbl.setParameters(input.tableProperties);
        MRCompactor compactor = new MRCompactor(null);
        CompactionInfo ci = new CompactionInfo(tbl.getDbName(), tbl.getTableName(), null, CompactionType.MAJOR);
        ci.properties = new StringableMap(input.compactionProperties).toString();
        HiveConf conf = new HiveConf();
        input.confProperties.forEach((arg_0, arg_1) -> ((HiveConf)conf).set(arg_0, arg_1));
        JobConf c = compactor.createBaseJobConf(conf, "test-job", tbl, tbl.getSd(), (ValidWriteIdList)new ValidReaderWriteIdList(), ci);
        Assertions.assertEquals((Object)input.expectedQueue, (Object)c.getQueueName(), (String)("Test failed for the following input:" + input));
    }

    private static Stream<ConfSetup> generateBaseJobConfSetup() {
        ArrayList<ConfSetup> inputs = new ArrayList<ConfSetup>();
        String mrProperty = "mapreduce.job.queuename";
        String hiveProperty = "hive.compactor.job.queue";
        String mrDeprecated = "mapred.job.queue.name";
        String u1 = "root.user1";
        String u2 = "root.user2";
        String u3 = "root.user3";
        String u4 = "root.user4";
        String u5 = "root.user5";
        String u6 = "root.user6";
        String su1 = "superuser1";
        String su2 = "superuser2";
        String su3 = "superuser3";
        inputs.add(new ConfSetup().tableProperty(mrDeprecated, u1).tableProperty(mrProperty, u2).tableProperty(hiveProperty, u3).setExpectedQueue(u3));
        inputs.add(new ConfSetup().tableProperty(mrDeprecated, u1).tableProperty(hiveProperty, u3).setExpectedQueue(u3));
        inputs.add(new ConfSetup().tableProperty(mrProperty, u2).tableProperty(hiveProperty, u3).setExpectedQueue(u3));
        inputs.add(new ConfSetup().tableProperty(mrDeprecated, u1).tableProperty(mrProperty, u2).setExpectedQueue(u2));
        inputs.add(new ConfSetup().tableProperty(mrDeprecated, u1).setExpectedQueue(u1));
        inputs.add(new ConfSetup().tableProperty(mrProperty, u2).setExpectedQueue(u2));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, u3).setExpectedQueue(u3));
        inputs.add(new ConfSetup().compactionProperty(mrDeprecated, u4).compactionProperty(mrProperty, u5).compactionProperty(hiveProperty, u6).setExpectedQueue(u6));
        inputs.add(new ConfSetup().compactionProperty(mrDeprecated, u4).compactionProperty(hiveProperty, u6).setExpectedQueue(u6));
        inputs.add(new ConfSetup().compactionProperty(mrProperty, u5).compactionProperty(hiveProperty, u6).setExpectedQueue(u6));
        inputs.add(new ConfSetup().compactionProperty(mrDeprecated, u4).compactionProperty(mrProperty, u5).setExpectedQueue(u5));
        inputs.add(new ConfSetup().compactionProperty(mrDeprecated, u4).setExpectedQueue(u4));
        inputs.add(new ConfSetup().compactionProperty(mrProperty, u5).setExpectedQueue(u5));
        inputs.add(new ConfSetup().compactionProperty(hiveProperty, u6).setExpectedQueue(u6));
        inputs.add(new ConfSetup().globalProperty(hiveProperty, su1).setExpectedQueue(su1));
        inputs.add(new ConfSetup().globalProperty(mrProperty, su2).setExpectedQueue(su2));
        inputs.add(new ConfSetup().globalProperty(mrDeprecated, su3).setExpectedQueue(su3));
        inputs.add(new ConfSetup().globalProperty(hiveProperty, su1).globalProperty(mrProperty, su2).globalProperty(mrDeprecated, su3).setExpectedQueue(su1));
        inputs.add(new ConfSetup().globalProperty(mrProperty, su2).globalProperty(mrDeprecated, su3).setExpectedQueue(su2));
        inputs.add(new ConfSetup().globalProperty(hiveProperty, su1).globalProperty(mrDeprecated, su3).setExpectedQueue(su1));
        inputs.add(new ConfSetup().globalProperty(hiveProperty, su1).globalProperty(mrProperty, su2).setExpectedQueue(su1));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, u3).compactionProperty(hiveProperty, u6).globalProperty(hiveProperty, su1).setExpectedQueue(u6));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, u3).globalProperty(hiveProperty, su1).setExpectedQueue(u3));
        inputs.add(new ConfSetup().compactionProperty(hiveProperty, u6).globalProperty(hiveProperty, su1).setExpectedQueue(u6));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, u3).compactionProperty(hiveProperty, u6).setExpectedQueue(u6));
        inputs.add(new ConfSetup().tableProperty(mrProperty, u2).compactionProperty(mrProperty, u5).globalProperty(hiveProperty, su1).setExpectedQueue(u5));
        inputs.add(new ConfSetup().tableProperty(mrDeprecated, u1).compactionProperty(mrDeprecated, u4).globalProperty(hiveProperty, su1).setExpectedQueue(u4));
        inputs.add(new ConfSetup().tableProperty(mrProperty, u2).globalProperty(hiveProperty, su1).setExpectedQueue(u2));
        inputs.add(new ConfSetup().tableProperty(mrDeprecated, u1).globalProperty(hiveProperty, su1).setExpectedQueue(u1));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, u3).compactionProperty(hiveProperty, "").globalProperty(hiveProperty, su1).setExpectedQueue(u3));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, "").compactionProperty(hiveProperty, "").globalProperty(hiveProperty, su1).setExpectedQueue(su1));
        inputs.add(new ConfSetup().tableProperty(hiveProperty, "").compactionProperty(hiveProperty, "").globalProperty(hiveProperty, "").setExpectedQueue("default"));
        return inputs.stream();
    }

    private static Table createPersonTable() {
        FieldSchema idField = new FieldSchema();
        idField.setName("id");
        idField.setType("int");
        FieldSchema nameField = new FieldSchema();
        nameField.setName("name");
        nameField.setType("string");
        StorageDescriptor descriptor = new StorageDescriptor();
        descriptor.setInputFormat("org.apache.hadoop.mapred.TextInputFormat");
        descriptor.setOutputFormat("org.apache.hadoop.mapred.TextInputFormat");
        descriptor.setLocation("hdfs:///apps/hive/warehouse/default.db/person");
        descriptor.setCompressed(false);
        descriptor.setCols(Arrays.asList(idField, nameField));
        long createTime = LocalDate.of(2022, 1, 24).atStartOfDay().toInstant(ZoneOffset.UTC).getEpochSecond();
        Table tbl = new Table();
        tbl.setDbName("default");
        tbl.setTableName("person");
        tbl.setOwner("hive");
        tbl.setCreateTime(Math.toIntExact(createTime));
        tbl.setLastAccessTime(Math.toIntExact(createTime));
        tbl.setSd(descriptor);
        tbl.setParameters(Collections.emptyMap());
        return tbl;
    }

    private static class ConfSetup {
        private final Map<String, String> tableProperties = new HashMap<String, String>();
        private final Map<String, String> compactionProperties = new HashMap<String, String>();
        private final Map<String, String> confProperties = new HashMap<String, String>();
        private String expectedQueue;

        private ConfSetup() {
        }

        ConfSetup tableProperty(String key, String value) {
            this.tableProperties.put("compactor." + key, value);
            return this;
        }

        ConfSetup compactionProperty(String key, String value) {
            this.compactionProperties.put("compactor." + key, value);
            return this;
        }

        ConfSetup globalProperty(String key, String value) {
            this.confProperties.put(key, value);
            return this;
        }

        ConfSetup setExpectedQueue(String name) {
            this.expectedQueue = name;
            return this;
        }

        public String toString() {
            return "ConfSetup{tableProperties=" + this.tableProperties + ", compactionProperties=" + this.compactionProperties + ", confProperties=" + this.confProperties + "}";
        }
    }
}

