/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestInitiator
extends CompactorTest {
    @Test
    public void nothing() throws Exception {
        this.startInitiator();
    }

    @Test
    public void recoverFailedLocalWorkers() throws Exception {
        Table t = this.newTable("default", "rflw1", false);
        CompactionRequest rqst = new CompactionRequest("default", "rflw1", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        t = this.newTable("default", "rflw2", false);
        rqst = new CompactionRequest("default", "rflw2", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.txnHandler.findNextToCompact(TestInitiator.aFindNextCompactRequest(ServerUtils.hostname() + "-193892", WORKER_VERSION));
        this.txnHandler.findNextToCompact(TestInitiator.aFindNextCompactRequest("nosuchhost-193892", WORKER_VERSION));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)2L, (long)compacts.size());
        boolean sawInitiated = false;
        for (ShowCompactResponseElement c : compacts) {
            if (c.getState().equals("working")) {
                Assert.assertEquals((Object)"nosuchhost-193892", (Object)c.getWorkerid());
                continue;
            }
            if (c.getState().equals("initiated")) {
                sawInitiated = true;
                continue;
            }
            Assert.fail((String)"Unexpected state");
        }
        Assert.assertTrue((boolean)sawInitiated);
    }

    @Test
    public void recoverFailedRemoteWorkers() throws Exception {
        Table t = this.newTable("default", "rfrw1", false);
        CompactionRequest rqst = new CompactionRequest("default", "rfrw1", CompactionType.MINOR);
        this.txnHandler.compact(rqst);
        this.txnHandler.findNextToCompact(TestInitiator.aFindNextCompactRequest("nosuchhost-193892", WORKER_VERSION));
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, 1L, TimeUnit.MILLISECONDS);
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
    }

    @Test
    public void majorCompactOnTableTooManyAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        Table t = this.newTable("default", "mcottma", false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("mcottma");
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        if (useCleanerForAbortCleanup) {
            Assert.assertEquals((long)0L, (long)compacts.size());
        } else {
            Assert.assertEquals((long)1L, (long)compacts.size());
            Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
            Assert.assertEquals((Object)"mcottma", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
            Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
        }
    }

    @Test
    public void majorCompactOnPartitionTooManyAborts() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        Table t = this.newTable("default", "mcoptma", true);
        Partition p = this.newPartition(t, "today");
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("mcoptma");
            comp.setPartitionname("ds=today");
            comp.setOperationType(DataOperationType.DELETE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        if (useCleanerForAbortCleanup) {
            Assert.assertEquals((long)0L, (long)compacts.size());
        } else {
            Assert.assertEquals((long)1L, (long)compacts.size());
            Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
            Assert.assertEquals((Object)"mcoptma", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
            Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
            Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
        }
    }

    @Test
    public void noCompactOnManyDifferentPartitionAborts() throws Exception {
        int i;
        Table t = this.newTable("default", "ncomdpa", true);
        for (i = 0; i < 11; ++i) {
            Partition partition = this.newPartition(t, "day-" + i);
        }
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncomdpa");
            comp.setPartitionname("ds=day-" + i);
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void compactExpiredAbortedTxns() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        Table t = this.newTable("default", "expiredAbortedTxns", false);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setOperationType(DataOperationType.DELETE);
        comp.setTablename("expiredAbortedTxns");
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        this.txnHandler.lock(req);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        this.initiateAndVerifyCompactionQueueLength(0);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, -1L, TimeUnit.MILLISECONDS);
        Thread.sleep(1L);
        this.initiateAndVerifyCompactionQueueLength(0);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_TIME_THRESHOLD, 1L, TimeUnit.MILLISECONDS);
        Thread.sleep(1L);
        if (useCleanerForAbortCleanup) {
            this.initiateAndVerifyCompactionQueueLength(0);
        } else {
            ShowCompactResponse rsp = this.initiateAndVerifyCompactionQueueLength(1);
            Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getType());
        }
    }

    private ShowCompactResponse initiateAndVerifyCompactionQueueLength(int expectedLength) throws Exception {
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)expectedLength, (long)rsp.getCompactsSize());
        return rsp;
    }

    @Test
    public void noCompactWhenNoCompactSet() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("NO_AUTO_COMPACTION", "true");
        Table t = this.newTable("default", "ncwncs", false, parameters);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwncs");
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void noCompactWhenNoCompactSetLowerCase() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("no_auto_compaction", "true");
        Table t = this.newTable("default", "ncwncs", false, parameters);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setOperationType(DataOperationType.DELETE);
            comp.setTablename("ncwncs");
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void noCompactWhenCompactAlreadyScheduled() throws Exception {
        Table t = this.newTable("default", "ncwcas", false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)10);
        for (int i = 0; i < 11; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncwcas");
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        CompactionRequest rqst = new CompactionRequest("default", "ncwcas", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ncwcas", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        this.startInitiator();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ncwcas", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactTableHighDeltaPct() throws Exception {
        Table t = this.newTable("default", "cthdp", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "cthdp", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cthdp");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "cthdp", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cthdp", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactPartitionHighDeltaPct() throws Exception {
        Table t = this.newTable("default", "cphdp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "cphdp", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("cphdp");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "cphdp", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cphdp", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactCamelCasePartitionValue() throws Exception {
        Table t = this.newTable("default", "test_table", true);
        Partition p = this.newPartition(t, "ToDay");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "test_table", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("test_table");
        comp.setPartitionname("dS=ToDay");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "test_table", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"test_table", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=ToDay", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableDeltaPctNotHighEnough() throws Exception {
        Table t = this.newTable("default", "nctdpnhe", false);
        this.addBaseFile(t, null, 50L, 50);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "nctdpnhe", 53);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctdpnhe");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "nctdpnhe", txnid);
        Assert.assertEquals((long)54L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void compactTableTooManyDeltas() throws Exception {
        Table t = this.newTable("default", "cttmd", false);
        this.addBaseFile(t, null, 200L, 200);
        this.addDeltaFile(t, null, 201L, 201L, 1);
        this.addDeltaFile(t, null, 202L, 202L, 1);
        this.addDeltaFile(t, null, 203L, 203L, 1);
        this.addDeltaFile(t, null, 204L, 204L, 1);
        this.addDeltaFile(t, null, 205L, 205L, 1);
        this.addDeltaFile(t, null, 206L, 206L, 1);
        this.addDeltaFile(t, null, 207L, 207L, 1);
        this.addDeltaFile(t, null, 208L, 208L, 1);
        this.addDeltaFile(t, null, 209L, 209L, 1);
        this.addDeltaFile(t, null, 210L, 210L, 1);
        this.addDeltaFile(t, null, 211L, 211L, 1);
        this.burnThroughTransactions("default", "cttmd", 210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cttmd");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "cttmd", txnid);
        Assert.assertEquals((long)211L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cttmd", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void compactPartitionTooManyDeltas() throws Exception {
        Table t = this.newTable("default", "cptmd", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 200L, 200);
        this.addDeltaFile(t, p, 201L, 201L, 1);
        this.addDeltaFile(t, p, 202L, 202L, 1);
        this.addDeltaFile(t, p, 203L, 203L, 1);
        this.addDeltaFile(t, p, 204L, 204L, 1);
        this.addDeltaFile(t, p, 205L, 205L, 1);
        this.addDeltaFile(t, p, 206L, 206L, 1);
        this.addDeltaFile(t, p, 207L, 207L, 1);
        this.addDeltaFile(t, p, 208L, 208L, 1);
        this.addDeltaFile(t, p, 209L, 209L, 1);
        this.addDeltaFile(t, p, 210L, 210L, 1);
        this.addDeltaFile(t, p, 211L, 211L, 1);
        this.burnThroughTransactions("default", "cptmd", 210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("cptmd");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "cptmd", txnid);
        Assert.assertEquals((long)211L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cptmd", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableNotEnoughDeltas() throws Exception {
        Table t = this.newTable("default", "nctned", false);
        this.addBaseFile(t, null, 200L, 200);
        this.addDeltaFile(t, null, 201L, 205L, 5);
        this.addDeltaFile(t, null, 206L, 211L, 6);
        this.burnThroughTransactions("default", "nctned", 210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctned");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "nctned", txnid);
        Assert.assertEquals((long)211L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void chooseMajorOverMinorWhenBothValid() throws Exception {
        Table t = this.newTable("default", "cmomwbv", false);
        this.addBaseFile(t, null, 200L, 200);
        this.addDeltaFile(t, null, 201L, 211L, 11);
        this.addDeltaFile(t, null, 212L, 222L, 11);
        this.addDeltaFile(t, null, 223L, 233L, 11);
        this.addDeltaFile(t, null, 234L, 244L, 11);
        this.addDeltaFile(t, null, 245L, 255L, 11);
        this.addDeltaFile(t, null, 256L, 266L, 11);
        this.addDeltaFile(t, null, 267L, 277L, 11);
        this.addDeltaFile(t, null, 278L, 288L, 11);
        this.addDeltaFile(t, null, 289L, 299L, 11);
        this.addDeltaFile(t, null, 300L, 310L, 11);
        this.addDeltaFile(t, null, 311L, 321L, 11);
        this.burnThroughTransactions("default", "cmomwbv", 320);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("cmomwbv");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "cmomwbv", txnid);
        Assert.assertEquals((long)321L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"cmomwbv", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void enoughDeltasNoBase() throws Exception {
        Table t = this.newTable("default", "ednb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 201L, 200);
        this.addDeltaFile(t, p, 202L, 202L, 1);
        this.addDeltaFile(t, p, 203L, 203L, 1);
        this.addDeltaFile(t, p, 204L, 204L, 1);
        this.addDeltaFile(t, p, 205L, 205L, 1);
        this.addDeltaFile(t, p, 206L, 206L, 1);
        this.addDeltaFile(t, p, 207L, 207L, 1);
        this.addDeltaFile(t, p, 208L, 208L, 1);
        this.addDeltaFile(t, p, 209L, 209L, 1);
        this.addDeltaFile(t, p, 210L, 210L, 1);
        this.addDeltaFile(t, p, 211L, 211L, 1);
        this.burnThroughTransactions("default", "ednb", 210);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ednb");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.DELETE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "ednb", txnid);
        Assert.assertEquals((long)211L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ednb", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void twoTxnsOnSamePartitionGenerateOneCompactionRequest() throws Exception {
        Table t = this.newTable("default", "ttospgocr", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "ttospgocr", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ttospgocr");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "ttospgocr", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        txnid = this.openTxn();
        comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("ttospgocr");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.UPDATE);
        components = new ArrayList(1);
        components.add(comp);
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        res = this.txnHandler.lock(req);
        writeid = this.allocateWriteId("default", "ttospgocr", txnid);
        Assert.assertEquals((long)25L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)1L, (long)compacts.size());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
        Assert.assertEquals((Object)"ttospgocr", (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        Assert.assertEquals((Object)"ds=today", (Object)((ShowCompactResponseElement)compacts.get(0)).getPartitionname());
        Assert.assertEquals((Object)CompactionType.MAJOR, (Object)((ShowCompactResponseElement)compacts.get(0)).getType());
    }

    @Test
    public void noCompactTableDynamicPartitioning() throws Exception {
        Table t = this.newTable("default", "nctdp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "nctdp", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctdp");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "nctdp", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void dropTable() throws Exception {
        Table t = this.newTable("default", "dt", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "dt", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("dt");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "dt", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.ms.dropTable("default", "dt");
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void dropPartition() throws Exception {
        Table t = this.newTable("default", "dp", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "dp", 23);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
        comp.setTablename("dp");
        comp.setPartitionname("ds=today");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "dp", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.ms.dropPartition("default", "dp", Collections.singletonList("today"), true);
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)0L, (long)compacts.size());
    }

    @Test
    public void processCompactionCandidatesInParallel() throws Exception {
        Table t = this.newTable("default", "dp", true);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        for (int i = 0; i < 10; ++i) {
            Partition p = this.newPartition(t, "part" + (i + 1));
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
            comp.setTablename("dp");
            comp.setPartitionname("ds=part" + (i + 1));
            comp.setOperationType(DataOperationType.UPDATE);
            components.add(comp);
        }
        this.burnThroughTransactions("default", "dp", 23);
        long txnid = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        long writeid = this.allocateWriteId("default", "dp", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_REQUEST_QUEUE, 3);
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)10L, (long)compacts.size());
    }

    @Test
    public void compactTableWithMultipleBase() throws Exception {
        Table t = this.newTable("default", "nctdpnhe", false);
        this.addBaseFile(t, null, 50L, 50);
        this.addBaseFile(t, null, 100L, 50);
        this.burnThroughTransactions("default", "nctdpnhe", 102);
        long txnid = this.openTxn();
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
        comp.setTablename("nctdpnhe");
        comp.setOperationType(DataOperationType.UPDATE);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
        components.add(comp);
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        long writeid = this.allocateWriteId("default", "nctdpnhe", txnid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        this.startWorker();
        Thread.sleep(1L);
        ShowCompactResponse response = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)response.getCompacts().get(0)).getState());
    }

    @Test
    public void testFindUserToRunAs() throws Exception {
        Table t = this.newTable("default", "tfutra", false);
        Initiator initiator = new Initiator();
        initiator.setConf((Configuration)this.conf);
        String userFromConf = "randomUser123";
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_RUN_AS_USER, (String)userFromConf);
        initiator.setConf((Configuration)this.conf);
        Assert.assertEquals((Object)userFromConf, (Object)TxnUtils.findUserToRunAs((String)t.getSd().getLocation(), (Table)t, (Configuration)this.conf));
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_RUN_AS_USER, (String)"");
        initiator.setConf((Configuration)this.conf);
        Assert.assertNotEquals((Object)userFromConf, (Object)TxnUtils.findUserToRunAs((String)t.getSd().getLocation(), (Table)t, (Configuration)this.conf));
    }

    @Test
    public void resolveUserToRunAs() throws Exception {
        Table t = this.newTable("default", "tfutra", false);
        HashMap tblNameOwners = new HashMap();
        Initiator initiator = new Initiator();
        String userFromConf = "randomUser123";
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_RUN_AS_USER, (String)userFromConf);
        initiator.setConf((Configuration)this.conf);
        Assert.assertEquals((Object)userFromConf, (Object)initiator.resolveUserToRunAs(tblNameOwners, t, null));
        tblNameOwners = new HashMap();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_RUN_AS_USER, (String)"");
        initiator.setConf((Configuration)this.conf);
        Assert.assertNotEquals((Object)userFromConf, (Object)initiator.resolveUserToRunAs(tblNameOwners, t, null));
        Assert.assertNotEquals((Object)userFromConf, (Object)initiator.resolveUserToRunAs(tblNameOwners, t, null));
    }

    @Test
    public void testInitiatorFailure() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        String tableName = "my_table";
        Table t = this.newTable("default", tableName, false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)1);
        for (int i = 0; i < 2; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename(tableName);
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        Initiator initiator = (Initiator)Mockito.spy((Object)new Initiator());
        initiator.setConf((Configuration)this.conf);
        initiator.init(new AtomicBoolean(true));
        ((Initiator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("This was thrown on purpose by testInitiatorFailure")}).when((Object)initiator)).resolveTable((CompactionInfo)ArgumentMatchers.any());
        initiator.run();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        if (useCleanerForAbortCleanup) {
            Assert.assertEquals((long)0L, (long)compacts.size());
        } else {
            Assert.assertEquals((long)1L, (long)compacts.size());
            Assert.assertEquals((Object)"did not initiate", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
            Assert.assertEquals((Object)tableName, (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
        }
    }

    @Test
    public void noCompactForInsertOnly() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("transactional_properties", "insert_only");
        this.newTable("default", "ncfio", false, parameters);
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM, (boolean)false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)1);
        for (int i = 0; i < 2; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename("ncfio");
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void testInitiatorHostAndVersion() throws Exception {
        boolean useCleanerForAbortCleanup = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER);
        String tableName = "my_table";
        Table t = this.newTable("default", tableName, false);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_ABORTEDTXN_THRESHOLD, (int)1);
        for (int i = 0; i < 2; ++i) {
            long txnid = this.openTxn();
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "default");
            comp.setTablename(tableName);
            comp.setOperationType(DataOperationType.UPDATE);
            ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
            components.add(comp);
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            this.txnHandler.lock(req);
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        Initiator initiator = (Initiator)Mockito.spy((Object)new Initiator());
        initiator.setConf((Configuration)this.conf);
        String runtimeVersion = WORKER_VERSION;
        ((Initiator)Mockito.doReturn((Object)runtimeVersion).when((Object)initiator)).getRuntimeVersion();
        initiator.init(new AtomicBoolean(true));
        initiator.run();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        if (useCleanerForAbortCleanup) {
            Assert.assertEquals((long)0L, (long)compacts.size());
        } else {
            Assert.assertEquals((long)1L, (long)compacts.size());
            Assert.assertEquals((Object)"initiated", (Object)((ShowCompactResponseElement)compacts.get(0)).getState());
            Assert.assertEquals((Object)tableName, (Object)((ShowCompactResponseElement)compacts.get(0)).getTablename());
            Assert.assertEquals((Object)runtimeVersion, (Object)((ShowCompactResponseElement)compacts.get(0)).getInitiatorVersion());
            String[] parts = ((ShowCompactResponseElement)compacts.get(0)).getInitiatorId().split("-");
            Assert.assertTrue((parts.length > 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)ServerUtils.hostname(), (Object)String.join((CharSequence)"-", Arrays.copyOfRange(parts, 0, parts.length - 1)));
        }
    }

    @Test
    public void testMetaCache() throws Exception {
        String dbname = "default";
        String tableName = "tmc";
        Table t = this.newTable(dbname, tableName, true);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        for (int i = 0; i < 2; ++i) {
            Partition p = this.newPartition(t, "part" + (i + 1));
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, dbname);
            comp.setTablename(tableName);
            comp.setPartitionname("ds=part" + (i + 1));
            comp.setOperationType(DataOperationType.UPDATE);
            components.add(comp);
        }
        this.burnThroughTransactions(dbname, tableName, 23);
        long txnid = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        long writeid = this.allocateWriteId(dbname, tableName, txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_REQUEST_QUEUE, 3);
        Initiator initiator = (Initiator)Mockito.spy((Object)new Initiator());
        initiator.setConf((Configuration)this.conf);
        initiator.init(new AtomicBoolean(true));
        initiator.run();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)2L, (long)compacts.size());
        ((Initiator)Mockito.verify((Object)initiator, (VerificationMode)Mockito.times((int)1))).resolveTable((CompactionInfo)Mockito.any());
    }

    private static FindNextCompactRequest aFindNextCompactRequest(String workerId, String workerVersion) {
        FindNextCompactRequest request = new FindNextCompactRequest();
        request.setWorkerId(workerId);
        request.setWorkerVersion(workerVersion);
        return request;
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @After
    public void tearDown() throws Exception {
        this.compactorTestCleanup();
    }
}

