/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.AcidMetricService;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDeltaFilesMetrics
extends CompactorTest {
    private static AcidMetricService metricService;

    private void setUpHiveConf() {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_DELTAMETRICS_DELTA_NUM_THRESHOLD, (long)1L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_DELTAMETRICS_OBSOLETE_DELTA_NUM_THRESHOLD, (long)1L);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_CHECK_INTERVAL, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_DELTAMETRICS_DELTA_PCT_THRESHOLD, (double)0.15f);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_GATHER_STATS, (boolean)false);
    }

    @Override
    @Before
    public synchronized void setup() throws Exception {
        this.conf = new HiveConf();
        this.setUpHiveConf();
        this.setup(this.conf);
        MetricsFactory.init((Configuration)this.conf);
        if (metricService == null) {
            metricService = new AcidMetricService();
            metricService.setConf((Configuration)this.conf);
        }
    }

    @After
    public void tearDown() throws Exception {
        MetricsFactory.close();
        this.compactorTestCleanup();
    }

    private static void verifyDeltaMetricsMatch(Map<String, Integer> expected, String metricName) throws Exception {
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch(expected, TestDeltaFilesMetrics.gaugeToMap(metricName), Metrics.getOrCreateMapMetrics((String)metricName).get());
    }

    private static void verifyDeltaMetricsMatch(Map<String, Integer> expected, Map<String, Integer> actualMBeanMetric, Map<String, Integer> actualMapMetric) {
        MatcherAssert.assertThat((String)("Actual mBean metrics " + actualMBeanMetric + " don't match expected: " + expected), actualMapMetric, (Matcher)CoreMatchers.is(expected));
        MatcherAssert.assertThat((String)("Actual map metrics " + actualMapMetric + " don't match expected: " + expected), actualMapMetric, (Matcher)CoreMatchers.is(expected));
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @Test
    public void testDeltaFileMetricPartitionedTable() throws Exception {
        String dbName = "default";
        String tblName = "dp";
        String partName = "ds=part1";
        Table t = this.newTable(dbName, tblName, true);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        Partition p = this.newPartition(t, "part1");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 20);
        components.add(this.createLockComponent(dbName, tblName, partName));
        this.burnThroughTransactions(dbName, tblName, 23);
        long txnId = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        long writeId = this.allocateWriteId(dbName, tblName, txnId);
        Assert.assertEquals((long)24L, (long)writeId);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        this.startInitiator();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)2), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)1), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        this.startWorker();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)2), "compaction_num_obsolete_deltas");
        this.addDeltaFile(t, p, 25L, 26L, 2);
        this.addDeltaFile(t, p, 27L, 28L, 20);
        this.addDeltaFile(t, p, 29L, 30L, 2);
        this.burnThroughTransactions(dbName, tblName, 30);
        txnId = this.openTxn();
        req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        writeId = this.allocateWriteId(dbName, tblName, txnId);
        Assert.assertEquals((long)55L, (long)writeId);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        HiveConf.setFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_PCT_THRESHOLD, (float)1.8f);
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_NUM_THRESHOLD, (int)2);
        this.startInitiator();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)3), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)2), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)2), "compaction_num_obsolete_deltas");
        this.startCleaner();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)3), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)2), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        this.startWorker();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)1), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)3), "compaction_num_obsolete_deltas");
        this.startCleaner();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + partName), (Object)1), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        this.ms.dropTable(dbName, tblName);
    }

    @Test
    public void testDeltaFileMetricMultiPartitionedTable() throws Exception {
        String dbName = "default";
        String tblName = "dp";
        String part1Name = "ds=part1";
        String part2Name = "ds=part2";
        String part3Name = "ds=part3";
        Table t = this.newTable(dbName, tblName, true);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        Partition p1 = this.newPartition(t, "part1");
        this.addDeltaFile(t, p1, 1L, 2L, 2);
        this.addDeltaFile(t, p1, 3L, 4L, 4);
        Partition p2 = this.newPartition(t, "part2");
        this.addBaseFile(t, p2, 5L, 20);
        this.addDeltaFile(t, p2, 6L, 7L, 2);
        this.addDeltaFile(t, p2, 8L, 9L, 3);
        this.addDeltaFile(t, p2, 10L, 11L, 1);
        Partition p3 = this.newPartition(t, "part3");
        this.addDeltaFile(t, p3, 12L, 13L, 3);
        this.addDeltaFile(t, p3, 14L, 15L, 20);
        this.addDeltaFile(t, p3, 16L, 17L, 50);
        this.addDeltaFile(t, p3, 18L, 19L, 2);
        components.add(this.createLockComponent(dbName, tblName, part1Name));
        components.add(this.createLockComponent(dbName, tblName, part2Name));
        components.add(this.createLockComponent(dbName, tblName, part3Name));
        this.burnThroughTransactions(dbName, tblName, 19);
        long txnId = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        this.allocateWriteId(dbName, tblName, txnId);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        HiveConf.setIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_NUM_THRESHOLD, (int)2);
        HiveConf.setFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELTA_PCT_THRESHOLD, (float)0.4f);
        this.startInitiator();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + part1Name), (Object)2, (Object)(dbName + "." + tblName + "/" + part2Name), (Object)3, (Object)(dbName + "." + tblName + "/" + part3Name), (Object)4), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + part2Name), (Object)2), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        ShowCompactResponse showCompactResponse = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = showCompactResponse.getCompacts();
        Assert.assertEquals((long)2L, (long)compacts.size());
        this.startWorker();
        this.startWorker();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + part1Name), (Object)2, (Object)(dbName + "." + tblName + "/" + part2Name), (Object)1), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + part2Name), (Object)3, (Object)(dbName + "." + tblName + "/" + part3Name), (Object)4), "compaction_num_obsolete_deltas");
        this.startCleaner();
        this.startCleaner();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName + "/" + part1Name), (Object)2, (Object)(dbName + "." + tblName + "/" + part2Name), (Object)1), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        this.ms.dropTable(dbName, tblName);
    }

    @Test
    public void testDeltaFileMetricUnpartitionedTable() throws Exception {
        String dbName = "default";
        String tblName = "dp";
        Table t = this.newTable(dbName, tblName, false);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 20);
        components.add(this.createLockComponent(dbName, tblName, null));
        this.burnThroughTransactions(dbName, tblName, 24);
        long txnId = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        long writeId = this.allocateWriteId(dbName, tblName, txnId);
        Assert.assertEquals((long)25L, (long)writeId);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        this.startInitiator();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName), (Object)2), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName), (Object)1), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        this.startWorker();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of((Object)(dbName + "." + tblName), (Object)2), "compaction_num_obsolete_deltas");
        this.startCleaner();
        metricService.run();
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_active_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_small_deltas");
        TestDeltaFilesMetrics.verifyDeltaMetricsMatch((Map<String, Integer>)ImmutableMap.of(), "compaction_num_obsolete_deltas");
        this.ms.dropTable(dbName, tblName);
    }

    private LockComponent createLockComponent(String dbName, String tblName, String partName) {
        LockComponent component = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, dbName);
        component.setTablename(tblName);
        if (partName != null) {
            component.setPartitionname(partName);
        }
        component.setOperationType(DataOperationType.UPDATE);
        return component;
    }
}

