/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.ImmutableMap;
import javax.management.InstanceNotFoundException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestDeltaFilesMetricFlags
extends CompactorTest {
    @Override
    public void setup() throws Exception {
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @Test(expected=InstanceNotFoundException.class)
    public void testDeltaFilesMetricFromInitiatorWithMetricsDisabled() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolean(MetastoreConf.ConfVars.METRICS_ENABLED.getVarname(), false);
        this.setup(this.conf);
        this.startInitiator();
        MatcherAssert.assertThat((Object)Metrics.getOrCreateMapMetrics((String)"compaction_num_active_deltas").get(), (Matcher)CoreMatchers.is((Object)ImmutableMap.of()));
        TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_active_deltas");
    }

    @Test(expected=InstanceNotFoundException.class)
    public void testDeltaFilesMetricFromWorkerWithMetricsDisabled() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolean(MetastoreConf.ConfVars.METRICS_ENABLED.getVarname(), false);
        this.setup(this.conf);
        this.startWorker();
        MatcherAssert.assertThat(TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_small_deltas"), (Matcher)CoreMatchers.is((Object)ImmutableMap.of()));
        TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_small_deltas");
    }

    @Test(expected=InstanceNotFoundException.class)
    public void testDeltaFilesMetricFromCleanerWithMetricsDisabled() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolean(MetastoreConf.ConfVars.METRICS_ENABLED.getVarname(), false);
        this.setup(this.conf);
        this.startCleaner();
        MatcherAssert.assertThat(TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_obsolete_deltas"), (Matcher)CoreMatchers.is((Object)ImmutableMap.of()));
        TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_obsolete_deltas");
    }

    @Test(expected=InstanceNotFoundException.class)
    public void testDeltaFilesMetricFromInitiatorWithAcidMetricsThreadDisabled() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolean(MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_THREAD_ON.getVarname(), false);
        this.setup(this.conf);
        this.startInitiator();
        MatcherAssert.assertThat(TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_active_deltas"), (Matcher)CoreMatchers.is((Object)ImmutableMap.of()));
        TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_active_deltas");
    }

    @Test(expected=InstanceNotFoundException.class)
    public void testDeltaFilesMetricFromWorkerWithAcidMetricsThreadDisabled() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolean(MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_THREAD_ON.getVarname(), false);
        this.setup(this.conf);
        this.startWorker();
        MatcherAssert.assertThat(TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_small_deltas"), (Matcher)CoreMatchers.is((Object)ImmutableMap.of()));
        TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_small_deltas");
    }

    @Test(expected=InstanceNotFoundException.class)
    public void testDeltaFilesMetricFromCleanerWithAcidMetricsThreadDisabled() throws Exception {
        this.conf = new HiveConf();
        this.conf.setBoolean(MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_THREAD_ON.getVarname(), false);
        this.setup(this.conf);
        this.startCleaner();
        MatcherAssert.assertThat(TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_obsolete_deltas"), (Matcher)CoreMatchers.is((Object)ImmutableMap.of()));
        TestDeltaFilesMetricFlags.gaugeToMap("compaction_num_obsolete_deltas");
    }
}

