/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderTestBase;
import org.junit.Assert;
import org.junit.Test;

public class TestCompactionQueryBuilderForMmCompaction
extends CompactionQueryBuilderTestBase {
    @Test
    public void testMajorCompactionCreateWithoutSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreateWithTablePropertiesWithLocation() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableWithProperties();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  LOCATION 'some_test_path' TBLPROPERTIES ('property_1'='true', 'orc.property_2'='44', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreatePartitioned() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setPartitioned(true);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  PARTITIONED BY (`file_name` STRING)  LOCATION 'some_test_path' TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreateWithBucketedSourceTable() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableBucketed();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean) CLUSTERED BY (column_1,column_3) INTO 4 BUCKETS TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreateWithBucketedSortedSourceTable() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableBucketedSorted();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean) CLUSTERED BY (column_1,column_3) SORTED BY (column_1 DESC, column_2 ASC) INTO 4 BUCKETS TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreateWithStorageDescriptor() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        StorageDescriptor storageDescriptor = this.createStorageDescriptor();
        queryBuilder.setStorageDescriptor(storageDescriptor);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  ROW FORMAT SERDE '/some/test/serialization_lib'WITH SERDEPROPERTIES ( \n  'test_param_1'='test_value', \n  'test_param_2'='test_value')STORED AS INPUTFORMAT 'some.test.InputFormat' OUTPUTFORMAT 'some.test.OutputFormat' TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreateWithSkewedByClause() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        StorageDescriptor storageDescriptor = sourceTable.getSd();
        SkewedInfo skewedInfo = new SkewedInfo();
        skewedInfo.addToSkewedColNames("column_1");
        ArrayList<String> skewedColValues = new ArrayList<String>();
        skewedColValues.add("value1");
        skewedColValues.add("value2");
        skewedColValues.add("value3");
        skewedInfo.addToSkewedColValues(skewedColValues);
        storageDescriptor.setSkewedInfo(skewedInfo);
        storageDescriptor.setStoredAsSubDirectories(true);
        sourceTable.setSd(storageDescriptor);
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  SKEWED BY (column_1) ON ('value1','value2','value3')) STORED AS DIRECTORIES TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMajorCompactionCreateWithNonNativeTable() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("storage_handler", "test_storage_handler");
        sourceTable.setParameters(parameters);
        queryBuilder.setSourceTab(sourceTable);
        StorageDescriptor storageDescriptor = this.createStorageDescriptor();
        queryBuilder.setStorageDescriptor(storageDescriptor);
        String expectedMessage = "Table comp_test_source_table has a storage handler (test_storage_handler). Failing compaction for this non-native table.";
        Assert.assertThrows((String)expectedMessage, RuntimeException.class, () -> ((CompactionQueryBuilder)queryBuilder).build());
    }

    @Test
    public void testMinorCompactionCreateWithoutSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreateWithTablePropertiesWithLocation() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableWithProperties();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  LOCATION 'some_test_path' TBLPROPERTIES ('property_1'='true', 'orc.property_2'='44', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreatePartitioned() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setPartitioned(true);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  PARTITIONED BY (`file_name` STRING)  LOCATION 'some_test_path' TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreateWithBucketedSourceTable() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableBucketed();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean) CLUSTERED BY (column_1,column_3) INTO 4 BUCKETS TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreateWithBucketedSortedSourceTable() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableBucketedSorted();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean) CLUSTERED BY (column_1,column_3) SORTED BY (column_1 DESC, column_2 ASC) INTO 4 BUCKETS TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreateWithStorageDescriptor() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        StorageDescriptor storageDescriptor = this.createStorageDescriptor();
        queryBuilder.setStorageDescriptor(storageDescriptor);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  ROW FORMAT SERDE '/some/test/serialization_lib'WITH SERDEPROPERTIES ( \n  'test_param_1'='test_value', \n  'test_param_2'='test_value')STORED AS INPUTFORMAT 'some.test.InputFormat' OUTPUTFORMAT 'some.test.OutputFormat' TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreateWithSkewedByClause() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        StorageDescriptor storageDescriptor = sourceTable.getSd();
        SkewedInfo skewedInfo = new SkewedInfo();
        skewedInfo.addToSkewedColNames("column_1");
        ArrayList<String> skewedColValues = new ArrayList<String>();
        skewedColValues.add("value1");
        skewedColValues.add("value2");
        skewedColValues.add("value3");
        skewedInfo.addToSkewedColValues(skewedColValues);
        storageDescriptor.setSkewedInfo(skewedInfo);
        storageDescriptor.setStoredAsSubDirectories(true);
        sourceTable.setSd(storageDescriptor);
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`column_1` string,`column_2` int,`column_3` boolean)  SKEWED BY (column_1) ON ('value1','value2','value3')) STORED AS DIRECTORIES TBLPROPERTIES ('transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testMinorCompactionCreateLWithNonNativeTable() throws HiveException {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("storage_handler", "test_storage_handler");
        sourceTable.setParameters(parameters);
        queryBuilder.setSourceTab(sourceTable);
        StorageDescriptor storageDescriptor = this.createStorageDescriptor();
        queryBuilder.setStorageDescriptor(storageDescriptor);
        String expectedMessage = "Table comp_test_source_tablehas a storage handler (test_storage_handler). Failing compaction for this non-native table.";
        Assert.assertThrows((String)expectedMessage, RuntimeException.class, () -> ((CompactionQueryBuilder)queryBuilder).build());
    }

    @Test
    public void testInsertMajorCompaction() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTableBucketedSorted();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        queryBuilder.setOrderByClause("ORDER BY column_1 ASC, column_2 DESC");
        Partition sourcePartition = new Partition();
        sourcePartition.addToValues("source_part_1");
        sourcePartition.addToValues("true");
        sourcePartition.addToValues("4444");
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_1", "string", "comment 1"));
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_2", "boolean", "comment 2"));
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_3", "int", "comment 3"));
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setSourcePartition(sourcePartition);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select `column_1`, `column_2`, `column_3` from comp_test_db.comp_test_insert_table ORDER BY column_1 ASC, column_2 DESC where `source_part_1`='source_part_1' and `source_part_2`=true and `source_part_3`='4444'";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertMajorCompactionPartitionMismatch() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        Partition sourcePartition = new Partition();
        sourcePartition.addToValues("source_part_1");
        sourcePartition.addToValues("true");
        sourcePartition.addToValues("4444");
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_1", "string", "comment 1"));
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_2", "boolean", "comment 2"));
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setSourcePartition(sourcePartition);
        String expectedMessage = "source partition values ([source_part_1, true, 4444]) do not match source table values ([FieldSchema(name:source_part_1, type:string, comment:comment 1), FieldSchema(name:source_part_2, type:boolean, comment:comment 2)]). Failing compaction.";
        Assert.assertThrows((String)expectedMessage, IllegalStateException.class, () -> ((CompactionQueryBuilder)queryBuilder).build());
    }

    @Test
    public void testInsertMajorCompactionNoSourceTabForInsert() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        Partition sourcePartition = new Partition();
        sourcePartition.addToValues("source_part_1");
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_1", "string", "comment 1"));
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setSourcePartition(sourcePartition);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select `column_1`, `column_2`, `column_3` from comp_test_db.comp_test_source_table  where `source_part_1`='source_part_1'";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertMajorCompactionOnlySourceTableSet() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select * from comp_test_db.comp_test_source_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertMajorCompactionNoSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForInsert();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select * from comp_test_db.comp_test_insert_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertMinorCompaction() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select `column_1`, `column_2`, `column_3` from comp_test_db.comp_test_insert_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertMinorCompactionWithoutSourceTableForInsert() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select `column_1`, `column_2`, `column_3` from comp_test_db.comp_test_source_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertMinorCompactionNoSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForInsert();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select  from comp_test_db.comp_test_insert_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testAlterMajorCompaction() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForAlter();
        AcidDirectory dir = this.createAcidDirectory();
        ValidCompactorWriteIdList writeIds = this.createWriteId(5L);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(dir);
        queryBuilder.setIsDeleteDelta(true);
        String query = queryBuilder.build();
        String expectedQuery = "ALTER table comp_test_result_table add partition (file_name='test_delta_1') location '/compaction/test/table/test_delta_1' partition (file_name='test_delta_3') location '/compaction/test/table/test_delta_3' ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testAlterMinorCompaction() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForAlter();
        AcidDirectory dir = this.createAcidDirectory();
        ValidCompactorWriteIdList writeIds = this.createWriteId(5L);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(dir);
        queryBuilder.setIsDeleteDelta(true);
        String query = queryBuilder.build();
        String expectedQuery = "ALTER table comp_test_result_table add partition (file_name='test_delta_1') location '/compaction/test/table/test_delta_1' partition (file_name='test_delta_3') location '/compaction/test/table/test_delta_3' ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testDropMajorCompaction() {
        CompactionQueryBuilder queryBuilder = this.getMmMajorCompactionQueryBuilderForDrop();
        String query = queryBuilder.build();
        String expectedQuery = "DROP table if exists comp_test_result_table";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testDropMinorCompaction() {
        CompactionQueryBuilder queryBuilder = this.getMmMinorCompactionQueryBuilderForDrop();
        String query = queryBuilder.build();
        String expectedQuery = "DROP table if exists comp_test_result_table";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    private StorageDescriptor createStorageDescriptor() {
        SerDeInfo serdeInfo = new SerDeInfo();
        serdeInfo.setSerializationLib("/some/test/serialization_lib");
        HashMap<String, String> serdeParams = new HashMap<String, String>();
        serdeParams.put("test_param_1", "test_value");
        serdeParams.put("test_param_2", "test_value");
        serdeInfo.setParameters(serdeParams);
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.setSerdeInfo(serdeInfo);
        storageDescriptor.setInputFormat("some.test.InputFormat");
        storageDescriptor.setOutputFormat("some.test.OutputFormat");
        return storageDescriptor;
    }

    private CompactionQueryBuilder getMmMajorCompactionQueryBuilderForCreate() {
        return this.getMmMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.CREATE);
    }

    private CompactionQueryBuilder getMmMajorCompactionQueryBuilderForInsert() {
        return this.getMmMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.INSERT);
    }

    private CompactionQueryBuilder getMmMajorCompactionQueryBuilderForAlter() {
        return this.getMmMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.ALTER);
    }

    private CompactionQueryBuilder getMmMajorCompactionQueryBuilderForDrop() {
        return this.getMmMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.DROP);
    }

    private CompactionQueryBuilder getMmMinorCompactionQueryBuilderForCreate() {
        return this.getMmMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.CREATE);
    }

    private CompactionQueryBuilder getMmMinorCompactionQueryBuilderForInsert() {
        return this.getMmMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.INSERT);
    }

    private CompactionQueryBuilder getMmMinorCompactionQueryBuilderForAlter() {
        return this.getMmMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.ALTER);
    }

    private CompactionQueryBuilder getMmMinorCompactionQueryBuilderForDrop() {
        return this.getMmMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.DROP);
    }

    private CompactionQueryBuilder getMmMajorCompactionBuilder() {
        CompactionQueryBuilder compactionQueryBuilder = new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, true);
        return compactionQueryBuilder.setResultTableName("comp_test_result_table");
    }

    private CompactionQueryBuilder getMmMinorCompactionBuilder() {
        CompactionQueryBuilder compactionQueryBuilder = new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, true);
        return compactionQueryBuilder.setResultTableName("comp_test_result_table");
    }
}

