/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderForMinor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCompactionQueryBuilderForMinorCompaction
extends CompactionQueryBuilderTestBase {
    @Test
    public void testCreateWithoutSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForCreate();
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table stored as orc TBLPROPERTIES ('compactiontable'='MINOR', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreateWithTablePropertiesWithLocation() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForCreate();
        org.apache.hadoop.hive.metastore.api.Table sourceTable = this.createSourceTableWithProperties();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  stored as orc LOCATION 'some_test_path' TBLPROPERTIES ('compactiontable'='MINOR', 'orc.property_2'='44', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreatePartitioned() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForCreate();
        org.apache.hadoop.hive.metastore.api.Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setPartitioned(true);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  PARTITIONED BY (`file_name` STRING)  stored as orc LOCATION 'some_test_path' TBLPROPERTIES ('compactiontable'='MINOR', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreateBucketed() {
        CompactionQueryBuilderForMinorMock queryBuilder = new CompactionQueryBuilderForMinorMock();
        queryBuilder.setOperation(CompactionQueryBuilder.Operation.CREATE);
        queryBuilder.setResultTableName("comp_test_result_table");
        org.apache.hadoop.hive.metastore.api.Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setBucketed(true);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  clustered by (`bucket`) sorted by (`originalTransaction`, `bucket`, `rowId`) into 4 buckets stored as orc TBLPROPERTIES ('compactiontable'='MINOR', 'bucketing_version'='2', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreateBucketedExceptionThrown() {
        CompactionQueryBuilderForMinorMock queryBuilder = new CompactionQueryBuilderForMinorMock();
        queryBuilder.setThrowException(true);
        queryBuilder.setOperation(CompactionQueryBuilder.Operation.CREATE);
        queryBuilder.setResultTableName("comp_test_result_table");
        org.apache.hadoop.hive.metastore.api.Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setBucketed(true);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  clustered by (`bucket`) sorted by (`originalTransaction`, `bucket`, `rowId`) into 1 buckets stored as orc TBLPROPERTIES ('compactiontable'='MINOR', 'bucketing_version'='0', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsert() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForInsert();
        org.apache.hadoop.hive.metastore.api.Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        long[] abortedWriteIdList = new long[]{1111L, 2222L};
        ValidCompactorWriteIdList writeIds = new ValidCompactorWriteIdList("comp_test_source_table", abortedWriteIdList, null, 111111L);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select `operation`, `originalTransaction`, `bucket`, `rowId`, `currentTransaction`, `row` from comp_test_db.comp_test_insert_table  where `originalTransaction` not in (1111,2222)";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertWithoutValidWriteIdsAndSourceTableForInsert() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForInsert();
        org.apache.hadoop.hive.metastore.api.Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select `operation`, `originalTransaction`, `bucket`, `rowId`, `currentTransaction`, `row` from comp_test_db.comp_test_source_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testAlter() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForAlter();
        AcidDirectory dir = this.createAcidDirectory();
        ValidCompactorWriteIdList writeIds = this.createWriteId(5L);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(dir);
        queryBuilder.setIsDeleteDelta(true);
        String query = queryBuilder.build();
        String expectedQuery = "ALTER table comp_test_result_table add partition (file_name='test_delta_1') location '/compaction/test/table/test_delta_1' partition (file_name='test_delta_3') location '/compaction/test/table/test_delta_3' ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testDrop() {
        CompactionQueryBuilder queryBuilder = this.getMinorCompactionQueryBuilderForDrop();
        String query = queryBuilder.build();
        String expectedQuery = "DROP table if exists comp_test_result_table";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    private CompactionQueryBuilder getMinorCompactionQueryBuilderForCreate() {
        return this.getMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.CREATE);
    }

    private CompactionQueryBuilder getMinorCompactionQueryBuilderForInsert() {
        return this.getMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.INSERT);
    }

    private CompactionQueryBuilder getMinorCompactionQueryBuilderForAlter() {
        return this.getMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.ALTER);
    }

    private CompactionQueryBuilder getMinorCompactionQueryBuilderForDrop() {
        return this.getMinorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.DROP);
    }

    private CompactionQueryBuilder getMinorCompactionBuilder() {
        CompactionQueryBuilder compactionQueryBuilder = new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MINOR, false);
        return compactionQueryBuilder.setResultTableName("comp_test_result_table");
    }

    static class CompactionQueryBuilderForMinorMock
    extends CompactionQueryBuilderForMinor {
        private boolean throwException = false;

        CompactionQueryBuilderForMinorMock() {
        }

        public void setThrowException(boolean throwException) {
            this.throwException = throwException;
        }

        public Table getTable() throws HiveException {
            Table t = (Table)Mockito.mock(Table.class);
            if (this.throwException) {
                throw new HiveException();
            }
            Mockito.when((Object)t.getBucketingVersion()).thenReturn((Object)2);
            Mockito.when((Object)t.getNumBuckets()).thenReturn((Object)4);
            return t;
        }
    }
}

