/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Collections;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCompactionQueryBuilderForMajorCompaction
extends CompactionQueryBuilderTestBase {
    @Test
    public void testCreateNoSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForCreate();
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table stored as orc TBLPROPERTIES ('compactiontable'='MAJOR', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreate() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  stored as orc TBLPROPERTIES ('compactiontable'='MAJOR', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreateWithSourceTableProperties() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTableWithProperties();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  stored as orc TBLPROPERTIES ('compactiontable'='MAJOR', 'orc.property_2'='44', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreateWithSourceTableLocation() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setLocation("some_test_path");
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  stored as orc LOCATION 'some_test_path' TBLPROPERTIES ('compactiontable'='MAJOR', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testCreateWithPartitionedSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForCreate();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setPartitioned(true);
        String query = queryBuilder.build();
        String expectedQuery = "CREATE temporary external table comp_test_result_table(`operation` int, `originalTransaction` bigint, `bucket` int, `rowId` bigint, `currentTransaction` bigint, `row` struct<`column_1` :string,`column_2` :int,`column_3` :boolean>)  PARTITIONED BY (`file_name` STRING)  stored as orc TBLPROPERTIES ('compactiontable'='MAJOR', 'transactional'='false')";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsert() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        Partition sourcePartition = new Partition();
        sourcePartition.addToValues("source_part_1");
        sourcePartition.addToValues("true");
        sourcePartition.addToValues("4444");
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_1", "string", "comment 1"));
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_2", "boolean", "comment 2"));
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_3", "int", "comment 3"));
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setSourcePartition(sourcePartition);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select validate_acid_sort_order(ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId), ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId, ROW__ID.writeId, NAMED_STRUCT('column_1', `column_1`, 'column_2', `column_2`, 'column_3', `column_3`)  from comp_test_db.comp_test_insert_table  where `source_part_1`='source_part_1' and `source_part_2`=true and `source_part_3`='4444'";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertPartitionMismatch() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        Partition sourcePartition = new Partition();
        sourcePartition.addToValues("source_part_1");
        sourcePartition.addToValues("true");
        sourcePartition.addToValues("4444");
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_1", "string", "comment 1"));
        sourceTable.addToPartitionKeys(new FieldSchema("source_part_2", "boolean", "comment 2"));
        queryBuilder.setSourceTab(sourceTable);
        queryBuilder.setSourcePartition(sourcePartition);
        String expectedMessage = "source partition values ([source_part_1, true, 4444]) do not match source table values ([FieldSchema(name:source_part_1, type:string, comment:comment 1), FieldSchema(name:source_part_2, type:boolean, comment:comment 2)]). Failing compaction.";
        Assert.assertThrows((String)expectedMessage, IllegalStateException.class, () -> ((CompactionQueryBuilder)queryBuilder).build());
    }

    @Test
    public void testInsertNoSourcePartition() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select validate_acid_sort_order(ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId), ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId, ROW__ID.writeId, NAMED_STRUCT('column_1', `column_1`, 'column_2', `column_2`, 'column_3', `column_3`)  from comp_test_db.comp_test_insert_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertNoSourceTableForInsert() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForInsert();
        Table sourceTable = this.createSourceTable();
        queryBuilder.setSourceTab(sourceTable);
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select validate_acid_sort_order(ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId), ROW__ID.writeId, ROW__ID.bucketId, ROW__ID.rowId, ROW__ID.writeId, NAMED_STRUCT('column_1', `column_1`, 'column_2', `column_2`, 'column_3', `column_3`)  from comp_test_db.comp_test_source_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testInsertNoSourceTable() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForInsert();
        queryBuilder.setSourceTabForInsert("comp_test_db.comp_test_insert_table");
        String query = queryBuilder.build();
        String expectedQuery = "INSERT into table comp_test_result_table select  from comp_test_db.comp_test_insert_table ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testAlter() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForAlter();
        AcidDirectory dir = this.createAcidDirectory();
        ValidCompactorWriteIdList writeIds = this.createWriteId(5L);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(dir);
        queryBuilder.setIsDeleteDelta(true);
        String query = queryBuilder.build();
        String expectedQuery = "ALTER table comp_test_result_table add partition (file_name='test_delta_1') location '/compaction/test/table/test_delta_1' partition (file_name='test_delta_3') location '/compaction/test/table/test_delta_3' ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testAlterEmptyDir() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForAlter();
        AcidDirectory dir = (AcidDirectory)Mockito.mock(AcidDirectory.class);
        Mockito.when((Object)dir.getCurrentDirectories()).thenReturn(Collections.emptyList());
        ValidCompactorWriteIdList writeIds = this.createWriteId(5L);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(dir);
        queryBuilder.setIsDeleteDelta(true);
        String query = queryBuilder.build();
        Assert.assertTrue((boolean)query.isEmpty());
    }

    @Test
    public void testAlterMinWriteIdIsNull() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForAlter();
        AcidDirectory dir = this.createAcidDirectory();
        ValidCompactorWriteIdList writeIds = this.createWriteId(Long.MAX_VALUE);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(dir);
        String query = queryBuilder.build();
        String expectedQuery = "ALTER table comp_test_result_table add partition (file_name='test_delta_5') location '/compaction/test/table/test_delta_5' ";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    @Test
    public void testAlterDirIsNull() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForAlter();
        ValidCompactorWriteIdList writeIds = this.createWriteId(Long.MAX_VALUE);
        queryBuilder.setValidWriteIdList((ValidWriteIdList)writeIds);
        queryBuilder.setDir(null);
        String query = queryBuilder.build();
        Assert.assertTrue((boolean)query.isEmpty());
    }

    @Test
    public void testAlterWalidWriteIdListIsNull() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForAlter();
        AcidDirectory dir = this.createAcidDirectory();
        queryBuilder.setValidWriteIdList(null);
        queryBuilder.setDir(dir);
        String query = queryBuilder.build();
        Assert.assertTrue((boolean)query.isEmpty());
    }

    @Test
    public void testDrop() {
        CompactionQueryBuilder queryBuilder = this.getMajorCompactionQueryBuilderForDrop();
        String query = queryBuilder.build();
        String expectedQuery = "DROP table if exists comp_test_result_table";
        Assert.assertEquals((Object)expectedQuery, (Object)query);
    }

    private CompactionQueryBuilder getMajorCompactionQueryBuilderForCreate() {
        return this.getMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.CREATE);
    }

    private CompactionQueryBuilder getMajorCompactionQueryBuilderForInsert() {
        return this.getMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.INSERT);
    }

    private CompactionQueryBuilder getMajorCompactionQueryBuilderForAlter() {
        return this.getMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.ALTER);
    }

    private CompactionQueryBuilder getMajorCompactionQueryBuilderForDrop() {
        return this.getMajorCompactionBuilder().setOperation(CompactionQueryBuilder.Operation.DROP);
    }

    private CompactionQueryBuilder getMajorCompactionBuilder() {
        CompactionQueryBuilder compactionQueryBuilder = new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, false);
        return compactionQueryBuilder.setResultTableName("comp_test_result_table");
    }
}

