/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.codahale.metrics.Counter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSMetricsListener;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.AcidMetricService;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.txn.ThrowingTxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompactionMetrics
extends CompactorTest {
    private static final String INITIATED_METRICS_KEY = "compaction_num_initiated";
    private static final String INITIATOR_CYCLE_KEY = "api_compaction_initiator_cycle";
    private static final String CLEANER_CYCLE_KEY = "api_compaction_cleaner_cycle";
    private static final String WORKER_CYCLE_KEY = "api_compaction_worker_cycle";

    @Before
    public void setUp() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_LEVEL, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON, (boolean)true);
        Metrics.shutdown();
        Metrics.initialize((Configuration)this.conf);
    }

    @Test
    public void testInitiatorPerfMetricsEnabled() throws Exception {
        Metrics.getOrCreateGauge((String)INITIATED_METRICS_KEY).set(0);
        long initiatorCycles = Objects.requireNonNull(Metrics.getOrCreateTimer((String)INITIATOR_CYCLE_KEY)).getCount();
        Table t = this.newTable("default", "ime", true);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        for (int i = 0; i < 10; ++i) {
            Partition p = this.newPartition(t, "part" + (i + 1));
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
            comp.setTablename("ime");
            comp.setPartitionname("ds=part" + (i + 1));
            comp.setOperationType(DataOperationType.UPDATE);
            components.add(comp);
        }
        this.burnThroughTransactions("default", "ime", 23);
        long txnid = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        long writeid = this.allocateWriteId("default", "ime", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)10L, (long)compacts.size());
        Assert.assertEquals((long)(initiatorCycles + 1L), (long)Objects.requireNonNull(Metrics.getOrCreateTimer((String)INITIATOR_CYCLE_KEY)).getCount());
        this.runAcidMetricService();
        Assert.assertEquals((long)10L, (long)Metrics.getOrCreateGauge((String)INITIATED_METRICS_KEY).intValue());
    }

    @Test
    public void testInitiatorPerfMetricsDisabled() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)false);
        Metrics.initialize((Configuration)this.conf);
        int originalValue = Metrics.getOrCreateGauge((String)INITIATED_METRICS_KEY).intValue();
        long initiatorCycles = Objects.requireNonNull(Metrics.getOrCreateTimer((String)INITIATOR_CYCLE_KEY)).getCount();
        Table t = this.newTable("default", "imd", true);
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        for (int i = 0; i < 10; ++i) {
            Partition p = this.newPartition(t, "part" + (i + 1));
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
            comp.setTablename("imd");
            comp.setPartitionname("ds=part" + (i + 1));
            comp.setOperationType(DataOperationType.UPDATE);
            components.add(comp);
        }
        this.burnThroughTransactions("default", "imd", 23);
        long txnid = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnid);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        long writeid = this.allocateWriteId("default", "imd", txnid);
        Assert.assertEquals((long)24L, (long)writeid);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        List compacts = rsp.getCompacts();
        Assert.assertEquals((long)10L, (long)compacts.size());
        Assert.assertEquals((long)initiatorCycles, (long)Objects.requireNonNull(Metrics.getOrCreateTimer((String)INITIATOR_CYCLE_KEY)).getCount());
        this.runAcidMetricService();
        Assert.assertEquals((long)originalValue, (long)Metrics.getOrCreateGauge((String)INITIATED_METRICS_KEY).intValue());
    }

    @Test
    public void testOldestReadyForCleaningAge() throws Exception {
        this.conf.setIntVar(HiveConf.ConfVars.COMPACTOR_MAX_NUM_DELTA, 1);
        String DB_NAME = "default";
        String OLD_TABLE_NAME = "old_rfc";
        String OLD_PARTITION_NAME = "part";
        String YOUNG_TABLE_NAME = "young_rfc";
        String YOUNG_PARTITION_NAME = "part";
        long oldTableStart = System.currentTimeMillis();
        Table old = this.newTable("default", "old_rfc", true);
        Partition oldP = this.newPartition(old, "part");
        this.addBaseFile(old, oldP, 20L, 20);
        this.addDeltaFile(old, oldP, 21L, 22L, 2);
        this.addDeltaFile(old, oldP, 23L, 24L, 2);
        this.burnThroughTransactions("default", "old_rfc", 25);
        this.doCompaction("default", "old_rfc", "part", CompactionType.MINOR);
        long oldTableEnd = System.currentTimeMillis();
        Table young = this.newTable("default", "young_rfc", true);
        Partition youngP = this.newPartition(young, "part");
        this.addBaseFile(young, youngP, 20L, 20);
        this.addDeltaFile(young, youngP, 21L, 22L, 2);
        this.addDeltaFile(young, youngP, 23L, 24L, 2);
        this.burnThroughTransactions("default", "young_rfc", 25);
        this.doCompaction("default", "young_rfc", "part", CompactionType.MINOR);
        long acidMetricsStart = System.currentTimeMillis();
        this.runAcidMetricService();
        long now = System.currentTimeMillis();
        long acidMetricsDuration = now - acidMetricsStart;
        int oldestAgeInSeconds = Metrics.getOrCreateGauge((String)"oldest_ready_for_cleaning_age_in_sec").intValue();
        long ageInMillies = (long)oldestAgeInSeconds * 1000L;
        long DB_ROUNDING_DOWN_ERROR = 1000L;
        long readError = acidMetricsDuration + DB_ROUNDING_DOWN_ERROR;
        long oldStartShiftedToNow = oldTableStart + ageInMillies;
        long oldEndShiftedToNow = oldTableEnd + ageInMillies + readError;
        Assert.assertTrue((oldStartShiftedToNow < now && now < oldEndShiftedToNow ? 1 : 0) != 0);
    }

    @Test
    public void testInitiatorNoFailure() throws Exception {
        this.startInitiator();
        Counter counter = Metrics.getOrCreateCounter((String)"compaction_initiator_failure_counter");
        Assert.assertEquals((String)"Count incorrect", (long)0L, (long)counter.getCount());
    }

    @Test
    public void testCleanerNoFailure() throws Exception {
        this.startCleaner();
        Counter counter = Metrics.getOrCreateCounter((String)"compaction_cleaner_failure_counter");
        Assert.assertEquals((String)"Count incorrect", (long)0L, (long)counter.getCount());
    }

    @Test
    public void testInitiatorAuxFailure() throws Exception {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.Initiator.name());
            Thread main = Thread.currentThread();
            this.interruptThread(5000L, main);
            this.startInitiator();
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
        Counter failureCounter = Metrics.getOrCreateCounter((String)"compaction_initiator_failure_counter");
        Assert.assertEquals((String)"count mismatch", (long)0L, (long)failureCounter.getCount());
    }

    @Test
    public void testCleanerAuxFailure() throws Exception {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.Cleaner.name());
            Thread main = Thread.currentThread();
            this.interruptThread(5000L, main);
            this.startCleaner();
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
        Counter failureCounter = Metrics.getOrCreateCounter((String)"compaction_cleaner_failure_counter");
        Assert.assertEquals((String)"count mismatch", (long)0L, (long)failureCounter.getCount());
    }

    @Test
    public void testCleanerPerfMetricsEnabled() throws Exception {
        Partition p;
        int i;
        long cleanerCyclesMinor = Objects.requireNonNull(Metrics.getOrCreateTimer((String)("api_compaction_cleaner_cycle_" + CompactionType.MINOR.toString().toLowerCase()))).getCount();
        long cleanerCyclesMajor = Objects.requireNonNull(Metrics.getOrCreateTimer((String)("api_compaction_cleaner_cycle_" + CompactionType.MAJOR.toString().toLowerCase()))).getCount();
        Table t = this.newTable("default", "camipc", true);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (i = 0; i < 10; ++i) {
            p = this.newPartition(t, "today" + i);
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            this.addDeltaFile(t, p, 21L, 24L, 4);
            partitions.add(p);
        }
        this.burnThroughTransactions("default", "camipc", 25);
        for (i = 0; i < 10; ++i) {
            CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
            rqst.setPartitionname("ds=today" + i);
            this.compactInTxn(rqst);
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_THREADS_NUM, 3);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)10L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((long)(cleanerCyclesMinor + 10L), (long)Objects.requireNonNull(Metrics.getOrCreateTimer((String)("api_compaction_cleaner_cycle_" + CompactionType.MINOR.toString().toLowerCase()))).getCount());
        for (int i2 = 0; i2 < 10; ++i2) {
            p = (Partition)partitions.get(i2);
            this.addBaseFile(t, p, 25L, 25, 26 + i2);
            CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MAJOR);
            rqst.setPartitionname("ds=today" + i2);
            this.compactInTxn(rqst);
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_THREADS_NUM, 3);
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)20L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((long)(cleanerCyclesMajor + 10L), (long)Objects.requireNonNull(Metrics.getOrCreateTimer((String)("api_compaction_cleaner_cycle_" + CompactionType.MAJOR.toString().toLowerCase()))).getCount());
    }

    @Test
    public void testCleanerPerfMetricsDisabled() throws Exception {
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)false);
        Metrics.initialize((Configuration)this.conf);
        long cleanerCyclesMinor = Objects.requireNonNull(Metrics.getOrCreateTimer((String)("api_compaction_cleaner_cycle_" + CompactionType.MAJOR.toString().toLowerCase()))).getCount();
        Table t = this.newTable("default", "camipc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "camipc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, p, 25L, 25, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((long)cleanerCyclesMinor, (long)Objects.requireNonNull(Metrics.getOrCreateTimer((String)("api_compaction_cleaner_cycle_" + CompactionType.MAJOR.toString().toLowerCase()))).getCount());
    }

    @Test
    public void testWorkerPerfMetrics() throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, (boolean)true);
        MetricsFactory.close();
        MetricsFactory.init((Configuration)this.conf);
        this.conf.setIntVar(HiveConf.ConfVars.COMPACTOR_MAX_NUM_DELTA, 1);
        Table t = this.newTable("default", "mapwb", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.burnThroughTransactions("default", "mapwb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "mapwb", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        CodahaleMetrics metrics = (CodahaleMetrics)MetricsFactory.getInstance();
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.TIMER, (String)("api_compaction_worker_cycle_" + CompactionType.MINOR.toString().toLowerCase()), (Object)1);
        this.startCleaner();
        rqst = new CompactionRequest("default", "mapwb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.txnHandler.compact(rqst);
        this.startWorker();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)rsp.getCompacts().stream().filter(c -> c.getType().equals((Object)CompactionType.MINOR)).findFirst().orElseThrow(() -> new RuntimeException("Could not found minor compaction")).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)rsp.getCompacts().stream().filter(c -> c.getType().equals((Object)CompactionType.MAJOR)).findFirst().orElseThrow(() -> new RuntimeException("Could not found minor compaction")).getState());
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.TIMER, (String)("api_compaction_worker_cycle_" + CompactionType.MAJOR.toString().toLowerCase()), (Object)1);
    }

    @Test
    public void testUpdateCompactionMetrics() {
        ShowCompactResponse scr = new ShowCompactResponse();
        ArrayList<ShowCompactResponseElement> elements = new ArrayList<ShowCompactResponseElement>();
        elements.add(this.generateElement(1L, "db", "tb", null, CompactionType.MAJOR, "failed"));
        elements.add(this.generateElement(2L, "db", "tb", null, CompactionType.MAJOR, "initiated"));
        elements.add(this.generateElement(3L, "db", "tb2", null, CompactionType.MINOR, "initiated"));
        elements.add(this.generateElement(5L, "db", "tb3", "p1", CompactionType.MINOR, "did not initiate"));
        elements.add(this.generateElement(4L, "db", "tb3", "p1", CompactionType.MINOR, "failed"));
        elements.add(this.generateElement(6L, "db1", "tb", null, CompactionType.MINOR, "failed", System.currentTimeMillis(), true, WORKER_VERSION, WORKER_VERSION, 10L));
        elements.add(this.generateElement(7L, "db1", "tb2", null, CompactionType.MINOR, "failed"));
        elements.add(this.generateElement(8L, "db1", "tb3", null, CompactionType.MINOR, "failed"));
        elements.add(this.generateElement(9L, "db2", "tb", null, CompactionType.MINOR, "succeeded"));
        elements.add(this.generateElement(10L, "db2", "tb2", null, CompactionType.MINOR, "succeeded"));
        elements.add(this.generateElement(11L, "db2", "tb3", null, CompactionType.MINOR, "succeeded"));
        elements.add(this.generateElement(12L, "db2", "tb4", null, CompactionType.MINOR, "succeeded"));
        elements.add(this.generateElement(13L, "db3", "tb3", null, CompactionType.MINOR, "working"));
        elements.add(this.generateElement(14L, "db3", "tb4", null, CompactionType.MINOR, "working", System.currentTimeMillis(), false, null, null, 20L));
        elements.add(this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "working", System.currentTimeMillis(), true, WORKER_VERSION, WORKER_VERSION, 30L));
        elements.add(this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "working"));
        elements.add(this.generateElement(17L, "db3", "tb7", null, CompactionType.MINOR, "working", System.currentTimeMillis(), true, WORKER_VERSION, WORKER_VERSION, 40L));
        scr.setCompacts(elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)("compaction_num_" + AcidMetricService.replaceWhitespace((String)"did not initiate"))).intValue());
        Assert.assertEquals((long)2L, (long)Metrics.getOrCreateGauge((String)INITIATED_METRICS_KEY).intValue());
        Assert.assertEquals((long)3L, (long)Metrics.getOrCreateGauge((String)"compaction_num_failed").intValue());
        Assert.assertEquals((long)4L, (long)Metrics.getOrCreateGauge((String)"compaction_num_succeeded").intValue());
        Assert.assertEquals((long)5L, (long)Metrics.getOrCreateGauge((String)"compaction_num_working").intValue());
        Assert.assertEquals((long)0L, (long)Metrics.getOrCreateGauge((String)("compaction_num_" + AcidMetricService.replaceWhitespace((String)"ready for cleaning"))).intValue());
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"compaction_num_initiators").intValue());
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"compaction_num_workers").intValue());
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"compaction_num_initiator_versions").intValue());
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"compaction_num_worker_versions").intValue());
    }

    @Test
    public void testAgeMetricsNotSet() {
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(1L, "db", "tb", null, CompactionType.MAJOR, "failed", 1L), (Object)this.generateElement(5L, "db", "tb3", "p1", CompactionType.MINOR, "did not initiate", 2L), (Object)this.generateElement(9L, "db2", "tb", null, CompactionType.MINOR, "succeeded", 3L));
        ShowCompactResponse scr = new ShowCompactResponse();
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertEquals((long)0L, (long)Metrics.getOrCreateGauge((String)"compaction_oldest_enqueue_age_in_sec").intValue());
        Assert.assertEquals((long)0L, (long)Metrics.getOrCreateGauge((String)"compaction_oldest_working_age_in_sec").intValue());
        Assert.assertEquals((long)0L, (long)Metrics.getOrCreateGauge((String)"compaction_oldest_cleaning_age_in_sec").intValue());
    }

    @Test
    public void testInitiatedAgeMetrics() {
        ShowCompactResponse scr = new ShowCompactResponse();
        long start = System.currentTimeMillis() - 1000L;
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "initiated", start));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        long diff = (System.currentTimeMillis() - start) / 1000L;
        int age = Metrics.getOrCreateGauge((String)"compaction_oldest_enqueue_age_in_sec").intValue();
        Assert.assertTrue(((long)age <= diff ? 1 : 0) != 0);
        Assert.assertTrue((age >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingAgeMetrics() {
        ShowCompactResponse scr = new ShowCompactResponse();
        long start = System.currentTimeMillis() - 1000L;
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(17L, "db3", "tb7", null, CompactionType.MINOR, "working", System.currentTimeMillis(), true, WORKER_VERSION, WORKER_VERSION, start));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        long diff = (System.currentTimeMillis() - start) / 1000L;
        int age = Metrics.getOrCreateGauge((String)"compaction_oldest_working_age_in_sec").intValue();
        Assert.assertTrue(((long)age <= diff ? 1 : 0) != 0);
        Assert.assertTrue((age >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCleaningAgeMetrics() {
        ShowCompactResponse scr = new ShowCompactResponse();
        long start = System.currentTimeMillis() - 1000L;
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(19L, "db3", "tb7", null, CompactionType.MINOR, "ready for cleaning", System.currentTimeMillis(), true, WORKER_VERSION, WORKER_VERSION, -1L, start));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        long diff = (System.currentTimeMillis() - start) / 1000L;
        int age = Metrics.getOrCreateGauge((String)"compaction_oldest_cleaning_age_in_sec").intValue();
        Assert.assertTrue(((long)age <= diff ? 1 : 0) != 0);
        Assert.assertTrue((age >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testInitiatedAgeMetricsOrder() {
        ShowCompactResponse scr = new ShowCompactResponse();
        long start = System.currentTimeMillis();
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "initiated", start - 1000L), (Object)this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "initiated", start - 15000L));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"compaction_oldest_enqueue_age_in_sec").intValue() > 10 ? 1 : 0) != 0);
        elements = ImmutableList.of((Object)this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "initiated", start - 25000L), (Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "initiated", start - 1000L));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"compaction_oldest_enqueue_age_in_sec").intValue() > 20 ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingAgeMetricsOrder() {
        ShowCompactResponse scr = new ShowCompactResponse();
        long start = System.currentTimeMillis();
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "working", start, false, WORKER_VERSION, WORKER_VERSION, start - 1000L), (Object)this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "working", start, false, WORKER_VERSION, WORKER_VERSION, start - 15000L));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"compaction_oldest_working_age_in_sec").intValue() > 10 ? 1 : 0) != 0);
        elements = ImmutableList.of((Object)this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "working", start, false, WORKER_VERSION, WORKER_VERSION, start - 25000L), (Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "working", start, false, WORKER_VERSION, WORKER_VERSION, start - 1000L));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"compaction_oldest_working_age_in_sec").intValue() > 20 ? 1 : 0) != 0);
    }

    @Test
    public void testCleaningAgeMetricsOrder() {
        ShowCompactResponse scr = new ShowCompactResponse();
        long start = System.currentTimeMillis();
        ImmutableList elements = ImmutableList.of((Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "ready for cleaning", start, false, WORKER_VERSION, WORKER_VERSION, -1L, start - 1000L), (Object)this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "ready for cleaning", start, false, WORKER_VERSION, WORKER_VERSION, -1L, start - 15000L));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"compaction_oldest_cleaning_age_in_sec").intValue() > 10 ? 1 : 0) != 0);
        elements = ImmutableList.of((Object)this.generateElement(16L, "db3", "tb6", null, CompactionType.MINOR, "ready for cleaning", start, false, WORKER_VERSION, WORKER_VERSION, -1L, start - 25000L), (Object)this.generateElement(15L, "db3", "tb5", null, CompactionType.MINOR, "ready for cleaning", start, false, WORKER_VERSION, WORKER_VERSION, -1L, start - 1000L));
        scr.setCompacts((List)elements);
        AcidMetricService.updateMetricsFromShowCompact((ShowCompactResponse)scr);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"compaction_oldest_cleaning_age_in_sec").intValue() > 20 ? 1 : 0) != 0);
    }

    @Test
    public void testDBMetrics() throws Exception {
        String dbName = "default";
        String tblName = "dcamc";
        Table t = this.newTable(dbName, tblName, false);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_LEVEL, (boolean)false);
        TxnHandler.ConfVars.setUseMinHistoryLevel(false);
        long start = System.currentTimeMillis();
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 24, new HashSet<Long>(Arrays.asList(22L, 23L, 24L)), null);
        this.openTxn(TxnType.REPL_CREATED);
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, t.getDbName());
        comp.setTablename(t.getTableName());
        comp.setOperationType(DataOperationType.UPDATE);
        LockRequest req = new LockRequest((List)Lists.newArrayList((Object[])new LockComponent[]{comp}), "me", "localhost");
        req.setTxnid(22L);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        this.txnHandler.commitTxn(new CommitTxnRequest(22L));
        req.setTxnid(23L);
        res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        Thread.sleep(1000L);
        this.runAcidMetricService();
        long diff = (System.currentTimeMillis() - start) / 1000L;
        Assert.assertEquals((long)24L, (long)Metrics.getOrCreateGauge((String)"compaction_num_txn_to_writeid").intValue());
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"compaction_num_completed_txn_components").intValue());
        Assert.assertEquals((long)2L, (long)Metrics.getOrCreateGauge((String)"num_open_non_repl_transactions").intValue());
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"num_open_repl_transactions").intValue());
        Assert.assertEquals((long)23L, (long)Metrics.getOrCreateGauge((String)"oldest_open_non_repl_txn_id").longValue());
        Assert.assertTrue(((long)Metrics.getOrCreateGauge((String)"oldest_open_non_repl_txn_age_in_sec").intValue() <= diff ? 1 : 0) != 0);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"oldest_open_non_repl_txn_age_in_sec").intValue() >= 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)25L, (long)Metrics.getOrCreateGauge((String)"oldest_open_repl_txn_id").longValue());
        Assert.assertTrue(((long)Metrics.getOrCreateGauge((String)"oldest_open_repl_txn_age_in_sec").intValue() <= diff ? 1 : 0) != 0);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"oldest_open_repl_txn_age_in_sec").intValue() >= 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)Metrics.getOrCreateGauge((String)"num_locks").intValue());
        Assert.assertTrue(((long)Metrics.getOrCreateGauge((String)"oldest_lock_age_in_sec").intValue() <= diff ? 1 : 0) != 0);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"oldest_lock_age_in_sec").intValue() >= 1 ? 1 : 0) != 0);
        this.txnHandler.cleanTxnToWriteIdTable();
        this.runAcidMetricService();
        Assert.assertEquals((long)3L, (long)Metrics.getOrCreateGauge((String)"compaction_num_txn_to_writeid").intValue());
        start = System.currentTimeMillis();
        this.burnThroughTransactions(dbName, tblName, 3, null, new HashSet<Long>(Arrays.asList(26L, 28L)));
        Thread.sleep(1000L);
        this.runAcidMetricService();
        diff = (System.currentTimeMillis() - start) / 1000L;
        Assert.assertTrue(((long)Metrics.getOrCreateGauge((String)"oldest_aborted_txn_age_in_sec").intValue() <= diff ? 1 : 0) != 0);
        Assert.assertTrue((Metrics.getOrCreateGauge((String)"oldest_aborted_txn_age_in_sec").intValue() >= 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)26L, (long)Metrics.getOrCreateGauge((String)"oldest_aborted_txn_id").longValue());
        Assert.assertEquals((long)2L, (long)Metrics.getOrCreateGauge((String)"num_aborted_transactions").intValue());
    }

    @Test
    public void testTxnHandlerCounters() throws Exception {
        String dbName = "default";
        String tblName = "txnhandlercounters";
        Table t = this.newTable(dbName, tblName, false);
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 3, null, new HashSet<Long>(Arrays.asList(2L, 3L)));
        Assert.assertEquals((String)"total_num_aborted_transactions value incorrect", (long)2L, (long)Metrics.getOrCreateCounter((String)"total_num_aborted_transactions").getCount());
        Assert.assertEquals((String)"total_num_committed_transactions value incorrect", (long)1L, (long)Metrics.getOrCreateCounter((String)"total_num_committed_transactions").getCount());
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 3, null, new HashSet<Long>(Collections.singletonList(4L)));
        Assert.assertEquals((String)"total_num_aborted_transactions value incorrect", (long)3L, (long)Metrics.getOrCreateCounter((String)"total_num_aborted_transactions").getCount());
        Assert.assertEquals((String)"total_num_committed_transactions value incorrect", (long)3L, (long)Metrics.getOrCreateCounter((String)"total_num_committed_transactions").getCount());
    }

    @Test
    public void testTablesWithXAbortedTxns() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_TABLES_WITH_ABORTED_TXNS_THRESHOLD, (long)14L);
        String dbName = "default";
        String tblName1 = "table1";
        String tblName2 = "table2";
        String tblName3 = "table3";
        Table t1 = this.newTable(dbName, tblName1, false);
        Table t2 = this.newTable(dbName, tblName2, false);
        Table t3 = this.newTable(dbName, tblName3, false);
        Set<Long> abort1 = LongStream.range(1L, 16L).boxed().collect(Collectors.toSet());
        Set<Long> abort2 = LongStream.range(21L, 31L).boxed().collect(Collectors.toSet());
        Set<Long> abort3 = LongStream.range(41L, 61L).boxed().collect(Collectors.toSet());
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, dbName);
        comp.setOperationType(DataOperationType.INSERT);
        LockRequest lockReq = new LockRequest((List)Lists.newArrayList((Object[])new LockComponent[]{comp}), "me", "localhost");
        comp.setTablename(t1.getTableName());
        this.burnThroughTransactions(t1.getDbName(), t1.getTableName(), 20, null, abort1, lockReq);
        comp.setTablename(t2.getTableName());
        this.burnThroughTransactions(t2.getDbName(), t2.getTableName(), 20, null, abort2, lockReq);
        comp.setTablename(t3.getTableName());
        this.burnThroughTransactions(t3.getDbName(), t3.getTableName(), 30, null, abort3, lockReq);
        this.runAcidMetricService();
        Assert.assertEquals((String)"tables_with_x_aborted_transactions value incorrect", (long)2L, (long)Metrics.getOrCreateGauge((String)"tables_with_x_aborted_transactions").intValue());
    }

    @Test
    public void testPartTablesWithXAbortedTxns() throws Exception {
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_TABLES_WITH_ABORTED_TXNS_THRESHOLD, (long)4L);
        String dbName = "default";
        String tblName = "table";
        String part1 = "p1";
        String part2 = "p2";
        String part3 = "p3";
        Table t = this.newTable(dbName, tblName, true);
        this.newPartition(t, part1);
        this.newPartition(t, part2);
        this.newPartition(t, part3);
        String partPattern = ((FieldSchema)t.getPartitionKeys().get(0)).getName() + "=%s";
        Set<Long> abort1 = LongStream.range(1L, 6L).boxed().collect(Collectors.toSet());
        Set<Long> abort2 = LongStream.range(11L, 16L).boxed().collect(Collectors.toSet());
        LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, dbName);
        comp.setTablename(tblName);
        comp.setOperationType(DataOperationType.INSERT);
        LockRequest lockReq = new LockRequest((List)Lists.newArrayList((Object[])new LockComponent[]{comp}), "me", "localhost");
        comp.setPartitionname(String.format(partPattern, part1));
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 10, null, abort1, lockReq);
        comp.setPartitionname(String.format(partPattern, part2));
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 10, null, abort2, lockReq);
        comp.setPartitionname(String.format(partPattern, part3));
        this.burnThroughTransactions(t.getDbName(), t.getTableName(), 10, null, null, lockReq);
        this.runAcidMetricService();
        Assert.assertEquals((String)"tables_with_x_aborted_transactions value incorrect", (long)2L, (long)Metrics.getOrCreateGauge((String)"tables_with_x_aborted_transactions").intValue());
    }

    @Test
    public void testWritesToDisabledCompactionTable() throws Exception {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS, (String)HMSMetricsListener.class.getName());
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
        String dbName = "default";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("no_auto_compaction", "true");
        Table disabledTbl = this.newTable(dbName, "comp_disabled", false, params);
        this.burnThroughTransactions(disabledTbl.getDbName(), disabledTbl.getTableName(), 1, null, null);
        this.burnThroughTransactions(disabledTbl.getDbName(), disabledTbl.getTableName(), 1, null, new HashSet<Long>(Collections.singletonList(2L)));
        Table enabledTbl = this.newTable(dbName, "comp_enabled", false);
        this.burnThroughTransactions(enabledTbl.getDbName(), enabledTbl.getTableName(), 1, null, null);
        Assert.assertEquals((String)"num_writes_to_disabled_compaction_table value incorrect", (long)2L, (long)Metrics.getOrCreateGauge((String)"num_writes_to_disabled_compaction_table").intValue());
    }

    @Test
    public void testInitiatorDurationMeasuredCorrectly() throws Exception {
        String DEFAULT_DB = "default";
        String TABLE_NAME = "x_table";
        String PARTITION_NAME = "part";
        ArrayList<LockComponent> components = new ArrayList<LockComponent>();
        Table table = this.newTable("default", "x_table", true);
        for (int i = 0; i < 10; ++i) {
            String partitionName = "part" + i;
            Partition p = this.newPartition(table, partitionName);
            this.addBaseFile(table, p, 20L, 20);
            this.addDeltaFile(table, p, 21L, 22L, 2);
            this.addDeltaFile(table, p, 23L, 24L, 2);
            this.addDeltaFile(table, p, 21L, 24L, 4);
            LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
            comp.setTablename("x_table");
            comp.setPartitionname("ds=" + partitionName);
            comp.setOperationType(DataOperationType.UPDATE);
            components.add(comp);
        }
        this.burnThroughTransactions("default", "x_table", 25);
        long txnId = this.openTxn();
        LockRequest req = new LockRequest(components, "me", "localhost");
        req.setTxnid(txnId);
        LockResponse res = this.txnHandler.lock(req);
        Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
        this.allocateWriteId("default", "x_table", txnId);
        this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        long initiatorStart = System.currentTimeMillis();
        this.startInitiator();
        long durationUpperLimit = System.currentTimeMillis() - initiatorStart;
        int initiatorDurationFromMetric = Metrics.getOrCreateGauge((String)"compaction_initiator_cycle_duration").intValue();
        Assert.assertTrue((String)"Initiator duration must be withing the limits", (0 < initiatorDurationFromMetric && (long)initiatorDurationFromMetric <= durationUpperLimit ? 1 : 0) != 0);
    }

    @Test
    public void testCleanerDurationMeasuredCorrectly() throws Exception {
        this.conf.setIntVar(HiveConf.ConfVars.COMPACTOR_MAX_NUM_DELTA, 1);
        String DB_NAME = "default";
        String TABLE_NAME = "x_table";
        String PARTITION_NAME = "part";
        Table table = this.newTable("default", "x_table", true);
        Partition partition = this.newPartition(table, "part");
        this.addBaseFile(table, partition, 20L, 20);
        this.addDeltaFile(table, partition, 21L, 22L, 2);
        this.addDeltaFile(table, partition, 23L, 24L, 2);
        this.burnThroughTransactions("default", "x_table", 25);
        this.doCompaction("default", "x_table", "part", CompactionType.MINOR);
        long cleanerStart = System.currentTimeMillis();
        this.startCleaner();
        long durationUpperLimit = System.currentTimeMillis() - cleanerStart;
        int cleanerDurationFromMetric = Metrics.getOrCreateGauge((String)"compaction_cleaner_cycle_duration").intValue();
        Assert.assertTrue((String)"Cleaner duration must be withing the limits", (0 < cleanerDurationFromMetric && (long)cleanerDurationFromMetric <= durationUpperLimit ? 1 : 0) != 0);
    }

    @Test
    public void testInitiatorFailuresCountedCorrectly() throws Exception {
        String DEFAULT_DB = "default";
        String SUCCESS_TABLE_NAME = "success_table";
        String FAILING_TABLE_NAME = "failing_table";
        String PARTITION_NAME = "part";
        long EXPECTED_SUCCESS_COUNT = 10L;
        long EXPECTED_FAIL_COUNT = 6L;
        ControlledFailingTxHandler.failedTableName = "failing_table";
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_STORE_IMPL, (String)"org.apache.hadoop.hive.ql.txn.compactor.TestCompactionMetrics$ControlledFailingTxHandler");
        Table failedTable = this.newTable("default", "failing_table", true);
        Table succeededTable = this.newTable("default", "success_table", true);
        for (Table table : new Table[]{succeededTable, failedTable}) {
            ArrayList<LockComponent> components = new ArrayList<LockComponent>();
            String tableName = table.getTableName();
            long partitionCount = "failing_table".equals(tableName) ? 6L : 10L;
            int i = 0;
            while ((long)i < partitionCount) {
                String partitionName = "part" + i;
                Partition p = this.newPartition(table, partitionName);
                this.addBaseFile(table, p, 20L, 20);
                this.addDeltaFile(table, p, 21L, 22L, 2);
                this.addDeltaFile(table, p, 23L, 24L, 2);
                this.addDeltaFile(table, p, 21L, 24L, 4);
                LockComponent comp = new LockComponent(LockType.SHARED_WRITE, LockLevel.PARTITION, "default");
                comp.setTablename(tableName);
                comp.setPartitionname("ds=" + partitionName);
                comp.setOperationType(DataOperationType.UPDATE);
                components.add(comp);
                ++i;
            }
            this.burnThroughTransactions("default", tableName, 25);
            long txnid = this.openTxn();
            LockRequest req = new LockRequest(components, "me", "localhost");
            req.setTxnid(txnid);
            LockResponse res = this.txnHandler.lock(req);
            Assert.assertEquals((Object)LockState.ACQUIRED, (Object)res.getState());
            long writeid = this.allocateWriteId("default", tableName, txnid);
            Assert.assertEquals((long)26L, (long)writeid);
            this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_REQUEST_QUEUE, 5);
        this.startInitiator();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)16L, (long)rsp.getCompactsSize());
        Assert.assertEquals((long)6L, (long)Metrics.getOrCreateCounter((String)"compaction_initiator_failure_counter").getCount());
    }

    @Test
    public void testCleanerFailuresCountedCorrectly() throws Exception {
        String DEFAULT_DB = "default";
        String SUCCESS_TABLE_NAME = "success_table";
        String FAILING_TABLE_NAME = "failing_table";
        String PARTITION_NAME = "part";
        long EXPECTED_SUCCESS_COUNT = 10L;
        long EXPECTED_FAIL_COUNT = 6L;
        ControlledFailingTxHandler.failedTableName = "failing_table";
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_STORE_IMPL, (String)"org.apache.hadoop.hive.ql.txn.compactor.TestCompactionMetrics$ControlledFailingTxHandler");
        Table failedTable = this.newTable("default", "failing_table", true);
        Table succeededTable = this.newTable("default", "success_table", true);
        for (Table table : new Table[]{succeededTable, failedTable}) {
            String tableName = table.getTableName();
            long partitionCount = "failing_table".equals(tableName) ? 6L : 10L;
            int i = 0;
            while ((long)i < partitionCount) {
                Partition p = this.newPartition(table, "part" + i);
                this.addBaseFile(table, p, 20L, 20);
                this.addDeltaFile(table, p, 21L, 22L, 2);
                this.addDeltaFile(table, p, 23L, 24L, 2);
                this.addDeltaFile(table, p, 21L, 24L, 4);
                ++i;
            }
            this.burnThroughTransactions("default", tableName, 25);
            i = 0;
            while ((long)i < partitionCount) {
                CompactionRequest rqst = new CompactionRequest("default", tableName, CompactionType.MINOR);
                rqst.setPartitionname("ds=part" + i);
                this.compactInTxn(rqst);
                ++i;
            }
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_THREADS_NUM, 5);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)16L, (long)rsp.getCompactsSize());
        Assert.assertEquals((long)6L, (long)Metrics.getOrCreateCounter((String)"compaction_cleaner_failure_counter").getCount());
    }

    private ShowCompactResponseElement generateElement(long id, String db, String table, String partition, CompactionType type, String state) {
        return this.generateElement(id, db, table, partition, type, state, System.currentTimeMillis());
    }

    private ShowCompactResponseElement generateElement(long id, String db, String table, String partition, CompactionType type, String state, long enqueueTime) {
        return this.generateElement(id, db, table, partition, type, state, enqueueTime, false);
    }

    private ShowCompactResponseElement generateElement(long id, String db, String table, String partition, CompactionType type, String state, long enqueueTime, boolean manuallyInitiatedCompaction) {
        return this.generateElement(id, db, table, partition, type, state, enqueueTime, manuallyInitiatedCompaction, null, null, -1L);
    }

    private ShowCompactResponseElement generateElement(long id, String db, String table, String partition, CompactionType type, String state, long enqueueTime, boolean manuallyInitiatedCompaction, String initiatorVersion, String workerVersion, long startTime) {
        return this.generateElement(id, db, table, partition, type, state, enqueueTime, manuallyInitiatedCompaction, initiatorVersion, workerVersion, startTime, -1L);
    }

    private ShowCompactResponseElement generateElement(long id, String db, String table, String partition, CompactionType type, String state, long enqueueTime, boolean manuallyInitiatedCompaction, String initiatorVersion, String workerVersion, long startTime, long cleanerStartTime) {
        ShowCompactResponseElement element = new ShowCompactResponseElement(db, table, type, state);
        element.setId(id);
        element.setPartitionname(partition);
        element.setEnqueueTime(enqueueTime);
        String runtimeId = manuallyInitiatedCompaction ? "hs2-host-" + ThreadLocalRandom.current().nextInt(999) + "-manual" : ServerUtils.hostname() + "-" + ThreadLocalRandom.current().nextInt(999);
        String workerId = "hs2-host-" + ThreadLocalRandom.current().nextInt(999);
        element.setInitiatorId(runtimeId);
        element.setWorkerid(workerId);
        element.setInitiatorVersion(initiatorVersion);
        element.setWorkerVersion(workerVersion);
        element.setStart(startTime);
        element.setCleanerStart(cleanerStartTime);
        return element;
    }

    private void interruptThread(long timeout, Thread target) {
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(timeout);
                target.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void doCompaction(String dbName, String tableName, String partitionName, CompactionType type) throws Exception {
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, type);
        rqst.setPartitionname("ds=" + partitionName);
        this.txnHandler.compact(rqst);
        this.startWorker();
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    public static class ControlledFailingTxHandler
    extends ThrowingTxnHandler {
        public static volatile String failedTableName;

        public GetValidWriteIdsResponse getValidWriteIds(GetValidWriteIdsRequest rqst) throws MetaException {
            if (rqst.getFullTableNames().stream().anyMatch(t -> t.endsWith("." + failedTableName))) {
                throw new RuntimeException("TxnHandler fails during getValidWriteIds");
            }
            return super.getValidWriteIds(rqst);
        }

        public void markCleanerStart(CompactionInfo info) throws MetaException {
            if (failedTableName.equals(info.tableName)) {
                throw new RuntimeException("TxnHandler fails during MarkCleaned");
            }
            super.markCleanerStart(info);
        }
    }
}

