/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionHeartbeatService;
import org.apache.hadoop.hive.ql.txn.compactor.IMetaStoreClientFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestCompactionHeartbeatService {
    private static Field HEARTBEAT_SINGLETON;
    private static Field HEARTBEAT_CLIENTPOOL;
    @Mock
    private HiveConf conf;
    @Mock
    private IMetaStoreClient client;
    private MockedStatic<HiveMetaStoreUtils> hiveMetaStoreUtilsMockedStatic;
    private ObjectPool<IMetaStoreClient> clientPool;

    @BeforeClass
    public static void setupClass() throws NoSuchFieldException {
        HEARTBEAT_SINGLETON = CompactionHeartbeatService.class.getDeclaredField("instance");
        HEARTBEAT_SINGLETON.setAccessible(true);
        HEARTBEAT_CLIENTPOOL = CompactionHeartbeatService.class.getDeclaredField("clientPool");
        HEARTBEAT_CLIENTPOOL.setAccessible(true);
    }

    @Before
    public void setup() throws Exception {
        this.hiveMetaStoreUtilsMockedStatic = Mockito.mockStatic(HiveMetaStoreUtils.class);
        this.hiveMetaStoreUtilsMockedStatic.when(() -> HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)((HiveConf)ArgumentMatchers.any()))).thenReturn((Object)this.client);
        Mockito.when((Object)this.conf.get(MetastoreConf.ConfVars.TXN_TIMEOUT.getVarname())).thenReturn((Object)"100ms");
        Mockito.when((Object)this.conf.get(MetastoreConf.ConfVars.COMPACTOR_WORKER_THREADS.getVarname())).thenReturn((Object)"4");
        HEARTBEAT_SINGLETON.set(null, null);
        IMetaStoreClientFactory metaStoreClientFactory = (IMetaStoreClientFactory)Mockito.spy((Object)new IMetaStoreClientFactory(this.conf));
        ((IMetaStoreClientFactory)Mockito.doReturn((Object)this.client).when((Object)metaStoreClientFactory)).create();
        this.clientPool = (ObjectPool)Mockito.spy((Object)new GenericObjectPool((PooledObjectFactory)metaStoreClientFactory));
        CompactionHeartbeatService compactionHeartbeatService = CompactionHeartbeatService.getInstance((HiveConf)this.conf);
        HEARTBEAT_CLIENTPOOL.set(compactionHeartbeatService, this.clientPool);
    }

    @After
    public void tearDown() throws InterruptedException {
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).shutdown();
        this.hiveMetaStoreUtilsMockedStatic.close();
    }

    @Test
    public void testHeartbeat() throws Exception {
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).startHeartbeat(0L, 0L, "table");
        Thread.sleep(300L);
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).stopHeartbeat(0L);
        ((IMetaStoreClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.atLeast((int)1))).heartbeat(0L, 0L);
    }

    @Test(expected=IllegalStateException.class)
    public void testStopHeartbeatForNonExistentTxn() throws InterruptedException {
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).stopHeartbeat(0L);
    }

    @Test
    public void testNoHeartbeatAfterStop() throws Exception {
        AtomicBoolean stopped = new AtomicBoolean(false);
        ((IMetaStoreClient)Mockito.doAnswer(invocationOnMock -> {
            if (stopped.get()) {
                Assert.fail((String)"Heartbeat after stopHeartbeat call");
            }
            return null;
        }).when((Object)this.client)).heartbeat(0L, 0L);
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).startHeartbeat(0L, 0L, "table");
        Thread.sleep(200L);
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).stopHeartbeat(0L);
        stopped.set(true);
        ((IMetaStoreClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.atLeast((int)1))).heartbeat(0L, 0L);
    }

    @Test(expected=IllegalStateException.class)
    public void testStartHeartbeatTwice() {
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).startHeartbeat(0L, 0L, "table");
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).startHeartbeat(0L, 0L, "table");
    }

    @Test
    public void testStopHeartbeatAbortedTheThread() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean heartbeated = new AtomicBoolean(false);
        ((IMetaStoreClient)Mockito.doAnswer(invocationOnMock -> {
            countDownLatch.countDown();
            Thread.sleep(500L);
            heartbeated.set(true);
            return null;
        }).when((Object)this.client)).heartbeat(0L, 0L);
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).startHeartbeat(0L, 0L, "table");
        countDownLatch.await();
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).stopHeartbeat(0L);
        Assert.assertFalse((boolean)heartbeated.get());
        ((IMetaStoreClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).heartbeat(0L, 0L);
    }

    @Test
    public void testBadClientInvalidated() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(3);
        ((IMetaStoreClient)Mockito.doAnswer(invocationOnMock -> {
            countDownLatch.countDown();
            if (countDownLatch.getCount() == 0L) {
                Thread.sleep(100L);
            }
            throw new RuntimeException();
        }).when((Object)this.client)).heartbeat(0L, 0L);
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).startHeartbeat(0L, 0L, "table");
        countDownLatch.await();
        CompactionHeartbeatService.getInstance((HiveConf)this.conf).stopHeartbeat(0L);
        ((IMetaStoreClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).heartbeat(0L, 0L);
        ((IMetaStoreClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)3))).close();
        HiveMetaStoreUtils.getHiveMetastoreClient((HiveConf)this.conf);
        ((ObjectPool)Mockito.verify(this.clientPool, (VerificationMode)Mockito.times((int)3))).borrowObject();
    }
}

