/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTest;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TaskHandlerFactory;
import org.apache.hive.common.util.ReflectionUtil;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCleaner
extends CompactorTest {
    @Test
    public void nothing() throws Exception {
        this.startCleaner();
    }

    @Test
    public void testRetryAfterFailedCleanupDelayEnabled() throws Exception {
        this.testRetryAfterFailedCleanup(true);
    }

    @Test
    public void testRetryAfterFailedCleanupDelayDisabled() throws Exception {
        this.testRetryAfterFailedCleanup(false);
    }

    public void testRetryAfterFailedCleanup(boolean delayEnabled) throws Exception {
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, (boolean)delayEnabled);
        HiveConf.setTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, (long)2L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_MAX_RETRY_ATTEMPTS, (long)3L);
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        String errorMessage = "No cleanup here!";
        TxnStore mockedHandler = (TxnStore)Mockito.spy((Object)this.txnHandler);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover fsRemover = new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache);
        List taskHandlers = TaskHandlerFactory.getInstance().getHandlers(this.conf, mockedHandler, metadataCache, false, fsRemover);
        ((TxnStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(errorMessage)}).when((Object)mockedHandler)).markCleaned((CompactionInfo)ArgumentMatchers.nullable(CompactionInfo.class));
        Table t = this.newTable("default", "retry_test", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "retry_test", 25);
        CompactionRequest rqst = new CompactionRequest("default", "retry_test", CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        long retentionTime = delayEnabled ? this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS) : 0L;
        long retryRetentionTime = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETRY_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
        Thread.sleep(retentionTime + 100L);
        for (int i = 1; i < 4; ++i) {
            Cleaner cleaner = new Cleaner();
            cleaner.setConf((Configuration)this.conf);
            cleaner.init(new AtomicBoolean(true));
            cleaner.setCleanupHandlers(taskHandlers);
            ReflectionUtil.setInAllFields((Object)cleaner, (String)"txnHandler", (Object)mockedHandler);
            cleaner.run();
            Thread.sleep(retryRetentionTime * (long)Math.pow(2.0, i - 1) + 100L);
            Optional compactionByTxnId = this.txnHandler.getCompactionByTxnId(compactTxn);
            Assert.assertTrue((String)"Expected compactionInfo, but got nothing returned", (boolean)compactionByTxnId.isPresent());
            CompactionInfo ci = (CompactionInfo)compactionByTxnId.get();
            Assert.assertEquals((String)String.format("Expected 'r' (ready for cleaning) state, but got: '%c'", Character.valueOf(ci.state)), (long)114L, (long)ci.state);
            Assert.assertEquals((String)String.format("Expected error message: '%s', but got '%s'", errorMessage, ci.errorMessage), (Object)errorMessage, (Object)ci.errorMessage);
            int cleanAttempts = (int)(Math.log(ci.retryRetention / retryRetentionTime) / Math.log(2.0)) + 1;
            Assert.assertEquals((String)String.format("Expected %d clean attempts, but got %d", i, cleanAttempts), (long)i, (long)cleanAttempts);
        }
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(taskHandlers);
        ReflectionUtil.setInAllFields((Object)cleaner, (String)"txnHandler", (Object)mockedHandler);
        cleaner.run();
        ShowCompactResponse scr = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)String.format("Expected %d CompactionInfo, but got %d", 1, scr.getCompactsSize()), (long)1L, (long)scr.getCompactsSize());
        ShowCompactResponseElement scre = (ShowCompactResponseElement)scr.getCompacts().get(0);
        Assert.assertEquals((String)String.format("Expected '%s' state, but got '%s'", "failed", scre.getState()), (Object)"failed", (Object)scre.getState());
        Assert.assertEquals((String)String.format("Expected error message: '%s', but got '%s'", errorMessage, scre.getErrorMessage()), (Object)errorMessage, (Object)scre.getErrorMessage());
    }

    @Test
    public void testRetentionAfterFailedCleanup() throws Exception {
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, false);
        Table t = this.newTable("default", "retry_test", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "retry_test", 25);
        CompactionRequest rqst = new CompactionRequest("default", "retry_test", CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        TxnStore mockedHandler = (TxnStore)Mockito.spy((Object)this.txnHandler);
        MetadataCache metadataCache = new MetadataCache(true);
        FSRemover fsRemover = new FSRemover(this.conf, ReplChangeManager.getInstance((Configuration)this.conf), metadataCache);
        List taskHandlers = TaskHandlerFactory.getInstance().getHandlers(this.conf, mockedHandler, metadataCache, false, fsRemover);
        ((TxnStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)mockedHandler)).markCleaned((CompactionInfo)ArgumentMatchers.nullable(CompactionInfo.class));
        Cleaner cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(taskHandlers);
        ReflectionUtil.setInAllFields((Object)cleaner, (String)"txnHandler", (Object)mockedHandler);
        cleaner.run();
        AtomicReference reference = new AtomicReference();
        ((TxnStore)Mockito.doAnswer(invocation -> {
            Object o = invocation.callRealMethod();
            reference.set((List)o);
            return o;
        }).when((Object)mockedHandler)).findReadyToClean(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        cleaner = new Cleaner();
        cleaner.setConf((Configuration)this.conf);
        cleaner.init(new AtomicBoolean(true));
        cleaner.setCleanupHandlers(taskHandlers);
        ReflectionUtil.setInAllFields((Object)cleaner, (String)"txnHandler", (Object)mockedHandler);
        cleaner.run();
        Assert.assertEquals((long)0L, (long)((List)reference.get()).size());
    }

    @Test
    public void cleanupAfterMajorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.burnThroughTransactions("default", "camtc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)AcidUtils.addVisibilitySuffix((String)"base_25", (long)26L), (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterIOWAndMajorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "camtc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)AcidUtils.addVisibilitySuffix((String)"base_25", (long)26L), (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMajorTableCompactionWithLongRunningQuery() throws Exception {
        Table t = this.newTable("default", "camtc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25, 26L);
        this.burnThroughTransactions("default", "camtc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camtc", CompactionType.MAJOR);
        this.txnHandler.compact(rqst);
        FindNextCompactRequest findNextCompactRequest = new FindNextCompactRequest();
        findNextCompactRequest.setWorkerId("fred");
        findNextCompactRequest.setWorkerVersion(WORKER_VERSION);
        CompactionInfo ci = this.txnHandler.findNextToCompact(findNextCompactRequest);
        ci.runAs = System.getProperty("user.name");
        long compactTxn = this.openTxn(TxnType.COMPACTION);
        ValidTxnList validTxnList = TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.txnHandler.getOpenTxns(Collections.singletonList(TxnType.READ_ONLY)), (long)compactTxn);
        GetValidWriteIdsRequest validWriteIdsRqst = new GetValidWriteIdsRequest(Collections.singletonList(ci.getFullTableName()));
        validWriteIdsRqst.setValidTxnList(validTxnList.writeToString());
        ValidCompactorWriteIdList tblValidWriteIds = TxnUtils.createValidCompactWriteIdList((TableValidWriteIds)((TableValidWriteIds)this.txnHandler.getValidWriteIds(validWriteIdsRqst).getTblValidWriteIds().get(0)));
        ci.highestWriteId = tblValidWriteIds.getHighWatermark();
        this.txnHandler.updateCompactorState(ci, compactTxn);
        this.txnHandler.markCompacted(ci);
        long longQuery = this.openTxn();
        if (this.useMinHistoryWriteId()) {
            this.allocateTableWriteId("default", "camtc", longQuery);
        }
        this.txnHandler.commitTxn(new CommitTxnRequest(compactTxn));
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)4L, (long)paths.size());
        this.txnHandler.commitTxn(new CommitTxnRequest(longQuery));
        Thread.sleep(MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)AcidUtils.addVisibilitySuffix((String)"base_25", (long)26L), (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMajorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "campc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "campc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "campc", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void cleanupAfterMinorTableCompaction() throws Exception {
        Table t = this.newTable("default", "camitc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addDeltaFile(t, null, 21L, 24L, 4);
        this.burnThroughTransactions("default", "camitc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camitc", CompactionType.MINOR);
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path p : paths) {
            if (p.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (p.getName().equals(this.makeDeltaDirName(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + p.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void cleanupAfterMinorPartitionCompaction() throws Exception {
        Table t = this.newTable("default", "camipc", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "camipc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void cleanupAfterMajorPartitionCompactionNoBase() throws Exception {
        Table t = this.newTable("default", "campcnb", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "campcnb", 25);
        CompactionRequest rqst = new CompactionRequest("default", "campcnb", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void droppedTable() throws Exception {
        Table t = this.newTable("default", "dt", false);
        this.addDeltaFile(t, null, 1L, 22L, 22);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dt", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dt", CompactionType.MINOR);
        this.compactInTxn(rqst);
        this.ms.dropTable("default", "dt");
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void droppedPartition() throws Exception {
        Table t = this.newTable("default", "dp", true);
        Partition p = this.newPartition(t, "today");
        this.addDeltaFile(t, p, 1L, 22L, 22);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addBaseFile(t, p, 25L, 25);
        this.burnThroughTransactions("default", "dp", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dp", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.ms.dropPartition("default", "dp", Collections.singletonList("today"), true);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)0L, (long)rsp.getCompactsSize());
    }

    @Test
    public void processCompactionCandidatesInParallel() throws Exception {
        int i;
        Table t = this.newTable("default", "camipc", true);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (i = 0; i < 10; ++i) {
            Partition p = this.newPartition(t, "today" + i);
            this.addBaseFile(t, p, 20L, 20);
            this.addDeltaFile(t, p, 21L, 22L, 2);
            this.addDeltaFile(t, p, 23L, 24L, 2);
            this.addDeltaFile(t, p, 21L, 24L, 4);
            partitions.add(p);
        }
        this.burnThroughTransactions("default", "camipc", 25);
        for (i = 0; i < 10; ++i) {
            CompactionRequest rqst = new CompactionRequest("default", "camipc", CompactionType.MINOR);
            rqst.setPartitionname("ds=today" + i);
            this.compactInTxn(rqst);
        }
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_THREADS_NUM, 3);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)10L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        for (Partition pa : partitions) {
            List<Path> paths = this.getDirectories(this.conf, t, pa);
            Assert.assertEquals((long)2L, (long)paths.size());
            boolean sawBase = false;
            boolean sawDelta = false;
            for (Path path : paths) {
                if (path.getName().equals("base_20")) {
                    sawBase = true;
                    continue;
                }
                if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                    sawDelta = true;
                    continue;
                }
                Assert.fail((String)("Unexpected file " + path.getName()));
            }
            Assert.assertTrue((boolean)sawBase);
            Assert.assertTrue((boolean)sawDelta);
        }
    }

    @Test
    public void delayedCleanupAfterMajorCompaction() throws Exception {
        Table t = this.newTable("default", "dcamc", false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dcamc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamc", CompactionType.MAJOR);
        this.compactInTxn(rqst);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, true);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, 5L, TimeUnit.SECONDS);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void delayedCleanupAfterMinorCompactionOnPartition() throws Exception {
        Table t = this.newTable("default", "dcamicop", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "dcamicop", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamicop", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, true);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, 5L, TimeUnit.SECONDS);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void delayedCleanupAfterMinorAndMajorCompaction() throws Exception {
        Table t = this.newTable("default", "dcamimcop", true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 21L, 1);
        this.addDeltaFile(t, p, 22L, 22L, 1);
        this.burnThroughTransactions("default", "dcamimcop", 22);
        CompactionRequest rqst = new CompactionRequest("default", "dcamimcop", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 23L, 1);
        this.burnThroughTransactions("default", "dcamimcop", 1);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED, true);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, 5L, TimeUnit.SECONDS);
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        rqst = new CompactionRequest("default", "dcamimcop", CompactionType.MAJOR);
        rqst.setPartitionname("ds=today");
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, p, 23L, 23, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        for (ShowCompactResponseElement c : rsp.getCompacts()) {
            if (c.getType() == CompactionType.MAJOR) {
                Assert.assertEquals((Object)"ready for cleaning", (Object)c.getState());
                continue;
            }
            Assert.assertEquals((Object)"succeeded", (Object)c.getState());
        }
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)4L, (long)paths.size());
        Thread.sleep(this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, TimeUnit.MILLISECONDS));
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(1)).getState());
        paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)AcidUtils.addVisibilitySuffix((String)"base_23", (long)25L), (Object)paths.get(0).getName());
    }

    @Test
    public void testReadyForCleaningPileup() throws Exception {
        String dbName = "default";
        String tblName = "trfcp";
        String partName = "ds=today";
        Table t = this.newTable(dbName, tblName, true);
        Partition p = this.newPartition(t, "today");
        long blockingTxn = this.openTxn();
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 21L, 1);
        this.addDeltaFile(t, p, 22L, 22L, 1);
        this.burnThroughTransactions(dbName, tblName, 22);
        CompactionRequest rqst = new CompactionRequest(dbName, tblName, CompactionType.MINOR);
        rqst.setPartitionname(partName);
        long compactTxn = this.compactInTxn(rqst);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.txnHandler.addWriteIdsToMinHistory(1L, Collections.singletonMap("default.trfcp", 23L));
        this.startCleaner();
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((String)("Expected 4 files after minor compaction, instead these files were present " + paths), (long)4L, (long)paths.size());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)("Expected 1 compaction in queue, got: " + rsp.getCompacts()), (long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((Object)CompactionType.MINOR, (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getType());
        this.addDeltaFile(t, p, 23L, 23L, 1);
        this.addDeltaFile(t, p, 24L, 24L, 1);
        this.burnThroughTransactions(dbName, tblName, 2, null, new HashSet<Long>(Collections.singletonList(compactTxn + 1L)));
        rqst = new CompactionRequest(dbName, tblName, CompactionType.MAJOR);
        rqst.setPartitionname(partName);
        compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, p, 24L, 24, compactTxn);
        this.startCleaner();
        paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((String)("Expected 7 files after minor compaction, instead these files were present " + paths), (long)7L, (long)paths.size());
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)("Expected 2 compactions in queue, got: " + rsp.getCompacts()), (long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(1)).getState());
        this.txnHandler.commitTxn(new CommitTxnRequest(blockingTxn));
        this.startCleaner();
        this.startCleaner();
        paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)1L, (long)paths.size());
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)("Expected 2 compactions in queue, got: " + rsp.getCompacts()), (long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(1)).getState());
    }

    @Override
    boolean useHive130DeltaDirName() {
        return false;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.compactorTestCleanup();
    }

    @Test
    public void noCleanupAfterMajorCompaction() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("no_cleanup", "true");
        Table t = this.newTable("default", "dcamc", false, parameters);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.addDeltaFile(t, null, 23L, 24L, 2);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dcamc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamc", CompactionType.MAJOR);
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)4L, (long)paths.size());
        t = this.ms.getTable(new GetTableRequest("default", "dcamc"));
        t.getParameters().put("no_cleanup", "false");
        this.ms.alter_table("default", "dcamc", t);
        rqst = new CompactionRequest("default", "dcamc", CompactionType.MAJOR);
        this.compactInTxn(rqst);
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_25", (Object)paths.get(0).getName());
    }

    @Test
    public void noCleanupAfterMinorCompactionOnPartition() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("NO_CLEANUP", "True");
        Table t = this.newTable("default", "dcamicop", true);
        Partition p = this.newPartition(t, "today", null, parameters);
        this.addBaseFile(t, p, 20L, 20);
        this.addDeltaFile(t, p, 21L, 22L, 2);
        this.addDeltaFile(t, p, 23L, 24L, 2);
        this.addDeltaFile(t, p, 21L, 24L, 4);
        this.burnThroughTransactions("default", "dcamicop", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamicop", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"refused", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)4L, (long)paths.size());
        ArrayList<String> list = new ArrayList<String>();
        list.add("ds=today");
        p = this.ms.getPartition("default", "dcamicop", "ds=today");
        p.getParameters().put("NO_CLEANUP", "false");
        this.ms.alter_partition("default", "dcamicop", p);
        rqst = new CompactionRequest("default", "dcamicop", CompactionType.MINOR);
        rqst.setPartitionname("ds=today");
        this.compactInTxn(rqst);
        this.startCleaner();
        rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((long)2L, (long)paths.size());
        boolean sawBase = false;
        boolean sawDelta = false;
        for (Path path : paths) {
            if (path.getName().equals("base_20")) {
                sawBase = true;
                continue;
            }
            if (path.getName().equals(this.makeDeltaDirNameCompacted(21L, 24L))) {
                sawDelta = true;
                continue;
            }
            Assert.fail((String)("Unexpected file " + path.getName()));
        }
        Assert.assertTrue((boolean)sawBase);
        Assert.assertTrue((boolean)sawDelta);
    }

    @Test
    public void withSingleBaseCleanerSucceeds() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Table t = this.newTable("default", "dcamc", false, parameters);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dcamc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamc", CompactionType.MAJOR);
        this.compactInTxn(rqst);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
    }

    @Test
    public void withNewerBaseCleanerSucceeds() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Table t = this.newTable("default", "dcamc", false, parameters);
        this.addBaseFile(t, null, 25L, 25);
        this.burnThroughTransactions("default", "dcamc", 25);
        CompactionRequest rqst = new CompactionRequest("default", "dcamc", CompactionType.MAJOR);
        this.compactInTxn(rqst);
        this.burnThroughTransactions("default", "dcamc", 1);
        this.addBaseFile(t, null, 26L, 26);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)2L, (long)paths.size());
    }

    @Test
    public void withNotYetVisibleBase() throws Exception {
        String dbName = "default";
        String tableName = "camtc";
        Table t = this.newTable(dbName, tableName, false);
        this.addBaseFile(t, null, 20L, 20);
        this.burnThroughTransactions(dbName, tableName, 25);
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, CompactionType.MAJOR);
        long compactTxn = this.compactInTxn(rqst);
        this.addBaseFile(t, null, 25L, 25, compactTxn);
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
    }

    @Test
    public void cleanMultipleTimesWithSameWatermark() throws Exception {
        String dbName = "default";
        String tableName = "camtc";
        Table t = this.newTable(dbName, tableName, false);
        this.addBaseFile(t, null, 20L, 20);
        this.addDeltaFile(t, null, 21L, 22L, 2);
        this.burnThroughTransactions(dbName, tableName, 22);
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, CompactionType.MAJOR);
        this.addBaseFile(t, null, 22L, 22);
        this.compactInTxn(rqst);
        CompactionResponse response = this.txnHandler.compact(rqst);
        Assert.assertFalse((boolean)response.isAccepted());
        Assert.assertEquals((Object)"Compaction is already scheduled with state='ready for cleaning' and id=1", (Object)response.getErrormessage());
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_22", (Object)paths.get(0).getName());
    }

    @Test
    public void nothingToCleanAfterAbortsBase() throws Exception {
        String dbName = "default";
        String tableName = "camtc";
        Table t = this.newTable(dbName, tableName, false);
        this.addBaseFile(t, null, 20L, 1);
        this.addDeltaFile(t, null, 21L, 21L, 2);
        this.addDeltaFile(t, null, 22L, 22L, 2);
        this.burnThroughTransactions(dbName, tableName, 22, null, new HashSet<Long>(Arrays.asList(21L, 22L)));
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, CompactionType.MAJOR);
        this.compactInTxn(rqst);
        CompactionResponse response = this.txnHandler.compact(rqst);
        Assert.assertFalse((boolean)response.isAccepted());
        Assert.assertEquals((Object)"Compaction is already scheduled with state='ready for cleaning' and id=1", (Object)response.getErrormessage());
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)"base_20", (Object)paths.get(0).getName());
    }

    @Test
    public void nothingToCleanAfterAbortsDelta() throws Exception {
        String dbName = "default";
        String tableName = "camtc";
        Table t = this.newTable(dbName, tableName, false);
        this.addDeltaFile(t, null, 20L, 20L, 1);
        this.addDeltaFile(t, null, 21L, 21L, 2);
        this.addDeltaFile(t, null, 22L, 22L, 2);
        this.burnThroughTransactions(dbName, tableName, 22, null, new HashSet<Long>(Arrays.asList(21L, 22L)));
        CompactionRequest rqst = new CompactionRequest(dbName, tableName, CompactionType.MAJOR);
        this.compactInTxn(rqst);
        CompactionResponse response = this.txnHandler.compact(rqst);
        Assert.assertFalse((boolean)response.isAccepted());
        Assert.assertEquals((Object)"Compaction is already scheduled with state='ready for cleaning' and id=1", (Object)response.getErrormessage());
        this.startCleaner();
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        List<Path> paths = this.getDirectories(this.conf, t, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        Assert.assertEquals((Object)this.makeDeltaDirName(20L, 20L), (Object)paths.get(0).getName());
    }

    @Test
    public void testReady() throws Exception {
        String dbName = "default";
        String tblName = "trfcp";
        String partName = "ds=today";
        Table t = this.newTable(dbName, tblName, true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 19L, 19);
        this.addDeltaFile(t, p, 20L, 20L, 1);
        this.addDeltaFile(t, p, 21L, 21L, 1);
        this.addDeltaFile(t, p, 22L, 22L, 1);
        this.burnThroughTransactions(dbName, tblName, 22);
        long txnId = this.openTxn();
        if (this.useMinHistoryWriteId()) {
            this.allocateTableWriteId(dbName, tblName, txnId);
        }
        CompactionRequest rqst = new CompactionRequest(dbName, tblName, CompactionType.MINOR);
        rqst.setPartitionname(partName);
        long ctxnid = this.compactInTxn(rqst);
        this.addDeltaFile(t, p, 20L, 22L, 2, ctxnid);
        this.startCleaner();
        List<Path> paths = this.getDirectories(this.conf, t, p);
        Assert.assertEquals((String)("Expected 5 files after minor compaction, instead these files were present " + paths), (long)5L, (long)paths.size());
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((String)("Expected 1 compaction in queue, got: " + rsp.getCompacts()), (long)1L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
    }

    @Test
    public void testCompactionHighWatermarkIsHonored() throws Exception {
        String dbName = "default";
        String tblName = "trfcp";
        String partName = "ds=today";
        Table t = this.newTable(dbName, tblName, true);
        Partition p = this.newPartition(t, "today");
        this.addBaseFile(t, p, 19L, 19);
        this.addDeltaFile(t, p, 20L, 20L, 1);
        this.addDeltaFile(t, p, 21L, 21L, 1);
        this.addDeltaFile(t, p, 22L, 22L, 1);
        this.burnThroughTransactions(dbName, tblName, 22);
        CompactionRequest rqst = new CompactionRequest(dbName, tblName, CompactionType.MINOR);
        rqst.setPartitionname(partName);
        long ctxnid = this.compactInTxn(rqst);
        this.addDeltaFile(t, p, 20L, 22L, 3, ctxnid);
        long openTxnId = this.openTxn();
        this.addDeltaFile(t, p, 23L, 23L, 1);
        this.addDeltaFile(t, p, 24L, 24L, 1);
        this.burnThroughTransactions(dbName, tblName, 2);
        rqst = new CompactionRequest(dbName, tblName, CompactionType.MINOR);
        rqst.setPartitionname(partName);
        ctxnid = this.compactInTxn(rqst);
        this.addDeltaFile(t, p, 20L, 24L, 5, ctxnid);
        this.startCleaner();
        this.txnHandler.abortTxn(new AbortTxnRequest(openTxnId));
        ShowCompactResponse rsp = this.txnHandler.showCompact(new ShowCompactRequest());
        Assert.assertEquals((long)2L, (long)rsp.getCompactsSize());
        Assert.assertEquals((Object)"succeeded", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(0)).getState());
        Assert.assertEquals((Object)"ready for cleaning", (Object)((ShowCompactResponseElement)rsp.getCompacts().get(1)).getState());
        List actualDirs = this.getDirectories(this.conf, t, p).stream().map(Path::getName).sorted().collect(Collectors.toList());
        List<String> expectedDirs = Arrays.asList("base_19", AcidUtils.addVisibilitySuffix((String)this.makeDeltaDirName(20L, 22L), (long)23L), AcidUtils.addVisibilitySuffix((String)this.makeDeltaDirName(20L, 24L), (long)27L), this.makeDeltaDirName(23L, 23L), this.makeDeltaDirName(24L, 24L));
        Assert.assertEquals((String)"Directories do not match", expectedDirs, actualDirs);
    }

    private void allocateTableWriteId(String dbName, String tblName, long txnId) throws Exception {
        AllocateTableWriteIdsRequest awiRqst = new AllocateTableWriteIdsRequest(dbName, tblName);
        awiRqst.setTxnIds(Collections.singletonList(txnId));
        AllocateTableWriteIdsResponse awiResp = this.txnHandler.allocateTableWriteIds(awiRqst);
        this.txnHandler.addWriteIdsToMinHistory(txnId, Collections.singletonMap(dbName + "." + tblName, ((TxnToWriteId)awiResp.getTxnToWriteIds().get(0)).getWriteId()));
    }
}

