/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.AcidMetricService;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.txn.compactor.Cleaner;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorTestUtilities;
import org.apache.hadoop.hive.ql.txn.compactor.Initiator;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.thrift.TException;
import org.junit.Before;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactorTest {
    private static final String CLASS_NAME = CompactorTest.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    public static final String WORKER_VERSION = HiveVersionInfo.getShortVersion();
    private static final AtomicInteger TMP_DIR_ID = new AtomicInteger();
    protected TxnStore txnHandler;
    protected IMetaStoreClient ms;
    protected HiveConf conf;
    private final AtomicBoolean stop = new AtomicBoolean();
    private Path tmpdir;
    FileSystem fs;

    @Before
    @BeforeEach
    public void setup() throws Exception {
        this.setup(new HiveConf());
    }

    protected final void setup(HiveConf conf) throws Exception {
        this.conf = conf;
        this.fs = FileSystem.get((Configuration)conf);
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (long)2L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_WRITE_ID, (boolean)this.useMinHistoryWriteId());
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER, (boolean)true);
        TestTxnDbUtil.setConfValues((Configuration)conf);
        TestTxnDbUtil.cleanDb((Configuration)conf);
        TestTxnDbUtil.prepDb((Configuration)conf);
        this.ms = new HiveMetaStoreClient((Configuration)conf);
        this.txnHandler = TxnUtils.getTxnStore((Configuration)conf);
        Path tmpPath = new Path(System.getProperty("test.tmp.dir"), "compactor_test_table_" + TMP_DIR_ID.getAndIncrement());
        this.fs.mkdirs(tmpPath);
        this.tmpdir = this.fs.resolvePath(tmpPath);
    }

    protected void compactorTestCleanup() throws IOException {
        this.fs.delete(this.tmpdir, true);
    }

    protected void startInitiator() throws Exception {
        this.runOneLoopOfCompactorThread(CompactorTestUtilities.CompactorThreadType.INITIATOR);
    }

    protected void startWorker() throws Exception {
        this.runOneLoopOfCompactorThread(CompactorTestUtilities.CompactorThreadType.WORKER);
    }

    protected void startCleaner() throws Exception {
        this.runOneLoopOfCompactorThread(CompactorTestUtilities.CompactorThreadType.CLEANER);
    }

    protected void runAcidMetricService() {
        TestTxnDbUtil.setConfValues((Configuration)this.conf);
        AcidMetricService t = new AcidMetricService();
        t.setConf((Configuration)this.conf);
        t.run();
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned) throws TException {
        return this.newTable(dbName, tableName, partitioned, new HashMap<String, String>(), null, false);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned, Map<String, String> parameters) throws TException {
        return this.newTable(dbName, tableName, partitioned, parameters, null, false);
    }

    protected Table newTable(String dbName, String tableName, boolean partitioned, Map<String, String> parameters, List<Order> sortCols, boolean isTemporary) throws TException {
        Table table = new Table();
        table.setTableType(TableType.MANAGED_TABLE.name());
        table.setTableName(tableName);
        table.setDbName(dbName);
        table.setOwner("me");
        table.setSd(this.newStorageDescriptor(this.getLocation(tableName, null), sortCols));
        ArrayList<FieldSchema> partKeys = new ArrayList<FieldSchema>(1);
        if (partitioned) {
            partKeys.add(new FieldSchema("ds", "string", "no comment"));
            table.setPartitionKeys(partKeys);
        }
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("transactional", "true");
        if (sortCols != null) {
            parameters.put("transactional_properties", "insert_only");
        }
        table.setParameters(parameters);
        if (isTemporary) {
            table.setTemporary(true);
        }
        this.ms.dropTable(dbName, tableName);
        this.ms.createTable(table);
        return table;
    }

    protected Partition newPartition(Table t, String value) throws Exception {
        return this.newPartition(t, value, null);
    }

    protected Partition newPartition(Table t, String value, List<Order> sortCols) throws Exception {
        return this.newPartition(t, value, sortCols, new HashMap<String, String>());
    }

    protected Partition newPartition(Table t, String value, List<Order> sortCols, Map<String, String> parameters) throws Exception {
        Partition part = new Partition();
        part.addToValues(value);
        part.setDbName(t.getDbName());
        part.setTableName(t.getTableName());
        part.setSd(this.newStorageDescriptor(this.getLocation(t.getTableName(), value), sortCols));
        part.setParameters(parameters);
        this.ms.add_partition(part);
        return part;
    }

    protected long openTxn() throws MetaException {
        return this.openTxn(TxnType.DEFAULT);
    }

    protected long openTxn(TxnType txnType) throws MetaException {
        OpenTxnRequest rqst = new OpenTxnRequest(1, System.getProperty("user.name"), ServerUtils.hostname());
        rqst.setTxn_type(txnType);
        if (txnType == TxnType.REPL_CREATED) {
            rqst.setReplPolicy("default.*");
            rqst.setReplSrcTxnIds(Arrays.asList(1L));
        }
        List txns = this.txnHandler.openTxns(rqst).getTxn_ids();
        return (Long)txns.get(0);
    }

    protected long allocateWriteId(String dbName, String tblName, long txnid) throws MetaException, TxnAbortedException, NoSuchTxnException {
        AllocateTableWriteIdsRequest awiRqst = new AllocateTableWriteIdsRequest(dbName, tblName);
        awiRqst.setTxnIds(Collections.singletonList(txnid));
        AllocateTableWriteIdsResponse awiResp = this.txnHandler.allocateTableWriteIds(awiRqst);
        return ((TxnToWriteId)awiResp.getTxnToWriteIds().get(0)).getWriteId();
    }

    protected void addDeltaFileWithTxnComponents(Table t, Partition p, int numRecords, boolean abort) throws Exception {
        long txnId = this.openTxn();
        long writeId = this.ms.allocateTableWriteId(txnId, t.getDbName(), t.getTableName());
        this.acquireLock(t, p, txnId);
        this.addDeltaFile(t, p, writeId, writeId, numRecords);
        if (abort) {
            this.txnHandler.abortTxns(new AbortTxnsRequest(Collections.singletonList(txnId)));
        } else {
            this.txnHandler.commitTxn(new CommitTxnRequest(txnId));
        }
    }

    protected void acquireLock(Table t, Partition p, long txnId) throws Exception {
        LockComponentBuilder lockCompBuilder = new LockComponentBuilder().setLock(LockType.SHARED_WRITE).setOperationType(DataOperationType.INSERT).setDbName(t.getDbName()).setTableName(t.getTableName()).setIsTransactional(true);
        if (p != null) {
            lockCompBuilder.setPartitionName(((FieldSchema)t.getPartitionKeys().get(0)).getName() + "=" + (String)p.getValues().get(0));
        }
        LockRequestBuilder requestBuilder = new LockRequestBuilder().setUser(null).setTransactionId(txnId).addLockComponent(lockCompBuilder.build());
        requestBuilder.setZeroWaitReadEnabled(!this.conf.getBoolVar(HiveConf.ConfVars.TXN_OVERWRITE_X_LOCK) || !this.conf.getBoolVar(HiveConf.ConfVars.TXN_WRITE_X_LOCK));
        this.ms.lock(requestBuilder.build());
    }

    protected void addDeltaFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.DELTA, 2, true);
    }

    protected void addLengthFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.LENGTH_FILE, 2, true);
    }

    protected void addBaseFile(Table t, Partition p, long maxTxn, int numRecords) throws Exception {
        this.addFile(t, p, 0L, maxTxn, numRecords, FileType.BASE, 2, true);
    }

    protected void addBaseFile(Table t, Partition p, long maxTxn, int numRecords, long visibilityId) throws Exception {
        this.addFile(t, p, 0L, maxTxn, numRecords, FileType.BASE, 2, true, visibilityId);
    }

    protected void addLegacyFile(Table t, Partition p, int numRecords) throws Exception {
        this.addFile(t, p, 0L, 0L, numRecords, FileType.LEGACY, 2, true);
    }

    protected void addDeltaFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords, long visibilityId) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.DELTA, 2, true, visibilityId);
    }

    protected void addDeltaFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, FileType.DELTA, numBuckets, allBucketsPresent);
    }

    protected void addBaseFile(Table t, Partition p, long maxTxn, int numRecords, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(t, p, 0L, maxTxn, numRecords, FileType.BASE, numBuckets, allBucketsPresent);
    }

    protected List<Path> getDirectories(HiveConf conf, Table t, Partition p) throws Exception {
        String partValue = p == null ? null : (String)p.getValues().get(0);
        String location = this.getLocation(t.getTableName(), partValue);
        Path dir = new Path(location);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] stats = fs.listStatus(dir);
        ArrayList<Path> paths = new ArrayList<Path>(stats.length);
        for (int i = 0; i < stats.length; ++i) {
            paths.add(stats[i].getPath());
        }
        return paths;
    }

    protected void burnThroughTransactions(String dbName, String tblName, int num) throws MetaException, NoSuchTxnException, TxnAbortedException {
        this.burnThroughTransactions(dbName, tblName, num, null, null);
    }

    protected void burnThroughTransactions(String dbName, String tblName, int num, Set<Long> open, Set<Long> aborted) throws NoSuchTxnException, TxnAbortedException, MetaException {
        this.burnThroughTransactions(dbName, tblName, num, open, aborted, null);
    }

    protected void burnThroughTransactions(String dbName, String tblName, int num, Set<Long> open, Set<Long> aborted, LockRequest lockReq) throws MetaException, NoSuchTxnException, TxnAbortedException {
        OpenTxnsResponse rsp = this.txnHandler.openTxns(new OpenTxnRequest(num, "me", "localhost"));
        AllocateTableWriteIdsRequest awiRqst = new AllocateTableWriteIdsRequest(dbName, tblName);
        awiRqst.setTxnIds(rsp.getTxn_ids());
        AllocateTableWriteIdsResponse awiResp = this.txnHandler.allocateTableWriteIds(awiRqst);
        long minOpenWriteId = Long.MAX_VALUE;
        if (open != null && this.useMinHistoryWriteId()) {
            long minOpenTxnId = open.stream().mapToLong(v -> v).min().orElse(-1L);
            minOpenWriteId = awiResp.getTxnToWriteIds().stream().filter(v -> v.getTxnId() == minOpenTxnId).map(TxnToWriteId::getWriteId).findFirst().orElse(minOpenWriteId);
        }
        int i = 0;
        Iterator iterator = rsp.getTxn_ids().iterator();
        while (iterator.hasNext()) {
            long tid = (Long)iterator.next();
            assert (((TxnToWriteId)awiResp.getTxnToWriteIds().get(i)).getTxnId() == tid);
            ++i;
            if (lockReq != null) {
                lockReq.setTxnid(tid);
                this.txnHandler.lock(lockReq);
            }
            if (aborted != null && aborted.contains(tid)) {
                this.txnHandler.abortTxn(new AbortTxnRequest(tid));
                continue;
            }
            if (open == null || !open.contains(tid)) {
                this.txnHandler.commitTxn(new CommitTxnRequest(tid));
                continue;
            }
            if (!open.contains(tid) || !this.useMinHistoryWriteId()) continue;
            this.txnHandler.addWriteIdsToMinHistory(tid, Collections.singletonMap(dbName + "." + tblName, minOpenWriteId));
        }
    }

    protected void stopThread() {
        this.stop.set(true);
    }

    private StorageDescriptor newStorageDescriptor(String location, List<Order> sortCols) {
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(2);
        cols.add(new FieldSchema("a", "varchar(25)", "still no comment"));
        cols.add(new FieldSchema("b", "int", "comment"));
        sd.setCols(cols);
        sd.setLocation(location);
        sd.setInputFormat(MockInputFormat.class.getName());
        sd.setOutputFormat(MockOutputFormat.class.getName());
        sd.setNumBuckets(1);
        SerDeInfo serde = new SerDeInfo();
        serde.setSerializationLib(LazySimpleSerDe.class.getName());
        sd.setSerdeInfo(serde);
        ArrayList<String> bucketCols = new ArrayList<String>(1);
        bucketCols.add("a");
        sd.setBucketCols(bucketCols);
        if (sortCols != null) {
            sd.setSortCols(sortCols);
        }
        return sd;
    }

    private void runOneLoopOfCompactorThread(CompactorTestUtilities.CompactorThreadType type) throws Exception {
        TestTxnDbUtil.setConfValues((Configuration)this.conf);
        Initiator t = switch (type) {
            case CompactorTestUtilities.CompactorThreadType.INITIATOR -> new Initiator();
            case CompactorTestUtilities.CompactorThreadType.WORKER -> new Worker();
            case CompactorTestUtilities.CompactorThreadType.CLEANER -> new Cleaner();
            default -> throw new RuntimeException("Huh? Unknown thread type.");
        };
        t.setConf((Configuration)this.conf);
        this.stop.set(true);
        t.init(this.stop);
        t.run();
    }

    private String getLocation(String tableName, String partValue) {
        Path tblLocation = new Path(this.tmpdir, tableName);
        if (partValue != null) {
            tblLocation = new Path(tblLocation, "ds=" + partValue);
        }
        return tblLocation.toString();
    }

    private void addFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords, FileType type, int numBuckets, boolean allBucketsPresent) throws Exception {
        this.addFile(t, p, minTxn, maxTxn, numRecords, type, numBuckets, allBucketsPresent, 0L);
    }

    private void addFile(Table t, Partition p, long minTxn, long maxTxn, int numRecords, FileType type, int numBuckets, boolean allBucketsPresent, long visibilityId) throws Exception {
        String partValue = p == null ? null : (String)p.getValues().get(0);
        Path location = new Path(this.getLocation(t.getTableName(), partValue));
        String filename = null;
        switch (type) {
            case BASE: {
                filename = AcidUtils.addVisibilitySuffix((String)("base_" + maxTxn), (long)visibilityId);
                break;
            }
            case LENGTH_FILE: 
            case DELTA: {
                filename = AcidUtils.addVisibilitySuffix((String)this.makeDeltaDirName(minTxn, maxTxn), (long)visibilityId);
                break;
            }
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        for (int bucket = 0; bucket < numBuckets; ++bucket) {
            if (bucket == 0 && !allBucketsPresent) continue;
            Path partFile = null;
            if (type == FileType.LEGACY) {
                partFile = new Path(location, String.format("%06d", bucket) + "_0");
            } else {
                Path dir = new Path(location, filename);
                fs.mkdirs(dir);
                partFile = AcidUtils.createBucketFile((Path)dir, (int)bucket);
                if (type == FileType.LENGTH_FILE) {
                    partFile = new Path(partFile.toString() + "_flush_length");
                }
            }
            FSDataOutputStream out = fs.create(partFile);
            if (type == FileType.LENGTH_FILE) {
                out.writeInt(numRecords);
            } else {
                for (int i = 0; i < numRecords; ++i) {
                    RecordIdentifier ri = new RecordIdentifier(maxTxn - 1L, bucket, (long)i);
                    ri.write((DataOutput)out);
                    out.writeBytes("mary had a little lamb its fleece was white as snow\n");
                }
            }
            out.close();
        }
    }

    abstract boolean useHive130DeltaDirName();

    protected boolean useMinHistoryWriteId() {
        return false;
    }

    String makeDeltaDirName(long minTxnId, long maxTxnId) {
        if (minTxnId != maxTxnId) {
            return this.makeDeltaDirNameCompacted(minTxnId, maxTxnId);
        }
        return this.useHive130DeltaDirName() ? AcidUtils.deltaSubdir((long)minTxnId, (long)maxTxnId, (int)0) : AcidUtils.deltaSubdir((long)minTxnId, (long)maxTxnId);
    }

    String makeDeltaDirNameCompacted(long minTxnId, long maxTxnId) {
        return AcidUtils.deltaSubdir((long)minTxnId, (long)maxTxnId);
    }

    String makeDeleteDeltaDirNameCompacted(long minTxnId, long maxTxnId) {
        return AcidUtils.deleteDeltaSubdir((long)minTxnId, (long)maxTxnId);
    }

    protected long compactInTxn(CompactionRequest rqst) throws Exception {
        this.txnHandler.compact(rqst);
        FindNextCompactRequest findNextCompactRequest = new FindNextCompactRequest();
        findNextCompactRequest.setWorkerId("fred");
        findNextCompactRequest.setWorkerVersion(WORKER_VERSION);
        CompactionInfo ci = this.txnHandler.findNextToCompact(findNextCompactRequest);
        ci.runAs = rqst.getRunas() == null ? System.getProperty("user.name") : rqst.getRunas();
        long compactorTxnId = this.openTxn(TxnType.COMPACTION);
        ValidTxnList validTxnList = TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.txnHandler.getOpenTxns(), (long)compactorTxnId);
        GetValidWriteIdsRequest writeIdsRequest = new GetValidWriteIdsRequest();
        writeIdsRequest.setValidTxnList(validTxnList.writeToString());
        writeIdsRequest.setFullTableNames(Collections.singletonList(TxnUtils.getFullTableName((String)rqst.getDbname(), (String)rqst.getTablename())));
        ValidCompactorWriteIdList tblValidWriteIds = TxnUtils.createValidCompactWriteIdList((TableValidWriteIds)((TableValidWriteIds)this.txnHandler.getValidWriteIds(writeIdsRequest).getTblValidWriteIds().get(0)));
        ci.highestWriteId = tblValidWriteIds.getHighWatermark();
        this.txnHandler.updateCompactorState(ci, compactorTxnId);
        this.txnHandler.markCompacted(ci);
        this.txnHandler.commitTxn(new CommitTxnRequest(compactorTxnId));
        Thread.sleep(MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_OPENTXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        return compactorTxnId;
    }

    protected static Map<String, Integer> gaugeToMap(String metric) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName oname = new ObjectName("metrics:type=compaction,name=" + metric);
        MBeanInfo mbeanInfo = mbs.getMBeanInfo(oname);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (MBeanAttributeInfo attr : mbeanInfo.getAttributes()) {
            Object attribute = mbs.getAttribute(oname, attr.getName());
            result.put(attr.getName(), Integer.valueOf(String.valueOf(attribute)));
        }
        return result;
    }

    private static enum FileType {
        BASE,
        DELTA,
        LEGACY,
        LENGTH_FILE;

    }

    static class MockInputFormat
    implements AcidInputFormat<WritableComparable, Text> {
        MockInputFormat() {
        }

        public AcidInputFormat.RowReader<Text> getReader(InputSplit split, AcidInputFormat.Options options) throws IOException {
            return null;
        }

        public AcidInputFormat.RawReader<Text> getRawReader(Configuration conf, boolean collapseEvents, int bucket, ValidWriteIdList validWriteIdList, Path baseDirectory, Path[] deltaDirectory, Map<String, Integer> deltaToAttemptId) throws IOException {
            ArrayList<Path> filesToRead = new ArrayList<Path>();
            if (baseDirectory != null) {
                if (baseDirectory.getName().startsWith("base_")) {
                    Path p = AcidUtils.createBucketFile((Path)baseDirectory, (int)bucket);
                    FileSystem fs = p.getFileSystem(conf);
                    if (fs.exists(p)) {
                        filesToRead.add(p);
                    }
                } else {
                    filesToRead.add(new Path(baseDirectory, "000000_0"));
                }
            }
            for (int i = 0; i < deltaDirectory.length; ++i) {
                Path p = AcidUtils.createBucketFile((Path)deltaDirectory[i], (int)bucket);
                FileSystem fs = p.getFileSystem(conf);
                if (!fs.exists(p)) continue;
                filesToRead.add(p);
            }
            return new MockRawReader(conf, filesToRead);
        }

        public InputSplit[] getSplits(JobConf entries, int i) throws IOException {
            return new InputSplit[0];
        }

        public RecordReader<WritableComparable, Text> getRecordReader(InputSplit inputSplit, JobConf entries, Reporter reporter) throws IOException {
            return null;
        }

        public boolean validateInput(FileSystem fs, HiveConf conf, List<FileStatus> files) throws IOException {
            return false;
        }
    }

    static class MockOutputFormat
    implements AcidOutputFormat<WritableComparable, Text> {
        MockOutputFormat() {
        }

        public RecordUpdater getRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
            return null;
        }

        public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
            return new MockRecordWriter(path, options);
        }

        public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
            return null;
        }

        public RecordWriter<WritableComparable, Text> getRecordWriter(FileSystem fileSystem, JobConf entries, String s, Progressable progressable) throws IOException {
            return null;
        }

        public void checkOutputSpecs(FileSystem fileSystem, JobConf entries) throws IOException {
        }
    }

    static class MockRecordWriter
    implements FileSinkOperator.RecordWriter {
        private final FSDataOutputStream os;

        MockRecordWriter(Path basedir, AcidOutputFormat.Options options) throws IOException {
            FileSystem fs = FileSystem.get((Configuration)options.getConfiguration());
            Path p = AcidUtils.createFilename((Path)basedir, (AcidOutputFormat.Options)options);
            this.os = fs.create(p);
        }

        public void write(Writable w) throws IOException {
            Text t = (Text)w;
            this.os.writeBytes(t.toString());
            this.os.writeBytes("\n");
        }

        public void close(boolean abort) throws IOException {
            this.os.close();
        }
    }

    static class MockRawReader
    implements AcidInputFormat.RawReader<Text> {
        private final Stack<Path> filesToRead = new Stack();
        private final Configuration conf;
        private FSDataInputStream is = null;
        private final FileSystem fs;
        private boolean lastWasDelete = true;

        MockRawReader(Configuration conf, List<Path> files) throws IOException {
            for (Path file : files) {
                this.filesToRead.push(file);
            }
            this.conf = conf;
            this.fs = FileSystem.get((Configuration)conf);
        }

        public ObjectInspector getObjectInspector() {
            return null;
        }

        public boolean isDelete(Text value) {
            this.lastWasDelete = !this.lastWasDelete;
            return this.lastWasDelete;
        }

        public boolean next(RecordIdentifier identifier, Text text) throws IOException {
            if (this.is == null) {
                if (this.filesToRead.empty()) {
                    return false;
                }
                Path p = this.filesToRead.pop();
                LOG.debug("Reading records from " + p.toString());
                this.is = this.fs.open(p);
            }
            String line = null;
            try {
                identifier.readFields((DataInput)this.is);
                line = this.is.readLine();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (line == null) {
                this.is = null;
                return this.next(identifier, text);
            }
            text.set(line);
            return true;
        }

        public RecordIdentifier createKey() {
            return new RecordIdentifier();
        }

        public Text createValue() {
            return new Text();
        }

        public long getPos() throws IOException {
            return 0L;
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException {
            return 0.0f;
        }
    }
}

