/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.mockito.Mockito;

public class CompactionQueryBuilderTestBase {
    public static final String DB_NAME = "comp_test_db";
    public static final String SOURCE_TABLE_NAME = "comp_test_source_table";
    public static final String RESULT_TABLE_NAME = "comp_test_result_table";
    public static final String COLUMN_1_NAME = "column_1";
    public static final String COLUMN_2_NAME = "column_2";
    public static final String COLUMN_3_NAME = "column_3";
    public static final String SOME_TEST_LOCATION = "some_test_path";
    public static final String COMP_TEST_SOURCE_TABLE_FOR_INSERT = "comp_test_db.comp_test_insert_table";

    public Table createSourceTable() {
        return this.createSourceTable(false, false, false);
    }

    public Table createSourceTableWithProperties() {
        return this.createSourceTable(true, false, false);
    }

    public Table createSourceTableBucketed() {
        return this.createSourceTable(false, true, false);
    }

    public Table createSourceTableBucketedSorted() {
        return this.createSourceTable(false, true, true);
    }

    private Table createSourceTable(boolean addTableProperties, boolean bucketed, boolean sorted) {
        Table sourceTable = new Table();
        sourceTable.setDbName(DB_NAME);
        sourceTable.setTableName(SOURCE_TABLE_NAME);
        StorageDescriptor sd = new StorageDescriptor();
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        FieldSchema col1 = new FieldSchema(COLUMN_1_NAME, "string", "First column");
        FieldSchema col2 = new FieldSchema(COLUMN_2_NAME, "int", null);
        FieldSchema col3 = new FieldSchema(COLUMN_3_NAME, "boolean", "Third column");
        columns.add(col1);
        columns.add(col2);
        columns.add(col3);
        sd.setCols(columns);
        if (bucketed) {
            sd.addToBucketCols(COLUMN_1_NAME);
            sd.addToBucketCols(COLUMN_3_NAME);
            sd.setNumBuckets(4);
        } else {
            sd.setBucketCols(Collections.emptyList());
        }
        if (sorted) {
            sd.addToSortCols(new Order(COLUMN_1_NAME, 0));
            sd.addToSortCols(new Order(COLUMN_2_NAME, 1));
        } else {
            sd.setSortCols(Collections.emptyList());
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (addTableProperties) {
            parameters.put("property_1", "true");
            parameters.put("orc.property_2", "44");
            parameters.put("COLUMN_STATS_ACCURATE", "false");
            parameters.put("columns.types", "test");
        }
        sourceTable.setParameters(parameters);
        sourceTable.setSd(sd);
        return sourceTable;
    }

    protected AcidDirectory createAcidDirectory() {
        AcidDirectory dir = (AcidDirectory)Mockito.mock(AcidDirectory.class);
        AcidUtils.ParsedDelta d1 = (AcidUtils.ParsedDelta)Mockito.mock(AcidUtils.ParsedDelta.class);
        AcidUtils.ParsedDelta d2 = (AcidUtils.ParsedDelta)Mockito.mock(AcidUtils.ParsedDelta.class);
        AcidUtils.ParsedDelta d3 = (AcidUtils.ParsedDelta)Mockito.mock(AcidUtils.ParsedDelta.class);
        AcidUtils.ParsedDelta d4 = (AcidUtils.ParsedDelta)Mockito.mock(AcidUtils.ParsedDelta.class);
        AcidUtils.ParsedDelta d5 = (AcidUtils.ParsedDelta)Mockito.mock(AcidUtils.ParsedDelta.class);
        ArrayList<AcidUtils.ParsedDelta> dirs = new ArrayList<AcidUtils.ParsedDelta>();
        dirs.add(d1);
        dirs.add(d2);
        dirs.add(d3);
        dirs.add(d4);
        dirs.add(d5);
        Mockito.when((Object)dir.getCurrentDirectories()).thenReturn(dirs);
        Mockito.when((Object)d1.isDeleteDelta()).thenReturn((Object)true);
        Mockito.when((Object)d1.getMinWriteId()).thenReturn((Object)7L);
        Mockito.when((Object)d1.getMaxWriteId()).thenReturn((Object)11L);
        Mockito.when((Object)d1.getPath()).thenReturn((Object)new Path("/compaction/test/table", "test_delta_1"));
        Mockito.when((Object)d2.isDeleteDelta()).thenReturn((Object)true);
        Mockito.when((Object)d2.getMinWriteId()).thenReturn((Object)1L);
        Mockito.when((Object)d2.getMaxWriteId()).thenReturn((Object)11L);
        Mockito.when((Object)d2.getPath()).thenReturn((Object)new Path("/compaction/test/table", "test_delta_2"));
        Mockito.when((Object)d3.isDeleteDelta()).thenReturn((Object)true);
        Mockito.when((Object)d3.getMinWriteId()).thenReturn((Object)5L);
        Mockito.when((Object)d3.getMaxWriteId()).thenReturn((Object)15L);
        Mockito.when((Object)d3.getPath()).thenReturn((Object)new Path("/compaction/test/table", "test_delta_3"));
        Mockito.when((Object)d4.isDeleteDelta()).thenReturn((Object)true);
        Mockito.when((Object)d4.getMinWriteId()).thenReturn((Object)7L);
        Mockito.when((Object)d4.getMaxWriteId()).thenReturn((Object)20L);
        Mockito.when((Object)d4.getPath()).thenReturn((Object)new Path("/compaction/test/table", "test_delta_4"));
        Mockito.when((Object)d5.isDeleteDelta()).thenReturn((Object)false);
        Mockito.when((Object)d5.getMinWriteId()).thenReturn((Object)6L);
        Mockito.when((Object)d5.getMaxWriteId()).thenReturn((Object)11L);
        Mockito.when((Object)d5.getPath()).thenReturn((Object)new Path("/compaction/test/table", "test_delta_5"));
        return dir;
    }

    protected ValidCompactorWriteIdList createWriteId(long minWriteId) {
        long[] abortedWriteIdList = new long[]{1111L};
        return new ValidCompactorWriteIdList(SOURCE_TABLE_NAME, abortedWriteIdList, null, 15L, minWriteId);
    }
}

