/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.tool;

import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.tools.LineageInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLineageInfo {
    private Context ctx;

    @Before
    public void before() {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        SessionState.start((HiveConf)conf);
        this.ctx = new Context((Configuration)conf);
    }

    @After
    public void after() throws Exception {
        SessionState.get().close();
    }

    private void checkOutput(LineageInfo lep, TreeSet<String> i, TreeSet<String> o) {
        if (!i.equals(lep.getInputTableList())) {
            Assert.fail((String)"Input table not same");
        }
        if (!o.equals(lep.getOutputTableList())) {
            Assert.fail((String)"Output table not same");
        }
    }

    @Test
    public void testSimpleQuery() {
        LineageInfo lep = new LineageInfo();
        try {
            lep.getLineageInfo("INSERT OVERWRITE TABLE dest1 partition (ds = '111')  SELECT s.* FROM srcpart TABLESAMPLE (BUCKET 1 OUT OF 1) s WHERE s.ds='2008-04-08' and s.hr='11'", this.ctx);
            TreeSet<String> i = new TreeSet<String>();
            TreeSet<String> o = new TreeSet<String>();
            i.add("srcpart");
            o.add("dest1");
            this.checkOutput(lep, i, o);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Failed");
        }
    }

    @Test
    public void testSimpleQuery2() throws Exception {
        LineageInfo lep = new LineageInfo();
        lep.getLineageInfo("FROM (FROM src select src.key, src.value WHERE src.key < 10 UNION ALL FROM src SELECT src.* WHERE src.key > 10 ) unioninput INSERT OVERWRITE DIRECTORY '../../../../build/contrib/hive/ql/test/data/warehouse/union.out' SELECT unioninput.*", this.ctx);
        TreeSet<String> i = new TreeSet<String>();
        TreeSet<String> o = new TreeSet<String>();
        i.add("src");
        this.checkOutput(lep, i, o);
    }

    @Test
    public void testSimpleQuery3() throws Exception {
        LineageInfo lep = new LineageInfo();
        lep.getLineageInfo("FROM (FROM src select src.key, src.value WHERE src.key < 10 UNION ALL FROM src1 SELECT src1.* WHERE src1.key > 10 ) unioninput INSERT OVERWRITE DIRECTORY '../../../../build/contrib/hive/ql/test/data/warehouse/union.out' SELECT unioninput.*", this.ctx);
        TreeSet<String> i = new TreeSet<String>();
        TreeSet<String> o = new TreeSet<String>();
        i.add("src");
        i.add("src1");
        this.checkOutput(lep, i, o);
    }

    @Test
    public void testSimpleQuery4() {
        LineageInfo lep = new LineageInfo();
        try {
            lep.getLineageInfo("FROM ( FROM ( FROM src1 src1 SELECT src1.key AS c1, src1.value AS c2 WHERE src1.key > 10 and src1.key < 20) a RIGHT OUTER JOIN ( FROM src2 src2 SELECT src2.key AS c3, src2.value AS c4 WHERE src2.key > 15 and src2.key < 25) b ON (a.c1 = b.c3) SELECT a.c1 AS c1, a.c2 AS c2, b.c3 AS c3, b.c4 AS c4) c SELECT c.c1, c.c2, c.c3, c.c4", this.ctx);
            TreeSet<String> i = new TreeSet<String>();
            TreeSet<String> o = new TreeSet<String>();
            i.add("src1");
            i.add("src2");
            this.checkOutput(lep, i, o);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Failed");
        }
    }

    @Test
    public void testSimpleQuery5() {
        LineageInfo lep = new LineageInfo();
        try {
            lep.getLineageInfo("insert overwrite table x select a.y, b.y from a a full outer join b b on (a.x = b.y)", this.ctx);
            TreeSet<String> i = new TreeSet<String>();
            TreeSet<String> o = new TreeSet<String>();
            i.add("a");
            i.add("b");
            o.add("x");
            this.checkOutput(lep, i, o);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Failed");
        }
    }
}

