/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.testutil;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;

public class OperatorTestUtils {
    public static ExprNodeColumnDesc getStringColumn(String columnName) {
        return new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, columnName, "", false);
    }

    public static List<String> createOutputColumnNames(List<ExprNodeDesc> expressionList) {
        ArrayList<String> outputCols = new ArrayList<String>();
        for (int i = 0; i < expressionList.size(); ++i) {
            outputCols.add("_col" + i);
        }
        return outputCols;
    }

    public static void assertResults(Operator<SelectDesc> selectOp, CollectOperator collectOp, InspectableObject[] sourceData, InspectableObject[] expected) throws HiveException {
        InspectableObject resultRef = new InspectableObject();
        for (int i = 0; i < sourceData.length; ++i) {
            selectOp.process(sourceData[i].o, 0);
            collectOp.retrieve(resultRef);
            StructObjectInspector expectedOi = (StructObjectInspector)expected[i].oi;
            List expectedFields = expectedOi.getAllStructFieldRefs();
            StructObjectInspector destinationOi = (StructObjectInspector)resultRef.oi;
            List destinationFields = destinationOi.getAllStructFieldRefs();
            Assert.assertEquals((String)"Source and destination have differing numbers of fields ", (long)expectedFields.size(), (long)destinationFields.size());
            for (StructField field : expectedFields) {
                StructField dest = expectedOi.getStructFieldRef(field.getFieldName());
                Assert.assertNotNull((String)("Cound not find column named " + field.getFieldName()), (Object)dest);
                Assert.assertEquals((Object)field.getFieldObjectInspector(), (Object)dest.getFieldObjectInspector());
                Assert.assertEquals((String)("comparing " + expectedOi.getStructFieldData(expected[i].o, field) + " " + field.getFieldObjectInspector().getClass().getSimpleName() + " to " + destinationOi.getStructFieldData(resultRef.o, dest) + " " + dest.getFieldObjectInspector().getClass().getSimpleName()), (long)0L, (long)ObjectInspectorUtils.compare((Object)expectedOi.getStructFieldData(expected[i].o, field), (ObjectInspector)field.getFieldObjectInspector(), (Object)destinationOi.getStructFieldData(resultRef.o, dest), (ObjectInspector)dest.getFieldObjectInspector()));
            }
        }
        selectOp.close(false);
    }
}

